/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.pdf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class AbstractPDFCore {
    protected PDDocument document;
    protected byte[] rawDocument;

    public AbstractPDFCore(PDDocument doc) throws UtilsException {
        this.document = doc;
        if (this.document == null) {
            throw new UtilsException("Document undefined");
        }
    }

    public AbstractPDFCore(byte[] content, boolean saveRawDocument) throws UtilsException {
        try {
            if (saveRawDocument) {
                this.rawDocument = content;
            }
            this.document = PDDocument.load((byte[])content);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public AbstractPDFCore(InputStream is, boolean saveRawDocument) throws UtilsException {
        block8: {
            try {
                if (saveRawDocument) {
                    this.rawDocument = Utilities.getAsByteArray(is);
                    try (ByteArrayInputStream bin = new ByteArrayInputStream(this.rawDocument);){
                        this.document = PDDocument.load((InputStream)bin);
                        break block8;
                    }
                }
                this.document = PDDocument.load((InputStream)is);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    public AbstractPDFCore(File doc, boolean saveRawDocument) throws UtilsException {
        try {
            if (saveRawDocument) {
                this.rawDocument = FileSystemUtilities.readBytesFromFile(doc);
            }
            this.document = PDDocument.load((File)doc);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PDDocument getDocument() {
        return this.document;
    }

    protected void checkDocumentCatalog() throws UtilsException {
        if (this.document.getDocumentCatalog() == null) {
            throw new UtilsException("DocumentCatalog undefined");
        }
    }
}

