/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.openapi.validator;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.util.ByteArrayDataSource;
import java.util.List;
import org.openspcoop2.utils.mime.MimeMultipart;

public class MultipartUtilities {
    public static final String templateNumero = "NUMERO";

    public static MimeMultipart buildMimeMultipart(String subtype, String contentTxt, String contentTypeTxt, String nameTxt, String fileNameTxt, String contentJson, String contentTypeJson, String nameJson, String fileNameJson, byte[] contentPdf, String contentTypePdf, String namePdf, String fileNamePdf, byte[] contentPdf2, String contentTypePdf2, String namePdf2, String fileNamePdf2, byte[] contentOther, String contentTypeOther, String nameOther, String fileNameOther) throws Exception {
        String fileName;
        String hV;
        String ct;
        MimeMultipart mm = new MimeMultipart(subtype);
        if (contentTxt != null) {
            MimeBodyPart bodyTxt = new MimeBodyPart();
            ct = contentTypeTxt;
            if (ct == null) {
                ct = "text/plain";
            }
            bodyTxt.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(contentTxt.getBytes(), ct)));
            if (contentTypeTxt != null) {
                bodyTxt.addHeader("Content-Type", contentTypeTxt);
            }
            if (nameTxt != null) {
                if (!"".equals(nameTxt)) {
                    hV = "form-data; name=" + nameTxt;
                    fileName = fileNameTxt;
                    if (fileName != null) {
                        hV = hV + "; filename=" + fileName;
                    }
                    bodyTxt.addHeader("Content-Disposition", hV);
                } else {
                    bodyTxt.addHeader("Content-Disposition", "form-data");
                }
            }
            bodyTxt.addHeader("X-Custom-Header", "222");
            mm.addBodyPart((BodyPart)bodyTxt);
        }
        if (contentJson != null) {
            MimeBodyPart bodyJson = new MimeBodyPart();
            ct = contentTypeJson;
            if (ct == null) {
                ct = "application/json";
            }
            bodyJson.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(contentJson.getBytes(), ct)));
            if (contentTypeJson != null) {
                bodyJson.addHeader("Content-Type", contentTypeJson);
            }
            if (nameJson != null) {
                if (!"".equals(nameJson)) {
                    hV = "form-data; name=" + nameJson;
                    fileName = fileNameJson;
                    if (fileName != null) {
                        hV = hV + "; filename=" + fileName;
                    }
                    bodyJson.addHeader("Content-Disposition", hV);
                } else {
                    bodyJson.addHeader("Content-Disposition", "form-data");
                }
            }
            mm.addBodyPart((BodyPart)bodyJson);
        }
        if (contentPdf != null) {
            MimeBodyPart bodyPdf = new MimeBodyPart();
            ct = contentTypePdf;
            if (ct == null) {
                ct = "application/octet-stream";
            }
            bodyPdf.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(contentPdf, ct)));
            if (contentTypePdf != null) {
                bodyPdf.addHeader("Content-Type", contentTypePdf);
            }
            if (namePdf != null) {
                if (!"".equals(namePdf)) {
                    hV = "form-data; name=" + namePdf;
                    fileName = fileNamePdf;
                    if (fileName != null) {
                        hV = hV + "; filename=" + fileName;
                    }
                    bodyPdf.addHeader("Content-Disposition", hV);
                } else {
                    bodyPdf.addHeader("Content-Disposition", "form-data");
                }
            }
            mm.addBodyPart((BodyPart)bodyPdf);
        }
        if (contentPdf2 != null) {
            MimeBodyPart bodyPdf2 = new MimeBodyPart();
            ct = contentTypePdf2;
            if (ct == null) {
                ct = "application/octet-stream";
            }
            bodyPdf2.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(contentPdf2, ct)));
            if (contentTypePdf2 != null) {
                bodyPdf2.addHeader("Content-Type", contentTypePdf2);
            }
            if (namePdf2 != null) {
                if (!"".equals(namePdf2)) {
                    hV = "form-data; name=" + namePdf2;
                    fileName = fileNamePdf2;
                    if (fileName != null) {
                        hV = hV + "; filename=" + fileName;
                    }
                    bodyPdf2.addHeader("Content-Disposition", hV);
                } else {
                    bodyPdf2.addHeader("Content-Disposition", "form-data");
                }
            }
            mm.addBodyPart((BodyPart)bodyPdf2);
        }
        if (contentOther != null) {
            MimeBodyPart bodyOther = new MimeBodyPart();
            ct = contentTypeOther;
            if (ct == null) {
                ct = "application/octet-stream";
            }
            bodyOther.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(contentOther, ct)));
            if (contentTypeOther != null) {
                bodyOther.addHeader("Content-Type", contentTypeOther);
            }
            if (nameOther != null) {
                if (!"".equals(nameOther)) {
                    hV = "form-data; name=" + nameOther;
                    fileName = fileNameOther;
                    if (fileName != null) {
                        hV = hV + "; filename=" + fileName;
                    }
                    bodyOther.addHeader("Content-Disposition", hV);
                } else {
                    bodyOther.addHeader("Content-Disposition", "form-data");
                }
            }
            mm.addBodyPart((BodyPart)bodyOther);
        }
        return mm;
    }

    public static MimeMultipart buildMimeMultipart(String subtype, List<byte[]> contents, String contentType, String name, String fileName) throws Exception {
        MimeMultipart mm = new MimeMultipart(subtype);
        int attachNumero = contents.size();
        for (int k = 0; k < attachNumero; ++k) {
            byte[] content = contents.get(k);
            if (content == null) continue;
            MimeBodyPart body = new MimeBodyPart();
            String ct = contentType;
            if (ct == null) {
                ct = "application/octet-stream";
            }
            body.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(content, ct)));
            if (contentType != null) {
                body.addHeader("Content-Type", contentType);
            }
            if (name != null) {
                if (!"".equals(name)) {
                    String hV = "form-data; name=" + name;
                    if (fileName != null) {
                        hV = hV + "; filename=" + fileName.replace(templateNumero, "" + k);
                    }
                    body.addHeader("Content-Disposition", hV);
                } else {
                    body.addHeader("Content-Disposition", "form-data");
                }
            }
            mm.addBodyPart((BodyPart)body);
        }
        return mm;
    }
}

