/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.mime;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.openspcoop2.utils.UtilsException;

public class MimeTypes {
    private Map<String, Object> mapMimeToExt = new HashMap<String, Object>();
    private Map<String, String> mapExtToMime = new HashMap<String, String>();
    private static MimeTypes mimeTypes = null;

    private MimeTypes() throws UtilsException {
        String file = "/org/openspcoop2/utils/mime/mime.types";
        try (InputStream is = MimeTypes.class.getResourceAsStream(file);){
            if (is == null) {
                throw new UtilsException("File [" + file + "] in classpath not found");
            }
            MimeTypes.init(is, this.mapMimeToExt, this.mapExtToMime);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private static void init(InputStream is, Map<String, Object> mapMimeToExt, Map<String, String> mapExtToMime) throws UtilsException {
        try (InputStreamReader ir = new InputStreamReader(is);
             BufferedReader br = new BufferedReader(ir);){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.contains("\t")) {
                    throw new UtilsException("Line[" + line + "] contains tabs");
                }
                String[] tmp = line.split(" ");
                if (tmp.length < 2) {
                    mapMimeToExt.put(tmp[0].trim(), ObjectUtils.NULL);
                    continue;
                }
                StringBuilder bf = new StringBuilder();
                for (int i = 1; i < tmp.length; ++i) {
                    bf.append(" EXT-" + i + "=[" + tmp[i].trim() + "]");
                    mapExtToMime.put(tmp[i].trim(), tmp[0].trim());
                }
                mapMimeToExt.put(tmp[0].trim(), tmp[1].trim());
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public String getMimeType(File file) {
        String ext = null;
        try {
            String fileName = file.getName();
            ext = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ext == null) {
            ext = "bin";
        }
        return this.getMimeType(ext);
    }

    public String getMimeType(String ext) {
        if ("xml".equalsIgnoreCase(ext)) {
            return "text/xml";
        }
        if ("json".equalsIgnoreCase(ext)) {
            return "application/json";
        }
        return this.mapExtToMime.get(ext.trim().toLowerCase());
    }

    public String getExtension(String mime) {
        Object o = this.mapMimeToExt.get(mime.trim().toLowerCase());
        if (o == null) {
            return null;
        }
        if (o instanceof ObjectUtils.Null) {
            return null;
        }
        return (String)o;
    }

    public boolean existsExtension(String ext) {
        return this.mapExtToMime.containsKey(ext.trim().toLowerCase());
    }

    public boolean existsMimeType(String mime, boolean checkExistsExtension) {
        if (this.mapMimeToExt.containsKey(mime.trim().toLowerCase())) {
            if (checkExistsExtension) {
                String ext = this.getExtension(mime);
                return ext != null;
            }
            return true;
        }
        return false;
    }

    private static synchronized void init() throws UtilsException {
        if (mimeTypes == null) {
            mimeTypes = new MimeTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MimeTypes getInstance() throws UtilsException {
        if (mimeTypes != null) return mimeTypes;
        Class<MimeTypes> clazz = MimeTypes.class;
        synchronized (MimeTypes.class) {
            MimeTypes.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mimeTypes;
        }
    }
}

