/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.sql.Connection;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.AbstractNoReturnGeneratedKeyGenerator;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.DefaultKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.KeyGeneratorException;

public class OracleKeyGenerator
extends AbstractNoReturnGeneratedKeyGenerator {
    public OracleKeyGenerator(Connection connection, IKeyGeneratorObject type) throws KeyGeneratorException {
        super(connection, type);
    }

    @Override
    public String getSequenceQuery() throws KeyGeneratorException {
        Object sequence = null;
        switch (this.type.getType()) {
            case DEFAULT: {
                sequence = ((DefaultKeyGeneratorObject)this.type).getPrefix() + "_sequence";
                break;
            }
            case CUSTOM: {
                CustomKeyGeneratorObject c = (CustomKeyGeneratorObject)this.type;
                if (c.existsCustomTableObjectsForDatabaseType(TipiDatabase.ORACLE)) {
                    sequence = c.getCustomTableObjectsForDatabaseType(TipiDatabase.ORACLE).getSequenceName();
                    break;
                }
                sequence = c.getDefaultTableObjects().getSequenceName();
                break;
            }
            default: {
                throw new KeyGeneratorException("Tipo di KeyGeneratorObjects non gestito: " + String.valueOf(this.type));
            }
        }
        return "select " + (String)sequence + ".nextval as nextval from dual";
    }
}

