/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorOtherTableObjects;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.KeyGeneratorObjects;

public class CustomKeyGeneratorObject
implements IKeyGeneratorObject {
    private KeyGeneratorObjects keyGeneratorObject;
    private String columnNameId;
    private String table;
    private CustomKeyGeneratorOtherTableObjects defaultTableObjects;
    private Map<TipiDatabase, CustomKeyGeneratorOtherTableObjects> customTableObjects = new HashMap<TipiDatabase, CustomKeyGeneratorOtherTableObjects>();

    public CustomKeyGeneratorObject(String table, String columnNameId, String sequenceName, String tableNameForInitSequence) {
        this.keyGeneratorObject = KeyGeneratorObjects.CUSTOM;
        this.table = table;
        this.columnNameId = columnNameId;
        this.defaultTableObjects = new CustomKeyGeneratorOtherTableObjects(sequenceName, tableNameForInitSequence);
    }

    public CustomKeyGeneratorObject(String table, String columnNameId) {
        this.keyGeneratorObject = KeyGeneratorObjects.CUSTOM;
        this.table = table;
        this.columnNameId = columnNameId;
        this.defaultTableObjects = new CustomKeyGeneratorOtherTableObjects("seq_" + this.table, this.table + "_init_seq");
    }

    public CustomKeyGeneratorObject(String table) {
        this.keyGeneratorObject = KeyGeneratorObjects.CUSTOM;
        this.table = table;
        this.columnNameId = "id";
        this.defaultTableObjects = new CustomKeyGeneratorOtherTableObjects("seq_" + this.table, this.table + "_init_seq");
    }

    public String getColumnNameId() {
        return this.columnNameId;
    }

    public void setColumnNameId(String columnNameId) {
        this.columnNameId = columnNameId;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public KeyGeneratorObjects getType() {
        return this.keyGeneratorObject;
    }

    public CustomKeyGeneratorOtherTableObjects getDefaultTableObjects() {
        return this.defaultTableObjects;
    }

    public void setDefaultTableObjects(CustomKeyGeneratorOtherTableObjects defaultTableObjects) {
        this.defaultTableObjects = defaultTableObjects;
    }

    public void addCustomTableObjectsForDatabaseType(TipiDatabase tipoDatabase, CustomKeyGeneratorOtherTableObjects custom) {
        this.customTableObjects.put(tipoDatabase, custom);
    }

    public void addCustomTableObjectsForDatabaseType(TipiDatabase tipoDatabase, String sequenceName) {
        this.customTableObjects.put(tipoDatabase, new CustomKeyGeneratorOtherTableObjects(sequenceName));
    }

    public void addCustomTableObjectsForDatabaseType(TipiDatabase tipoDatabase, String sequenceName, String tableNameForInitSequence) {
        this.customTableObjects.put(tipoDatabase, new CustomKeyGeneratorOtherTableObjects(sequenceName, tableNameForInitSequence));
    }

    public boolean existsCustomTableObjectsForDatabaseType(TipiDatabase tipoDatabase) {
        return this.customTableObjects.containsKey((Object)tipoDatabase);
    }

    public CustomKeyGeneratorOtherTableObjects getCustomTableObjectsForDatabaseType(TipiDatabase tipoDatabase) {
        return this.customTableObjects.get((Object)tipoDatabase);
    }
}

