/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.jdbc.AbstractJDBCAdapter;

public class BlobJDBCAdapter
extends AbstractJDBCAdapter {
    public BlobJDBCAdapter(TipiDatabase tipoDatabase) {
        super(tipoDatabase);
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        Blob aBlob = rs.getBlob(index);
        if (aBlob == null) {
            return null;
        }
        return aBlob.getBytes(1L, (int)aBlob.length());
    }

    @Override
    public byte[] getBinaryData(ResultSet rs, String rsName) throws UtilsException, SQLException {
        Blob aBlob = rs.getBlob(rsName);
        if (aBlob == null) {
            return null;
        }
        return aBlob.getBytes(1L, (int)aBlob.length());
    }

    @Override
    public InputStream getBinaryStream(ResultSet rs, int index) throws UtilsException, SQLException {
        Blob aBlob = rs.getBlob(index);
        if (aBlob == null) {
            return null;
        }
        return aBlob.getBinaryStream();
    }

    @Override
    public InputStream getBinaryStream(ResultSet rs, String rsName) throws UtilsException, SQLException {
        Blob aBlob = rs.getBlob(rsName);
        if (aBlob == null) {
            return null;
        }
        return aBlob.getBinaryStream();
    }
}

