/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream_DefaultImpl;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream_FastImpl;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class DumpByteArrayOutputStreamTest {
    public static void main(String[] args) throws Exception {
        DumpByteArrayOutputStreamTest.testFastImpl();
        DumpByteArrayOutputStreamTest.testDefaultImpl();
    }

    public static void testFastImpl() throws Exception {
        File dir = File.createTempFile("test", "");
        dir.delete();
        FileSystemUtilities.mkdir(dir);
        System.out.println("\n\n");
        System.out.println("*** CLASSE: " + DumpByteArrayOutputStream.getClassImpl());
        if (!DumpByteArrayOutputStream_FastImpl.class.getName().equals(DumpByteArrayOutputStream.getClassImpl())) {
            throw new Exception("Attesa '" + DumpByteArrayOutputStream_FastImpl.class.getName() + "' trovata '" + DumpByteArrayOutputStream.getClassImpl() + "'");
        }
        DumpByteArrayOutputStreamTest.test(dir);
        FileSystemUtilities.deleteDir(dir);
    }

    public static void testDefaultImpl() throws Exception {
        File dir = File.createTempFile("test", "");
        dir.delete();
        FileSystemUtilities.mkdir(dir);
        System.out.println("\n\n");
        String defaultClass = DumpByteArrayOutputStream.getClassImpl();
        try {
            DumpByteArrayOutputStream.setClassImpl(DumpByteArrayOutputStream_DefaultImpl.class.getName());
            System.out.println("*** CLASSE: " + DumpByteArrayOutputStream.getClassImpl());
            if (!DumpByteArrayOutputStream_DefaultImpl.class.getName().equals(DumpByteArrayOutputStream.getClassImpl())) {
                throw new Exception("Attesa '" + DumpByteArrayOutputStream_DefaultImpl.class.getName() + "' trovata '" + DumpByteArrayOutputStream.getClassImpl() + "'");
            }
            DumpByteArrayOutputStreamTest.test(dir);
        }
        finally {
            DumpByteArrayOutputStream.setClassImpl(defaultClass);
        }
        FileSystemUtilities.deleteDir(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void test(File dir) throws Exception {
        try (DumpByteArrayOutputStream dump = null;){
            Object testoSerializzato = "Hello World";
            StringBuilder testoLungo = new StringBuilder();
            for (int i = 0; i < 102400; ++i) {
                testoLungo.append("Riga-").append(i).append("\n");
            }
            dump = new DumpByteArrayOutputStream();
            dump.write(((String)testoSerializzato).getBytes());
            DumpByteArrayOutputStreamTest.test("A. write", (String)testoSerializzato, false, dump);
            dump.clearResources();
            dump = new DumpByteArrayOutputStream(-1, null, null, null);
            dump.write(((String)testoSerializzato).getBytes());
            DumpByteArrayOutputStreamTest.test("A2. write", (String)testoSerializzato, false, dump);
            dump.clearResources();
            dump = new DumpByteArrayOutputStream(1024, dir, "3", "test");
            dump.write(((String)testoSerializzato).getBytes());
            DumpByteArrayOutputStreamTest.test("A. write", (String)testoSerializzato, false, dump);
            dump.clearResources();
            dump = new DumpByteArrayOutputStream(1024, dir, "3", "test");
            dump.write(((String)testoSerializzato).getBytes(), 0, ((String)testoSerializzato).length());
            char c = '=';
            dump.write(c);
            dump.flush();
            dump.close();
            testoSerializzato = (String)testoSerializzato + c;
            DumpByteArrayOutputStreamTest.test("B. write2", (String)testoSerializzato, false, dump);
            dump.clearResources();
            dump = new DumpByteArrayOutputStream(5, dir, "3", "test");
            dump.write(((String)testoSerializzato).getBytes());
            dump.flush();
            dump.close();
            DumpByteArrayOutputStreamTest.test("C. scritturaSuFile", (String)testoSerializzato, true, dump);
            dump.clearResources();
            String testoLungoAsString = testoLungo.toString();
            dump = new DumpByteArrayOutputStream(testoLungo.length() + 1, dir, "3", "test");
            dump.write(testoLungoAsString.getBytes());
            dump.flush();
            dump.close();
            DumpByteArrayOutputStreamTest.test("D. testoLungo in memoria", testoLungoAsString, false, dump);
            dump.clearResources();
            dump = new DumpByteArrayOutputStream(1024, dir, "3", "test");
            dump.write(testoLungoAsString.getBytes());
            dump.flush();
            dump.close();
            DumpByteArrayOutputStreamTest.test("E. testoLungo su file", testoLungoAsString, true, dump);
            dump.clearResources();
        }
    }

    private static void test(String tipoTest, String testoSerializzato, boolean expectedFile, DumpByteArrayOutputStream dump) throws Exception {
        System.out.println("\n\n");
        System.out.println("=====================================================");
        int size = dump.size();
        if (testoSerializzato.length() != size) {
            throw new Exception("Atteso [" + testoSerializzato.length() + "] trovato [" + size + "]");
        }
        String s = dump.toString();
        System.out.println("@" + tipoTest + " AS STRING: [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        if (!testoSerializzato.equals(s)) {
            throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        }
        s = dump.toString(Charset.defaultCharset());
        System.out.println("@" + tipoTest + " AS STRING 2: [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        if (!testoSerializzato.equals(s)) {
            throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        }
        s = dump.toString(Charset.defaultCharset().name());
        System.out.println("@" + tipoTest + " AS STRING 3: [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        if (!testoSerializzato.equals(s)) {
            throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        }
        byte[] b = dump.toByteArray();
        String sb = new String(b);
        System.out.println("@" + tipoTest + " AS BYTE: [" + b.length + "] [" + (String)(sb.length() > 20 ? sb.substring(0, 20) + " ..." : sb) + "]");
        if (testoSerializzato.length() != b.length) {
            throw new Exception("Atteso [" + testoSerializzato + ":" + testoSerializzato.length() + "] trovato [" + (String)(sb.length() > 20 ? sb.substring(0, 20) + " ..." : sb) + ":" + b.length + "]");
        }
        if (!testoSerializzato.equals(sb)) {
            throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        dump.writeTo(bout);
        bout.flush();
        bout.close();
        s = bout.toString();
        System.out.println("@" + tipoTest + " AS STRING after writeTo: [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        if (!testoSerializzato.equals(s)) {
            throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        }
        b = bout.toByteArray();
        sb = new String(b);
        System.out.println("@" + tipoTest + " AS BYTE after writeTo: [" + b.length + "] [" + (String)(sb.length() > 20 ? sb.substring(0, 20) + " ..." : sb) + "]");
        if (testoSerializzato.length() != b.length) {
            throw new Exception("Atteso [" + testoSerializzato + ":" + testoSerializzato.length() + "] trovato [" + (String)(sb.length() > 20 ? sb.substring(0, 20) + " ..." : sb) + ":" + b.length + "]");
        }
        if (!testoSerializzato.equals(sb)) {
            throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        }
        File fileS = dump.getSerializedFile();
        System.out.println("@" + tipoTest + " FILE [" + String.valueOf(fileS) + "]");
        if (expectedFile && fileS == null) {
            throw new Exception("Atteso getSerializedFile");
        }
        if (!expectedFile && fileS != null) {
            throw new Exception("Atteso null getSerializedFile; found: " + fileS.getAbsolutePath());
        }
        boolean serF = dump.isSerializedOnFileSystem();
        if (expectedFile && !serF) {
            throw new Exception("Atteso isSerializedOnFileSystem");
        }
        if (!expectedFile && serF) {
            throw new Exception("Atteso false per isSerializedOnFileSystem");
        }
        InputStream is = dump.getInputStream();
        s = Utilities.getAsString(is, "UTF-8");
        System.out.println("@" + tipoTest + " AS STRING from inputStream: [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        if (!testoSerializzato.equals(s)) {
            throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        }
        is = dump.getInputStream();
        b = Utilities.getAsByteArray(is);
        sb = new String(b);
        System.out.println("@" + tipoTest + " AS BYTE from inputStream: [" + b.length + "] [" + (String)(sb.length() > 20 ? sb.substring(0, 20) + " ..." : sb) + "]");
        if (testoSerializzato.length() != b.length) {
            throw new Exception("Atteso [" + testoSerializzato + ":" + testoSerializzato.length() + "] trovato [" + (String)(sb.length() > 20 ? sb.substring(0, 20) + " ..." : sb) + ":" + b.length + "]");
        }
        if (!testoSerializzato.equals(sb)) {
            throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
        }
        size = dump.size();
        if (testoSerializzato.length() != size) {
            throw new Exception("Atteso [" + testoSerializzato.length() + "] trovato [" + size + "]");
        }
        if (fileS != null) {
            s = FileSystemUtilities.readFile(fileS);
            System.out.println("@" + tipoTest + " AS STRING from file: [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
            if (!testoSerializzato.equals(s)) {
                throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
            }
            b = FileSystemUtilities.readBytesFromFile(fileS);
            sb = new String(b);
            System.out.println("@" + tipoTest + " AS BYTE from file: [" + b.length + "] [" + (String)(sb.length() > 20 ? sb.substring(0, 20) + " ..." : sb) + "]");
            if (testoSerializzato.length() != b.length) {
                throw new Exception("Atteso [" + testoSerializzato + ":" + testoSerializzato.length() + "] trovato [" + (String)(sb.length() > 20 ? sb.substring(0, 20) + " ..." : sb) + ":" + b.length + "]");
            }
            if (!testoSerializzato.equals(sb)) {
                throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
            }
            dump.lock();
            dump.clearResources();
            s = FileSystemUtilities.readFile(fileS);
            System.out.println("@" + tipoTest + " AS STRING from file: [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
            if (!testoSerializzato.equals(s)) {
                throw new Exception("Atteso [" + testoSerializzato + "] trovato [" + (String)(s.length() > 20 ? s.substring(0, 20) + " ..." : s) + "]");
            }
            dump.unlock();
            dump.clearResources();
            try {
                s = FileSystemUtilities.readFile(fileS);
                throw new Exception("Eccezione attesa FileNotFoundException non rilevata");
            }
            catch (FileNotFoundException notFound) {
                System.out.println("@" + tipoTest + " Eccezione attesa: " + notFound.getMessage());
            }
        }
    }
}

