/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.instrument;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.openspcoop2.utils.instrument.Agent;

public class InstrumentationUtils {
    public static long memoryUsageOf(Object obj) {
        return Agent.getInstrumentation().getObjectSize(obj);
    }

    public static long deepUsage(Object obj) {
        return InstrumentationUtils.deepUsage(obj, VisibilityFilter.NON_PUBLIC);
    }

    public static long deepUsage(Object obj, VisibilityFilter referenceFilter) {
        return InstrumentationUtils.deepUsage(obj, referenceFilter, null);
    }

    public static long deepUsage(Object obj, Map<String, List<Long>> map) {
        return InstrumentationUtils.deepUsage(Agent.getInstrumentation(), new HashSet<Integer>(), obj, VisibilityFilter.NON_PUBLIC, map, -1);
    }

    public static long deepUsage(Object obj, VisibilityFilter referenceFilter, Map<String, List<Long>> map) {
        return InstrumentationUtils.deepUsage(Agent.getInstrumentation(), new HashSet<Integer>(), obj, referenceFilter, map, -1);
    }

    public static long deepUsage(Object obj, Map<String, List<Long>> map, int maxLevel) {
        return InstrumentationUtils.deepUsage(Agent.getInstrumentation(), new HashSet<Integer>(), obj, VisibilityFilter.NON_PUBLIC, map, maxLevel);
    }

    public static long deepUsage(Object obj, VisibilityFilter referenceFilter, Map<String, List<Long>> map, int maxLevel) {
        return InstrumentationUtils.deepUsage(Agent.getInstrumentation(), new HashSet<Integer>(), obj, referenceFilter, map, maxLevel);
    }

    private static long deepUsage(Instrumentation instrumentation, Set<Integer> counted, Object obj, VisibilityFilter filter, Map<String, List<Long>> map, int levelMax) throws SecurityException {
        Stack<Object> stObject = new Stack<Object>();
        Stack<Object> stNames = new Stack<Object>();
        Stack<Integer> stLevels = new Stack<Integer>();
        stObject.push(obj);
        stNames.push("root");
        stLevels.push(0);
        long total = -1L;
        while (!stObject.isEmpty()) {
            Class<?> compType;
            long sz;
            boolean continuaNavigazione;
            Object o = stObject.pop();
            String name = (String)stNames.pop();
            int level = (Integer)stLevels.pop() + 1;
            if (!counted.add(System.identityHashCode(o))) continue;
            boolean bl = continuaNavigazione = levelMax == -1 || level <= levelMax;
            if (!continuaNavigazione) {
                sz = InstrumentationUtils.deepUsage(o, filter);
                total += sz;
                continue;
            }
            sz = instrumentation.getObjectSize(o);
            total += sz;
            Class<?> clz = o.getClass();
            if (map != null) {
                String key = name + "_" + clz.getName();
                List<Object> l = null;
                if (map.containsKey(key)) {
                    l = map.get(key);
                } else {
                    l = new ArrayList();
                    map.put(key, l);
                }
                boolean exists = false;
                if (!exists) {
                    l.add(sz);
                }
            }
            if ((compType = clz.getComponentType()) != null && !compType.isPrimitive()) {
                Object[] array = (Object[])o;
                for (int i = 0; i < array.length; ++i) {
                    Object el = array[i];
                    if (el == null) continue;
                    stObject.push(el);
                    stNames.push("[Level" + level + "] compType '" + name + "' " + clz.getName() + " array_" + i);
                    stLevels.push(level);
                }
            }
            while (clz != null) {
                Field[] declaredFields = clz.getDeclaredFields();
                for (int j = 0; j < declaredFields.length; ++j) {
                    Class<?> fieldClass;
                    Field fld = declaredFields[j];
                    int mod = fld.getModifiers();
                    if ((mod & 8) != 0 || !InstrumentationUtils.isOf(filter, mod) || (fieldClass = fld.getType()).isPrimitive()) continue;
                    try {
                        fld.setAccessible(true);
                        try {
                            Object subObj = fld.get(o);
                            if (subObj == null) continue;
                            stObject.push(subObj);
                            stNames.push("[Level" + level + "] " + fld.getName());
                            stLevels.push(level);
                            continue;
                        }
                        catch (IllegalAccessException illAcc) {
                            throw new InternalError("Couldn't read " + String.valueOf(fld));
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                clz = clz.getSuperclass();
            }
        }
        return total;
    }

    private static boolean isOf(VisibilityFilter f, int mod) {
        switch (f.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                return (mod & 2) != 0;
            }
            case 2: {
                return (mod & 1) == 0;
            }
        }
        throw new IllegalArgumentException("Illegal filter " + mod);
    }

    private InstrumentationUtils() {
    }

    public static void printToSystemOut(Map<String, List<Long>> map, boolean sort) throws Exception {
        InstrumentationUtils.print(map, null, sort);
    }

    public static void printToSystemOut(Map<String, List<Long>> map, File file, boolean sort) throws Exception {
        InstrumentationUtils.print(map, file, sort);
    }

    private static void print(Map<String, List<Long>> map, File file, boolean sort) throws Exception {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(map.keySet());
        ArrayList<CallSite> output = new ArrayList<CallSite>();
        for (String string : keys) {
            List<Long> list = map.get(string);
            if (list.size() == 1) {
                output.add((CallSite)((Object)("[" + String.valueOf(list.get(0)) + "]=[" + string + "]")));
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 1; i < list.size(); ++i) {
                sb.append(" [").append(list.get(i)).append("]");
            }
            output.add((CallSite)((Object)("[" + String.valueOf(list.get(0)) + "]=[" + string + "] more... " + sb.toString())));
        }
        if (sort) {
            Collections.sort(output);
        }
        StringBuilder sb = new StringBuilder();
        for (String string : output) {
            if (file != null) {
                sb.append(string).append("\n");
                continue;
            }
            System.out.println(string);
        }
        if (file != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(sb.toString().getBytes());
                fileOutputStream.flush();
            }
        }
    }

    public static enum VisibilityFilter {
        ALL,
        PRIVATE_ONLY,
        NON_PUBLIC;

    }
}

