/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.digest;

import java.io.Serializable;

public enum DigestType implements Serializable
{
    SHA256("SHA-256"),
    SHA512_256("SHA-512/256"),
    SHA384("SHA-384"),
    SHA512("SHA-512"),
    SHA3_256("SHA3-256"),
    SHA3_384("SHA3-384"),
    SHA3_512("SHA3-512"),
    SHAKE128("SHAKE128"),
    SHAKE256("SHAKE256");

    private final String algorithmName;

    private DigestType(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public static DigestType fromAlgorithmName(String value) {
        for (DigestType type : DigestType.values()) {
            if (!type.getAlgorithmName().equals(value)) continue;
            return type;
        }
        return null;
    }
}

