/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.date.test;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DaylightSavingUtils;
import org.openspcoop2.utils.date.TimeTransitionType;
import org.openspcoop2.utils.date.TimeType;

public class DaylightSavingTest {
    public static void main(String[] args) throws UtilsException {
        DaylightSavingTest.zoneIdTest();
        DaylightSavingTest.timeChangePendingTodayTest();
        DaylightSavingTest.oraLegaleToOraSolareTest();
        DaylightSavingTest.oraSolareToOraLegaleTest();
        DaylightSavingTest.debug("\n\n** TESTSUITE COMPLETATA **");
    }

    public static void zoneIdTest() throws UtilsException {
        DaylightSavingTest.debug("\n\n** ZoneId **");
        ZoneId zoneId = DaylightSavingUtils.getZoneIdDefault();
        if (!ZoneId.of("Europe/Rome").equals(zoneId)) {
            throw new UtilsException("Expected zone id default 'Europe/Rome'; found: " + String.valueOf(zoneId));
        }
    }

    public static void timeChangePendingTodayTest() throws UtilsException {
        ZoneId zoneId = DaylightSavingUtils.getZoneIdDefault();
        for (int i = 0; i < 3; ++i) {
            String format = null;
            String formatOffset = null;
            DateTimeFormatter formatter = null;
            DateTimeFormatter formatterOffset = null;
            if (i == 1) {
                format = "yyyyMMddHHmmss";
                formatOffset = format + "XXX";
            } else if (i == 2) {
                String intFormat = "yyyy-MM-dd HHmmss";
                formatter = DateTimeFormatter.ofPattern(intFormat);
                String intFormatOffset = intFormat + "XXX";
                formatterOffset = DateTimeFormatter.ofPattern(intFormatOffset);
            }
            String data = null;
            data = i == 0 ? "2024-10-27 02:56:00" : (i == 1 ? "20241027025600" : "2024-10-27 025600");
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "  format[" + format + "] formatter[" + (formatter != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, null, null, TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME, format, formatter);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02", null, TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02:00  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02:00", null, TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + " with zone id  format[" + format + "] formatter[" + (formatter != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, null, zoneId, TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME, format, formatter);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02 with zone id  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02", zoneId, TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02:00 with zone id  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02:00", zoneId, TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01", null, null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01:00  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01:00", null, null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01 with zone id  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01", zoneId, null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01:00 with zone id  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01:00", zoneId, null, formatOffset, formatterOffset);
            data = i == 0 ? "2025-03-30 01:56:00" : (i == 1 ? "20250330015600" : "2025-03-30 015600");
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "  format[" + format + "] formatter[" + (formatter != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, null, null, TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME, format, formatter);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01", null, TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01:00  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01:00", null, TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + " with zone id  format[" + format + "] formatter[" + (formatter != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, null, zoneId, TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME, format, formatter);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01 with zone id  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01", zoneId, TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01:00 with zone id  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01:00", zoneId, TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME, formatOffset, formatterOffset);
            data = i == 0 ? "2025-03-30 03:00:01" : (i == 1 ? "20250330030001" : "2025-03-30 030001");
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02", null, null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02:00  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02:00", null, null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02 with zone id  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02", zoneId, null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02:00 with zone id  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02:00", zoneId, null, formatOffset, formatterOffset);
            data = i == 0 ? "2024-11-20 02:56:00" : (i == 1 ? "20241120025600" : "2024-11-20 025600");
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "  format[" + format + "] formatter[" + (formatter != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, null, null, null, format, formatter);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01", null, null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+01:00  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+01:00", null, null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02", null, null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** timeChangePendingToday " + data + "+02:00  format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.timeChangePendingToday(data, "+02:00", null, null, formatOffset, formatterOffset);
        }
    }

    public static void oraLegaleToOraSolareTest() throws UtilsException {
        ZoneId zoneId = DaylightSavingUtils.getZoneIdDefault();
        for (int i = 0; i < 3; ++i) {
            String format = null;
            String formatOffset = null;
            DateTimeFormatter formatter = null;
            DateTimeFormatter formatterOffset = null;
            if (i == 1) {
                format = "yyyyMMddHHmmss";
                formatOffset = format + "XXX";
            } else if (i == 2) {
                String intFormat = "yyyy-MM-dd HHmmss";
                formatter = DateTimeFormatter.ofPattern(intFormat);
                String intFormatOffset = intFormat + "XXX";
                formatterOffset = DateTimeFormatter.ofPattern(intFormatOffset);
            }
            DaylightSavingTest.debug("\n\n** oraLegaleToOraSolare (+02) format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.oraLegaleToOraSolare("+02", null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** oraLegaleToOraSolare (+02) with zone id format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.oraLegaleToOraSolare("+02", zoneId, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** oraLegaleToOraSolare (+02:00) format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.oraLegaleToOraSolare("+02:00", null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** oraLegaleToOraSolare (+02:00) with zone id format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.oraLegaleToOraSolare("+02:00", zoneId, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** oraLegaleToOraSolare format[" + format + "] formatter[" + (formatter != null) + "] **");
            DaylightSavingTest.oraLegaleToOraSolareWithoutOffset(null, format, formatter);
            DaylightSavingTest.debug("\n\n** oraLegaleToOraSolare with zone id format[" + format + "] formatter[" + (formatter != null) + "] **");
            DaylightSavingTest.oraLegaleToOraSolareWithoutOffset(zoneId, format, formatter);
        }
    }

    public static void oraSolareToOraLegaleTest() throws UtilsException {
        ZoneId zoneId = DaylightSavingUtils.getZoneIdDefault();
        for (int i = 0; i < 3; ++i) {
            String format = null;
            String formatOffset = null;
            DateTimeFormatter formatter = null;
            DateTimeFormatter formatterOffset = null;
            if (i == 1) {
                format = "yyyyMMddHHmmss";
                formatOffset = format + "XXX";
            } else if (i == 2) {
                String intFormat = "yyyy-MM-dd HHmmss";
                formatter = DateTimeFormatter.ofPattern(intFormat);
                String intFormatOffset = intFormat + "XXX";
                formatterOffset = DateTimeFormatter.ofPattern(intFormatOffset);
            }
            DaylightSavingTest.debug("\n\n** oraSolareToOraLegale (+01) format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.oraSolareToOraLegale("+01", null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** oraSolareToOraLegale (+01) with zone id format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.oraSolareToOraLegale("+01", zoneId, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** oraSolareToOraLegale (+01:00) format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.oraSolareToOraLegale("+01:00", null, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** oraSolareToOraLegale (+01:00) with zone id format[" + formatOffset + "] formatter[" + (formatterOffset != null) + "] **");
            DaylightSavingTest.oraSolareToOraLegale("+01:00", zoneId, formatOffset, formatterOffset);
            DaylightSavingTest.debug("\n\n** oraSolareToOraLegale format[" + format + "] formatter[" + (formatter != null) + "] **");
            DaylightSavingTest.oraSolareToOraLegaleWithoutOffset(null, format, formatter);
            DaylightSavingTest.debug("\n\n** oraSolareToOraLegale with zone id format[" + format + "] formatter[" + (formatter != null) + "] **");
            DaylightSavingTest.oraSolareToOraLegaleWithoutOffset(zoneId, format, formatter);
        }
    }

    private static void timeChangePendingToday(String dataParam, String offset, ZoneId zoneId, TimeTransitionType expected, String format, DateTimeFormatter formatter) throws UtilsException {
        String data = offset != null ? dataParam + offset : dataParam;
        DaylightSavingTest.debug("\tdate: " + data);
        boolean withoutOffset = offset == null;
        TimeTransitionType t = null;
        t = zoneId != null ? (formatter != null ? (withoutOffset ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, formatter) : DaylightSavingUtils.getTimeChangePendingToday(data, zoneId, formatter)) : (format != null ? (withoutOffset ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, format) : DaylightSavingUtils.getTimeChangePendingToday(data, zoneId, format)) : (withoutOffset ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId) : DaylightSavingUtils.getTimeChangePendingToday(data, zoneId)))) : (formatter != null ? (withoutOffset ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, formatter) : DaylightSavingUtils.getTimeChangePendingToday(data, formatter)) : (format != null ? (withoutOffset ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, format) : DaylightSavingUtils.getTimeChangePendingToday(data, format)) : (withoutOffset ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data) : DaylightSavingUtils.getTimeChangePendingToday(data))));
        DaylightSavingTest.debug("\tTipo: " + String.valueOf((Object)t));
        if (t != null) {
            DaylightSavingTest.debug("\tDescrizione: " + t.getItaDescription());
        }
        if (expected == null) {
            if (t != null) {
                throw new UtilsException("Expected null; found " + String.valueOf((Object)t));
            }
        } else if (!expected.equals((Object)t)) {
            throw new UtilsException("Expected " + String.valueOf((Object)expected) + "; found " + String.valueOf((Object)t));
        }
    }

    private static void oraLegaleToOraSolare(String offset, ZoneId zoneId, String format, DateTimeFormatter formatter) throws UtilsException {
        Object data = null;
        TimeType type = null;
        if (formatter != null) {
            data = "2024-10-27 025600" + offset;
            type = zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId, formatter) : DaylightSavingUtils.getTimeType((String)data, formatter);
        } else if (format != null) {
            data = "20241027025600" + offset;
            type = zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId, format) : DaylightSavingUtils.getTimeType((String)data, format);
        } else {
            data = "2024-10-27 02:56:00" + offset;
            type = zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId) : DaylightSavingUtils.getTimeType((String)data);
        }
        DaylightSavingTest.debug("\tdate: " + (String)data);
        DaylightSavingTest.debug("\tTipo: " + String.valueOf((Object)type));
        DaylightSavingTest.debug("\tDescrizione: " + type.getItaDescription());
        if (!TimeType.DAYLIGHT_SAVING_TIME.equals((Object)type)) {
            throw new UtilsException("Expected '" + String.valueOf((Object)TimeType.DAYLIGHT_SAVING_TIME) + "'");
        }
        long m = -1L;
        m = formatter != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId, formatter) : DaylightSavingUtils.minutesUntilNextTransition((String)data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId, format) : DaylightSavingUtils.minutesUntilNextTransition((String)data, format)) : (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId) : DaylightSavingUtils.minutesUntilNextTransition((String)data)));
        long atteso = 4L;
        DaylightSavingTest.debug("\tMinutes nextTransition: " + m);
        if (m != atteso) {
            throw new UtilsException("Expected " + atteso + " minutes; found " + m);
        }
        DaylightSavingTest.debug("\tAdd 4 minutes");
        OffsetDateTime d = null;
        d = formatter != null ? DaylightSavingUtils.parseOffsetDateTime((String)data, formatter) : (format != null ? DaylightSavingUtils.parseOffsetDateTime((String)data, format) : DaylightSavingUtils.parseOffsetDateTime((String)data));
        OffsetDateTime dateTime = OffsetDateTime.from(d);
        OffsetDateTime updatedDateTime = dateTime.plusMinutes(4L);
        data = formatter != null ? formatter.format(updatedDateTime) : (format != null ? DateTimeFormatter.ofPattern(format).format(updatedDateTime) : DaylightSavingUtils.getOffsetFormatter().format(updatedDateTime));
        DaylightSavingTest.debug("\tNew date: " + (String)data);
        type = formatter != null ? (zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId, formatter) : DaylightSavingUtils.getTimeType((String)data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId, format) : DaylightSavingUtils.getTimeType((String)data, format)) : (zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId) : DaylightSavingUtils.getTimeType((String)data)));
        DaylightSavingTest.debug("\tTipo: " + String.valueOf((Object)type));
        DaylightSavingTest.debug("\tDescrizione: " + type.getItaDescription());
        if (!TimeType.STANDARD_TIME.equals((Object)type)) {
            throw new UtilsException("Expected '" + String.valueOf((Object)TimeType.STANDARD_TIME) + "'");
        }
        m = formatter != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId, formatter) : DaylightSavingUtils.minutesUntilNextTransition((String)data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId, format) : DaylightSavingUtils.minutesUntilNextTransition((String)data, format)) : (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId) : DaylightSavingUtils.minutesUntilNextTransition((String)data)));
        atteso = 221760L;
        DaylightSavingTest.debug("\tMinutes nextTransition: " + m);
        if (m != atteso) {
            throw new UtilsException("Expected " + atteso + " minutes; found " + m);
        }
    }

    private static void oraSolareToOraLegale(String offset, ZoneId zoneId, String format, DateTimeFormatter formatter) throws UtilsException {
        Object data = null;
        TimeType type = null;
        if (formatter != null) {
            data = "2025-03-30 015600" + offset;
            type = zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId, formatter) : DaylightSavingUtils.getTimeType((String)data, formatter);
        } else if (format != null) {
            data = "20250330015600" + offset;
            type = zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId, format) : DaylightSavingUtils.getTimeType((String)data, format);
        } else {
            data = "2025-03-30 01:56:00" + offset;
            type = zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId) : DaylightSavingUtils.getTimeType((String)data);
        }
        DaylightSavingTest.debug("\tdate: " + (String)data);
        DaylightSavingTest.debug("\tTipo: " + String.valueOf((Object)type));
        DaylightSavingTest.debug("\tDescrizione: " + type.getItaDescription());
        if (!TimeType.STANDARD_TIME.equals((Object)type)) {
            throw new UtilsException("Expected '" + String.valueOf((Object)TimeType.STANDARD_TIME) + "'");
        }
        long m = -1L;
        m = formatter != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId, formatter) : DaylightSavingUtils.minutesUntilNextTransition((String)data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId, format) : DaylightSavingUtils.minutesUntilNextTransition((String)data, format)) : (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId) : DaylightSavingUtils.minutesUntilNextTransition((String)data)));
        long atteso = 4L;
        DaylightSavingTest.debug("\tMinutes nextTransition: " + m);
        if (m != atteso) {
            throw new UtilsException("Expected " + atteso + " minutes; found " + m);
        }
        DaylightSavingTest.debug("\tAdd 4 minutes");
        OffsetDateTime d = null;
        d = formatter != null ? DaylightSavingUtils.parseOffsetDateTime((String)data, formatter) : (format != null ? DaylightSavingUtils.parseOffsetDateTime((String)data, format) : DaylightSavingUtils.parseOffsetDateTime((String)data));
        OffsetDateTime dateTime = OffsetDateTime.from(d);
        OffsetDateTime updatedDateTime = dateTime.plusMinutes(4L);
        data = formatter != null ? formatter.format(updatedDateTime) : (format != null ? DateTimeFormatter.ofPattern(format).format(updatedDateTime) : DaylightSavingUtils.getOffsetFormatter().format(updatedDateTime));
        DaylightSavingTest.debug("\tNew date: " + (String)data);
        type = formatter != null ? (zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId, formatter) : DaylightSavingUtils.getTimeType((String)data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId, format) : DaylightSavingUtils.getTimeType((String)data, format)) : (zoneId != null ? DaylightSavingUtils.getTimeType((String)data, zoneId) : DaylightSavingUtils.getTimeType((String)data)));
        DaylightSavingTest.debug("\tTipo: " + String.valueOf((Object)type));
        DaylightSavingTest.debug("\tDescrizione: " + type.getItaDescription());
        if (!TimeType.DAYLIGHT_SAVING_TIME.equals((Object)type)) {
            throw new UtilsException("Expected '" + String.valueOf((Object)TimeType.DAYLIGHT_SAVING_TIME) + "'");
        }
        m = formatter != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId, formatter) : DaylightSavingUtils.minutesUntilNextTransition((String)data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId, format) : DaylightSavingUtils.minutesUntilNextTransition((String)data, format)) : (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransition((String)data, zoneId) : DaylightSavingUtils.minutesUntilNextTransition((String)data)));
        atteso = 302400L;
        DaylightSavingTest.debug("\tMinutes nextTransition: " + m);
        if (m != atteso) {
            throw new UtilsException("Expected " + atteso + " minutes; found " + m);
        }
    }

    private static void oraLegaleToOraSolareWithoutOffset(ZoneId zoneId, String format, DateTimeFormatter formatter) throws UtilsException {
        String data = null;
        TimeTransitionType type = null;
        if (formatter != null) {
            data = "2024-10-27 025600";
            type = zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, formatter) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, formatter);
        } else if (format != null) {
            data = "20241027025600";
            type = zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, format) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, format);
        } else {
            data = "2024-10-27 02:56:00";
            type = zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data);
        }
        DaylightSavingTest.debug("\tdate: " + data);
        DaylightSavingTest.debug("\tTipo: " + String.valueOf((Object)type));
        DaylightSavingTest.debug("\tDescrizione: " + type.getItaDescription());
        if (!TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME.equals((Object)type)) {
            throw new UtilsException("Expected '" + String.valueOf((Object)TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME) + "' found: " + String.valueOf((Object)type));
        }
        long m = -1L;
        m = formatter != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId, formatter) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId, format) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, format)) : (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data)));
        long atteso = 4L;
        DaylightSavingTest.debug("\tMinutes nextTransition: " + m);
        if (m != atteso) {
            throw new UtilsException("Expected " + atteso + " minutes; found " + m);
        }
        DaylightSavingTest.debug("\tAdd 4 minutes");
        LocalDateTime d = null;
        d = formatter != null ? DaylightSavingUtils.parseLocalDateTime(data, formatter) : (format != null ? DaylightSavingUtils.parseLocalDateTime(data, format) : DaylightSavingUtils.parseLocalDateTime(data));
        LocalDateTime dateTime = LocalDateTime.from(d);
        LocalDateTime updatedDateTime = dateTime.plusMinutes(4L);
        data = formatter != null ? formatter.format(updatedDateTime) : (format != null ? DateTimeFormatter.ofPattern(format).format(updatedDateTime) : DaylightSavingUtils.getBasicFormatter().format(updatedDateTime));
        DaylightSavingTest.debug("\tNew date: " + data);
        type = formatter != null ? (zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, formatter) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, format) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, format)) : (zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data)));
        DaylightSavingTest.debug("\tTipo: " + String.valueOf((Object)type));
        if (type != null) {
            DaylightSavingTest.debug("\tDescrizione: " + type.getItaDescription());
            throw new UtilsException("Expected null found: '" + String.valueOf((Object)type) + "'");
        }
        m = formatter != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId, formatter) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId, format) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, format)) : (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data)));
        atteso = 221700L;
        DaylightSavingTest.debug("\tMinutes nextTransition: " + m);
        if (m != atteso) {
            throw new UtilsException("Expected " + atteso + " minutes; found " + m);
        }
    }

    private static void oraSolareToOraLegaleWithoutOffset(ZoneId zoneId, String format, DateTimeFormatter formatter) throws UtilsException {
        String data = null;
        TimeTransitionType type = null;
        if (formatter != null) {
            data = "2025-03-30 015600";
            type = zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, formatter) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, formatter);
        } else if (format != null) {
            data = "20250330015600";
            type = zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, format) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, format);
        } else {
            data = "2025-03-30 01:56:00";
            type = zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data);
        }
        DaylightSavingTest.debug("\tdate: " + data);
        DaylightSavingTest.debug("\tTipo: " + String.valueOf((Object)type));
        DaylightSavingTest.debug("\tDescrizione: " + type.getItaDescription());
        if (!TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME.equals((Object)type)) {
            throw new UtilsException("Expected '" + String.valueOf((Object)TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME) + "'");
        }
        long m = -1L;
        m = formatter != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId, formatter) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId, format) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, format)) : (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data)));
        long atteso = 4L;
        DaylightSavingTest.debug("\tMinutes nextTransition: " + m);
        if (m != atteso) {
            throw new UtilsException("Expected " + atteso + " minutes; found " + m);
        }
        DaylightSavingTest.debug("\tAdd 4 minutes");
        LocalDateTime d = null;
        d = formatter != null ? DaylightSavingUtils.parseLocalDateTime(data, formatter) : (format != null ? DaylightSavingUtils.parseLocalDateTime(data, format) : DaylightSavingUtils.parseLocalDateTime(data));
        LocalDateTime dateTime = LocalDateTime.from(d);
        LocalDateTime updatedDateTime = dateTime.plusMinutes(4L);
        data = formatter != null ? formatter.format(updatedDateTime) : (format != null ? DateTimeFormatter.ofPattern(format).format(updatedDateTime) : DaylightSavingUtils.getBasicFormatter().format(updatedDateTime));
        DaylightSavingTest.debug("\tNew date: " + data);
        type = formatter != null ? (zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, formatter) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId, format) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, format)) : (zoneId != null ? DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data, zoneId) : DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(data)));
        DaylightSavingTest.debug("\tTipo: " + String.valueOf((Object)type));
        if (type != null) {
            DaylightSavingTest.debug("\tDescrizione: " + type.getItaDescription());
            throw new UtilsException("Expected null found: '" + String.valueOf((Object)type) + "'");
        }
        m = formatter != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId, formatter) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, formatter)) : (format != null ? (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId, format) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, format)) : (zoneId != null ? DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data, zoneId) : DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(data)));
        atteso = 302400L;
        DaylightSavingTest.debug("\tMinutes nextTransition: " + m);
        if (m != atteso) {
            throw new UtilsException("Expected " + atteso + " minutes; found " + m);
        }
    }

    private static void debug(String msg) {
        System.out.println(msg);
    }
}

