/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.date;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import org.openspcoop2.utils.date.TimeTransitionType;
import org.openspcoop2.utils.date.TimeType;

public class DaylightSavingUtils {
    private static final String OFFSET_FORMAT = "yyyy-MM-dd HH:mm:ssXXX";
    private static final DateTimeFormatter OFFSET_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssXXX");
    private static final String BASIC_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter BASIC_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final ZoneId ZONE_ID_DEFAULT = ZoneId.systemDefault();

    private DaylightSavingUtils() {
    }

    public static String getOffsetFormat() {
        return OFFSET_FORMAT;
    }

    public static DateTimeFormatter getOffsetFormatter() {
        return OFFSET_FORMATTER;
    }

    public static String getBasicFormat() {
        return BASIC_FORMAT;
    }

    public static DateTimeFormatter getBasicFormatter() {
        return BASIC_FORMATTER;
    }

    public static ZoneId getZoneIdDefault() {
        return ZONE_ID_DEFAULT;
    }

    public static long minutesUntilNextTransition(String inputDate) {
        return DaylightSavingUtils.minutesUntilNextTransition(inputDate, ZONE_ID_DEFAULT);
    }

    public static long minutesUntilNextTransition(String inputDate, ZoneId zoneId) {
        return DaylightSavingUtils.minutesUntilNextTransition(inputDate, zoneId, null, null);
    }

    public static long minutesUntilNextTransition(String inputDate, String format) {
        return DaylightSavingUtils.minutesUntilNextTransition(inputDate, ZONE_ID_DEFAULT, format);
    }

    public static long minutesUntilNextTransition(String inputDate, ZoneId zoneId, String format) {
        return DaylightSavingUtils.minutesUntilNextTransition(inputDate, zoneId, format, null);
    }

    public static long minutesUntilNextTransition(String inputDate, DateTimeFormatter formatter) {
        return DaylightSavingUtils.minutesUntilNextTransition(inputDate, ZONE_ID_DEFAULT, formatter);
    }

    public static long minutesUntilNextTransition(String inputDate, ZoneId zoneId, DateTimeFormatter formatter) {
        return DaylightSavingUtils.minutesUntilNextTransition(inputDate, zoneId, null, formatter);
    }

    private static long minutesUntilNextTransition(String inputDate, ZoneId zoneId, String format, DateTimeFormatter formatter) {
        OffsetDateTime offsetDateTime = formatter != null ? DaylightSavingUtils.parseOffsetDateTime(inputDate, formatter) : DaylightSavingUtils.parseOffsetDateTime(inputDate, format);
        ZonedDateTime zonedDateTime = offsetDateTime.atZoneSameInstant(zoneId);
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffsetTransition nextTransition = zoneRules.nextTransition(zonedDateTime.toInstant());
        if (nextTransition != null) {
            ZonedDateTime transitionDateTime = ZonedDateTime.ofInstant(nextTransition.getDateTimeBefore(), nextTransition.getOffsetBefore(), zoneId);
            return Duration.between(zonedDateTime, transitionDateTime).toMinutes();
        }
        return -1L;
    }

    public static long minutesUntilNextTransitionWithoutOffset(String inputDate) {
        return DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(inputDate, ZONE_ID_DEFAULT);
    }

    public static long minutesUntilNextTransitionWithoutOffset(String inputDate, ZoneId zoneId) {
        return DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(inputDate, zoneId, null, null);
    }

    public static long minutesUntilNextTransitionWithoutOffset(String inputDate, String format) {
        return DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(inputDate, ZONE_ID_DEFAULT, format);
    }

    public static long minutesUntilNextTransitionWithoutOffset(String inputDate, ZoneId zoneId, String format) {
        return DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(inputDate, zoneId, format, null);
    }

    public static long minutesUntilNextTransitionWithoutOffset(String inputDate, DateTimeFormatter formatter) {
        return DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(inputDate, ZONE_ID_DEFAULT, formatter);
    }

    public static long minutesUntilNextTransitionWithoutOffset(String inputDate, ZoneId zoneId, DateTimeFormatter formatter) {
        return DaylightSavingUtils.minutesUntilNextTransitionWithoutOffset(inputDate, zoneId, null, formatter);
    }

    private static long minutesUntilNextTransitionWithoutOffset(String inputDate, ZoneId zoneId, String format, DateTimeFormatter formatter) {
        LocalDateTime localDateTime = formatter != null ? DaylightSavingUtils.parseLocalDateTime(inputDate, formatter) : DaylightSavingUtils.parseLocalDateTime(inputDate, format);
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffsetTransition nextTransition = zoneRules.nextTransition(zonedDateTime.toInstant());
        if (nextTransition != null) {
            ZonedDateTime transitionDateTime = ZonedDateTime.ofInstant(nextTransition.getDateTimeBefore(), nextTransition.getOffsetBefore(), zoneId);
            return Duration.between(zonedDateTime, transitionDateTime).toMinutes();
        }
        return -1L;
    }

    public static TimeType getTimeType(String inputDate) {
        return DaylightSavingUtils.getTimeType(inputDate, ZONE_ID_DEFAULT);
    }

    public static TimeType getTimeType(String inputDate, ZoneId zoneId) {
        return DaylightSavingUtils.getTimeType(inputDate, zoneId, null, null);
    }

    public static TimeType getTimeType(String inputDate, String format) {
        return DaylightSavingUtils.getTimeType(inputDate, ZONE_ID_DEFAULT, format);
    }

    public static TimeType getTimeType(String inputDate, ZoneId zoneId, String format) {
        return DaylightSavingUtils.getTimeType(inputDate, zoneId, format, null);
    }

    public static TimeType getTimeType(String inputDate, DateTimeFormatter formatter) {
        return DaylightSavingUtils.getTimeType(inputDate, ZONE_ID_DEFAULT, formatter);
    }

    public static TimeType getTimeType(String inputDate, ZoneId zoneId, DateTimeFormatter formatter) {
        return DaylightSavingUtils.getTimeType(inputDate, zoneId, null, formatter);
    }

    private static TimeType getTimeType(String inputDate, ZoneId zoneId, String format, DateTimeFormatter formatter) {
        OffsetDateTime offsetDateTime = formatter != null ? DaylightSavingUtils.parseOffsetDateTime(inputDate, formatter) : DaylightSavingUtils.parseOffsetDateTime(inputDate, format);
        ZonedDateTime zonedDateTime = offsetDateTime.atZoneSameInstant(zoneId);
        boolean isDaylightSavings = zonedDateTime.getZone().getRules().isDaylightSavings(zonedDateTime.toInstant());
        return isDaylightSavings ? TimeType.DAYLIGHT_SAVING_TIME : TimeType.STANDARD_TIME;
    }

    public static ZonedDateTime convertToZonedDateTime(String inputDate) {
        return DaylightSavingUtils.convertToZonedDateTime(inputDate, ZONE_ID_DEFAULT);
    }

    public static ZonedDateTime convertToZonedDateTime(String inputDate, ZoneId zoneId) {
        return DaylightSavingUtils.convertToZonedDateTime(inputDate, zoneId, null, null);
    }

    public static ZonedDateTime convertToZonedDateTime(String inputDate, String format) {
        return DaylightSavingUtils.convertToZonedDateTime(inputDate, ZONE_ID_DEFAULT, format);
    }

    public static ZonedDateTime convertToZonedDateTime(String inputDate, ZoneId zoneId, String format) {
        return DaylightSavingUtils.convertToZonedDateTime(inputDate, zoneId, format, null);
    }

    public static ZonedDateTime convertToZonedDateTime(String inputDate, DateTimeFormatter formatter) {
        return DaylightSavingUtils.convertToZonedDateTime(inputDate, ZONE_ID_DEFAULT, formatter);
    }

    public static ZonedDateTime convertToZonedDateTime(String inputDate, ZoneId zoneId, DateTimeFormatter formatter) {
        return DaylightSavingUtils.convertToZonedDateTime(inputDate, zoneId, null, formatter);
    }

    private static ZonedDateTime convertToZonedDateTime(String inputDate, ZoneId zoneId, String format, DateTimeFormatter formatter) {
        OffsetDateTime offsetDateTime = formatter != null ? DaylightSavingUtils.parseOffsetDateTime(inputDate, formatter) : DaylightSavingUtils.parseOffsetDateTime(inputDate, format);
        return offsetDateTime.atZoneSameInstant(zoneId);
    }

    public static TimeTransitionType getTimeChangePendingToday(String inputDate) {
        return DaylightSavingUtils.getTimeChangePendingToday(inputDate, ZONE_ID_DEFAULT);
    }

    public static TimeTransitionType getTimeChangePendingToday(String inputDate, ZoneId zoneId) {
        return DaylightSavingUtils.getTimeChangePendingToday(inputDate, zoneId, null, null);
    }

    public static TimeTransitionType getTimeChangePendingToday(String inputDate, String format) {
        return DaylightSavingUtils.getTimeChangePendingToday(inputDate, ZONE_ID_DEFAULT, format);
    }

    public static TimeTransitionType getTimeChangePendingToday(String inputDate, ZoneId zoneId, String format) {
        return DaylightSavingUtils.getTimeChangePendingToday(inputDate, zoneId, format, null);
    }

    public static TimeTransitionType getTimeChangePendingToday(String inputDate, DateTimeFormatter formatter) {
        return DaylightSavingUtils.getTimeChangePendingToday(inputDate, ZONE_ID_DEFAULT, formatter);
    }

    public static TimeTransitionType getTimeChangePendingToday(String inputDate, ZoneId zoneId, DateTimeFormatter formatter) {
        return DaylightSavingUtils.getTimeChangePendingToday(inputDate, zoneId, null, formatter);
    }

    private static TimeTransitionType getTimeChangePendingToday(String inputDate, ZoneId zoneId, String format, DateTimeFormatter formatter) {
        OffsetDateTime dateTime = formatter != null ? DaylightSavingUtils.parseOffsetDateTime(inputDate, formatter) : DaylightSavingUtils.parseOffsetDateTime(inputDate, format);
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffsetTransition nextTransition = zoneRules.nextTransition(dateTime.toInstant());
        if (nextTransition != null) {
            LocalDate transitionDate = nextTransition.getDateTimeBefore().toLocalDate();
            if (dateTime.toLocalDate().equals(transitionDate)) {
                ZoneOffset offsetBefore = nextTransition.getOffsetBefore();
                ZoneOffset offsetAfter = nextTransition.getOffsetAfter();
                if (offsetBefore.getTotalSeconds() > offsetAfter.getTotalSeconds()) {
                    return TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME;
                }
                return TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME;
            }
        }
        return null;
    }

    public static TimeTransitionType getTimeChangePendingTodayWithoutOffset(String inputDate) {
        return DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(inputDate, ZONE_ID_DEFAULT);
    }

    public static TimeTransitionType getTimeChangePendingTodayWithoutOffset(String inputDate, ZoneId zoneId) {
        return DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(inputDate, zoneId, null, null);
    }

    public static TimeTransitionType getTimeChangePendingTodayWithoutOffset(String inputDate, String format) {
        return DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(inputDate, ZONE_ID_DEFAULT, format);
    }

    public static TimeTransitionType getTimeChangePendingTodayWithoutOffset(String inputDate, ZoneId zoneId, String format) {
        return DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(inputDate, zoneId, format, null);
    }

    public static TimeTransitionType getTimeChangePendingTodayWithoutOffset(String inputDate, DateTimeFormatter formatter) {
        return DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(inputDate, ZONE_ID_DEFAULT, formatter);
    }

    public static TimeTransitionType getTimeChangePendingTodayWithoutOffset(String inputDate, ZoneId zoneId, DateTimeFormatter formatter) {
        return DaylightSavingUtils.getTimeChangePendingTodayWithoutOffset(inputDate, zoneId, null, formatter);
    }

    private static TimeTransitionType getTimeChangePendingTodayWithoutOffset(String inputDate, ZoneId zoneId, String format, DateTimeFormatter formatter) {
        LocalDateTime localDateTime = formatter != null ? DaylightSavingUtils.parseLocalDateTime(inputDate, formatter) : DaylightSavingUtils.parseLocalDateTime(inputDate, format);
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffsetTransition nextTransition = zoneRules.nextTransition(zonedDateTime.toInstant());
        if (nextTransition != null) {
            ZonedDateTime transitionDateTime = ZonedDateTime.ofInstant(nextTransition.getDateTimeBefore(), nextTransition.getOffsetBefore(), zoneId);
            if (localDateTime.toLocalDate().equals(transitionDateTime.toLocalDate())) {
                ZoneOffset offsetBefore = nextTransition.getOffsetBefore();
                ZoneOffset offsetAfter = nextTransition.getOffsetAfter();
                if (offsetBefore.getTotalSeconds() > offsetAfter.getTotalSeconds()) {
                    return TimeTransitionType.FROM_DAYLIGHT_SAVING_TO_STANDARD_TIME;
                }
                return TimeTransitionType.FROM_STANDARD_TO_DAYLIGHT_SAVING_TIME;
            }
        }
        return null;
    }

    public static LocalDateTime parseLocalDateTime(String inputDate) {
        return DaylightSavingUtils.parseLocalDateTime(inputDate, BASIC_FORMATTER);
    }

    public static LocalDateTime parseLocalDateTime(String inputDate, String format) {
        if (format == null) {
            return DaylightSavingUtils.parseLocalDateTime(inputDate);
        }
        return DaylightSavingUtils.parseLocalDateTime(inputDate, DateTimeFormatter.ofPattern(format));
    }

    public static LocalDateTime parseLocalDateTime(String inputDate, DateTimeFormatter formatter) {
        if (formatter == null) {
            return DaylightSavingUtils.parseLocalDateTime(inputDate);
        }
        return LocalDateTime.parse(inputDate, formatter);
    }

    public static OffsetDateTime parseOffsetDateTime(String inputDate) {
        return DaylightSavingUtils.parseOffsetDateTime(inputDate, OFFSET_FORMATTER);
    }

    public static OffsetDateTime parseOffsetDateTime(String inputDate, String format) {
        if (format == null) {
            return DaylightSavingUtils.parseOffsetDateTime(inputDate);
        }
        return DaylightSavingUtils.parseOffsetDateTime(inputDate, DateTimeFormatter.ofPattern(format));
    }

    public static OffsetDateTime parseOffsetDateTime(String inputDate, DateTimeFormatter formatter) {
        if (formatter == null) {
            return DaylightSavingUtils.parseOffsetDateTime((String)inputDate);
        }
        if (((String)inputDate).matches(".*[+-]\\d{2}$")) {
            inputDate = (String)inputDate + ":00";
        }
        return OffsetDateTime.parse((CharSequence)inputDate, formatter);
    }
}

