/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.datasource;

import java.sql.Connection;
import java.util.concurrent.Callable;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.datasource.DataSource;
import org.openspcoop2.utils.jdbc.JDBCUtilities;

class InformazioniDatabaseChecker
implements Callable<String> {
    private DataSource dataSource;

    public InformazioniDatabaseChecker(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws Exception {
        StringBuilder bf = new StringBuilder();
        if (this.dataSource.getTipoDatabase() == null) {
            throw new UtilsException("Tipo di Database non disponibile");
        }
        bf.append("TipoDatabase: " + this.dataSource.getTipoDatabase().getNome());
        Connection c = null;
        try {
            c = this.dataSource.getConnection();
            JDBCUtilities.addInformazioniDatabaseFromMetaData(c, bf);
            if (bf.length() <= 0) {
                throw new UtilsException("Non sono disponibili informazioni sul database");
            }
            String string = bf.toString();
            return string;
        }
        finally {
            try {
                if (c != null) {
                    this.dataSource.closeConnection(c);
                }
            }
            catch (Exception exception) {}
        }
    }
}

