/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt;

import org.jasypt.digest.config.DigesterConfig;
import org.jasypt.util.password.BasicPasswordEncryptor;
import org.jasypt.util.password.ConfigurablePasswordEncryptor;
import org.jasypt.util.password.StrongPasswordEncryptor;
import org.jasypt.util.password.rfc2307.RFC2307MD5PasswordEncryptor;
import org.jasypt.util.password.rfc2307.RFC2307SHAPasswordEncryptor;
import org.jasypt.util.password.rfc2307.RFC2307SMD5PasswordEncryptor;
import org.jasypt.util.password.rfc2307.RFC2307SSHAPasswordEncryptor;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.crypt.JasyptCustomDigesterConfig;
import org.openspcoop2.utils.crypt.JasyptCustomSaltGenerator;
import org.openspcoop2.utils.crypt.JasyptType;
import org.openspcoop2.utils.random.RandomGenerator;
import org.slf4j.Logger;

public class JasyptCrypt
implements ICrypt {
    private Logger log;
    private JasyptType type;
    private CryptConfig config;
    private RandomGenerator randomGenerator;
    private JasyptCustomSaltGenerator customSaltGenerator;

    public JasyptCrypt(JasyptType type) {
        this.type = type;
        if (this.type == null) {
            this.type = JasyptType.JASYPT_STRONG_PASSWORD;
        }
    }

    public JasyptCrypt() {
    }

    @Override
    public void init(Logger log, CryptConfig config) {
        this.log = log;
        if (this.type == null) {
            this.config = config;
            if (this.config == null) {
                this.config = new CryptConfig();
            }
            this.randomGenerator = new RandomGenerator(this.config.isUseSecureRandom(), this.config.getAlgorithmSecureRandom());
            this.customSaltGenerator = new JasyptCustomSaltGenerator(this.randomGenerator);
        }
    }

    public JasyptCustomSaltGenerator getCustomSaltGenerator() {
        return this.customSaltGenerator;
    }

    @Override
    public String crypt(String password) throws UtilsException {
        if (this.type != null) {
            switch (this.type) {
                case JASYPT_BASIC_PASSWORD: {
                    BasicPasswordEncryptor basicEncryptor = new BasicPasswordEncryptor();
                    return basicEncryptor.encryptPassword(password);
                }
                case JASYPT_STRONG_PASSWORD: {
                    StrongPasswordEncryptor strongEncryptor = new StrongPasswordEncryptor();
                    return strongEncryptor.encryptPassword(password);
                }
                case RFC2307_MD5: {
                    RFC2307MD5PasswordEncryptor rfcEncryptor = new RFC2307MD5PasswordEncryptor();
                    return rfcEncryptor.encryptPassword(password);
                }
                case RFC2307_SMD5: {
                    RFC2307SMD5PasswordEncryptor rfcEncryptor = new RFC2307SMD5PasswordEncryptor();
                    return rfcEncryptor.encryptPassword(password);
                }
                case RFC2307_SHA: {
                    RFC2307SHAPasswordEncryptor rfcEncryptor = new RFC2307SHAPasswordEncryptor();
                    return rfcEncryptor.encryptPassword(password);
                }
                case RFC2307_SSHA: {
                    RFC2307SSHAPasswordEncryptor rfcEncryptor = new RFC2307SSHAPasswordEncryptor();
                    return rfcEncryptor.encryptPassword(password);
                }
            }
            throw new UtilsException("Unsupported type '" + String.valueOf((Object)this.type) + "'");
        }
        ConfigurablePasswordEncryptor configurablePasswordEncryptor = this._getConfigurablePasswordEncryptor();
        return configurablePasswordEncryptor.encryptPassword(password);
    }

    @Override
    public boolean check(String password, String pwcrypt) {
        try {
            if (this.type != null) {
                switch (this.type) {
                    case JASYPT_BASIC_PASSWORD: {
                        BasicPasswordEncryptor basicEncryptor = new BasicPasswordEncryptor();
                        return basicEncryptor.checkPassword(password, pwcrypt);
                    }
                    case JASYPT_STRONG_PASSWORD: {
                        StrongPasswordEncryptor strongEncryptor = new StrongPasswordEncryptor();
                        return strongEncryptor.checkPassword(password, pwcrypt);
                    }
                    case RFC2307_MD5: {
                        RFC2307MD5PasswordEncryptor rfcEncryptor = new RFC2307MD5PasswordEncryptor();
                        return rfcEncryptor.checkPassword(password, pwcrypt);
                    }
                    case RFC2307_SMD5: {
                        RFC2307SMD5PasswordEncryptor rfcEncryptor = new RFC2307SMD5PasswordEncryptor();
                        return rfcEncryptor.checkPassword(password, pwcrypt);
                    }
                    case RFC2307_SHA: {
                        RFC2307SHAPasswordEncryptor rfcEncryptor = new RFC2307SHAPasswordEncryptor();
                        return rfcEncryptor.checkPassword(password, pwcrypt);
                    }
                    case RFC2307_SSHA: {
                        RFC2307SSHAPasswordEncryptor rfcEncryptor = new RFC2307SSHAPasswordEncryptor();
                        return rfcEncryptor.checkPassword(password, pwcrypt);
                    }
                }
                throw new RuntimeException("Unsupported type '" + String.valueOf((Object)this.type) + "'");
            }
            ConfigurablePasswordEncryptor configurablePasswordEncryptor = this._getConfigurablePasswordEncryptor();
            return configurablePasswordEncryptor.checkPassword(password, pwcrypt);
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.error("Verifica password '" + pwcrypt + "' fallita: " + e.getMessage(), e);
            }
            return false;
        }
    }

    private ConfigurablePasswordEncryptor _getConfigurablePasswordEncryptor() {
        ConfigurablePasswordEncryptor configurablePasswordEncryptor = new ConfigurablePasswordEncryptor();
        JasyptCustomDigesterConfig config = new JasyptCustomDigesterConfig(this.config, this.customSaltGenerator);
        configurablePasswordEncryptor.setConfig((DigesterConfig)config);
        configurablePasswordEncryptor.setStringOutputType(this.config.isUseBase64Encoding() ? "BASE64" : "hexadecimal");
        configurablePasswordEncryptor.setAlgorithm(config.getAlgorithm());
        return configurablePasswordEncryptor;
    }
}

