/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.certificate.ocsp.OCSPManager;

public class OCSPProvider {
    private boolean ocsp = false;
    private List<String> ocspTypes = new ArrayList<String>();
    private List<String> ocspLabels = new ArrayList<String>();
    private static final String NO_OCSP = "--no_ocsp--";
    private static List<String> noOCSP = new ArrayList<String>();

    public boolean isOcspEnabled() {
        return this.ocsp;
    }

    public OCSPProvider() {
        SortedMap<String> ocspSortedMap = OCSPManager.getInstance().getOCSPConfigTypesLabels();
        boolean bl = this.ocsp = ocspSortedMap != null && !ocspSortedMap.isEmpty();
        if (this.ocsp) {
            boolean ocspEnabled;
            ArrayList<String> ocspTypesAdd = new ArrayList<String>();
            ArrayList<String> ocspLabelsAdd = new ArrayList<String>();
            if (!ocspSortedMap.isEmpty()) {
                for (String type : ocspSortedMap.keys()) {
                    ocspTypesAdd.add(type);
                    ocspLabelsAdd.add(ocspSortedMap.get(type));
                }
            }
            boolean bl2 = ocspEnabled = !ocspTypesAdd.isEmpty();
            if (ocspEnabled) {
                this.ocspTypes.add("");
                this.ocspTypes.addAll(ocspTypesAdd);
                this.ocspLabels.add("-");
                this.ocspLabels.addAll(ocspLabelsAdd);
            }
        }
    }

    public List<String> getValues() {
        return this.ocsp ? this.ocspTypes : noOCSP;
    }

    public List<String> getLabels() {
        return this.ocsp ? this.ocspLabels : noOCSP;
    }

    static {
        noOCSP.add(NO_OCSP);
    }
}

