/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class SubjectAlternativeNames {
    private List<GeneralName> alternativeNames = new ArrayList<GeneralName>();

    public List<GeneralName> getObjectAlternativeNames() {
        return this.alternativeNames;
    }

    public GeneralName getObjectAlternativeName(int index) {
        return this.alternativeNames != null && this.alternativeNames.size() > index ? this.alternativeNames.get(index) : null;
    }

    public List<String> getAlternativeNames() {
        ArrayList<String> s = new ArrayList<String>();
        if (this.alternativeNames != null && !this.alternativeNames.isEmpty()) {
            for (GeneralName o : this.alternativeNames) {
                if (o.getName() == null) continue;
                s.add(o.getName().toString());
            }
        }
        return s;
    }

    public String getAlternativeName(int index) {
        if (this.alternativeNames != null && this.alternativeNames.size() > index) {
            return this.alternativeNames.get(index) != null && this.alternativeNames.get(index).getName() != null ? this.alternativeNames.get(index).getName().toString() : null;
        }
        return null;
    }

    public boolean containsAlternativeName(String name) throws CertificateParsingException {
        return this.containsAlternativeNameEngine(null, name);
    }

    public boolean containsAlternativeName(int tagNum, String name) throws CertificateParsingException {
        return this.containsAlternativeNameEngine(tagNum, name);
    }

    private boolean containsAlternativeNameEngine(Integer tagNum, String name) throws CertificateParsingException {
        if (name == null) {
            throw new CertificateParsingException("Param name undefined");
        }
        if (this.alternativeNames != null && !this.alternativeNames.isEmpty()) {
            for (GeneralName o : this.alternativeNames) {
                if (!this.equalsAlternativeName(tagNum, name, o)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean equalsAlternativeName(Integer tagNum, String name, GeneralName o) {
        if (o.getName() != null && name.equals(o.getName().toString())) {
            if (tagNum == null) {
                return true;
            }
            if (tagNum.intValue() == o.getTagNo()) {
                return true;
            }
        }
        return false;
    }

    public static SubjectAlternativeNames getSubjectAlternativeNames(byte[] encoded) {
        GeneralNames gns;
        Certificate c = Certificate.getInstance((Object)encoded);
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (gns = GeneralNames.fromExtensions((Extensions)exts, (ASN1ObjectIdentifier)Extension.subjectAlternativeName)) != null) {
            SubjectAlternativeNames san = null;
            GeneralName[] names = gns.getNames();
            if (names != null && names.length > 0) {
                san = new SubjectAlternativeNames();
                for (GeneralName generalName : names) {
                    san.alternativeNames.add(generalName);
                }
            }
            return san;
        }
        return null;
    }
}

