/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PEMReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PKCS1_BEGIN = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PKCS1_END = "-----END RSA PRIVATE KEY-----";
    public static final String PKCS8_BEGIN = "-----BEGIN PRIVATE KEY-----";
    public static final String PKCS8_END = "-----END PRIVATE KEY-----";
    public static final String PKCS8_ENCRYPTED_BEGIN = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    public static final String PKCS8_ENCRYPTED_END = "-----END ENCRYPTED PRIVATE KEY-----";
    public static final String PUBLIC_KEY_BEGIN = "-----BEGIN PUBLIC KEY-----";
    public static final String PUBLIC_KEY_END = "-----END PUBLIC KEY-----";
    public static final String X509_BEGIN = "-----BEGIN CERTIFICATE-----";
    public static final String X509_END = "-----END CERTIFICATE-----";
    private String privateKey;
    private String publicKey;
    private List<String> certificates = new ArrayList<String>();
    private boolean pkcs1;
    private boolean pkcs8;
    private boolean pkcs8encrypted;

    public PEMReader(byte[] pem) {
        this(pem, true, true, true);
    }

    public PEMReader(byte[] pem, boolean pkcs1, boolean pkcs8, boolean pkcs8encrypted) {
        this(PEMReader.getAsString(pem), pkcs1, pkcs8, pkcs8encrypted);
    }

    static String getAsString(byte[] pem) {
        String publicKeyString = null;
        try {
            publicKeyString = new String(pem);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return publicKeyString;
    }

    public PEMReader(String pem) {
        this(pem, true, true, true);
    }

    public PEMReader(String pem, boolean pkcs1, boolean pkcs8, boolean pkcs8encrypted) {
        if (pem == null) {
            return;
        }
        pem = pem.trim();
        if (pkcs1 && pem.contains(PKCS1_BEGIN)) {
            this.privateKey = this.read(pem, PKCS1_BEGIN, PKCS1_END);
            this.pkcs1 = this.privateKey != null && StringUtils.isNotEmpty((CharSequence)this.privateKey);
        } else if (pkcs8 && pem.contains(PKCS8_BEGIN)) {
            this.privateKey = this.read(pem, PKCS8_BEGIN, PKCS8_END);
            this.pkcs8 = this.privateKey != null && StringUtils.isNotEmpty((CharSequence)this.privateKey);
        } else if (pkcs8encrypted && pem.contains(PKCS8_ENCRYPTED_BEGIN)) {
            this.privateKey = this.read(pem, PKCS8_ENCRYPTED_BEGIN, PKCS8_ENCRYPTED_END);
            boolean bl = this.pkcs8encrypted = this.privateKey != null && StringUtils.isNotEmpty((CharSequence)this.privateKey);
        }
        if (pem.contains(PUBLIC_KEY_BEGIN)) {
            this.publicKey = this.read(pem, PUBLIC_KEY_BEGIN, PUBLIC_KEY_END);
        }
        if (pem.contains(X509_BEGIN)) {
            this.initCertificate(pem);
        }
    }

    private void initCertificate(String pem) {
        String cert = this.read(pem, X509_BEGIN, X509_END);
        String check = pem;
        for (int index = 0; cert != null && StringUtils.isNotEmpty((CharSequence)cert) && index <= 1000; ++index) {
            this.certificates.add(cert);
            check = check.replace(cert, "");
            cert = check.contains(X509_BEGIN) ? this.read(check, X509_BEGIN, X509_END) : null;
        }
    }

    private String read(String pem, String begin, String end) {
        String tmp;
        int indexOfEnd;
        int indexOf;
        if (pem.contains(begin) && pem.contains(end) && (indexOf = pem.indexOf(begin)) >= 0 && (indexOfEnd = (tmp = indexOf > 0 ? pem.substring(indexOf) : pem).indexOf(end)) >= 0) {
            return this.readEngine(tmp, indexOfEnd);
        }
        return null;
    }

    private String readEngine(String tmp, int indexOfEnd) {
        String s;
        int indexOfEndLine = tmp.indexOf("\n", indexOfEnd + 1);
        if (indexOfEndLine <= 0) {
            indexOfEndLine = tmp.indexOf("\r", indexOfEnd + 1);
        }
        if (indexOfEndLine <= 0) {
            indexOfEndLine = tmp.length();
        }
        if ((s = tmp.substring(0, indexOfEndLine)) != null) {
            s = s.trim();
        }
        return s;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public List<String> getCertificates() {
        return this.certificates;
    }

    public boolean isPkcs1() {
        return this.pkcs1;
    }

    public boolean isPkcs8() {
        return this.pkcs8;
    }

    public boolean isPkcs8encrypted() {
        return this.pkcs8encrypted;
    }
}

