/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;

public enum ExtendedKeyUsage {
    ANY_EXTENDED_KEY_USAGE(KeyPurposeId.anyExtendedKeyUsage),
    SERVER_AUTH(KeyPurposeId.id_kp_serverAuth),
    CLIENT_AUTH(KeyPurposeId.id_kp_clientAuth),
    CODE_SIGNING(KeyPurposeId.id_kp_codeSigning),
    EMAIL_PROTECTION(KeyPurposeId.id_kp_emailProtection),
    IPSEC_END_SYSTEM(KeyPurposeId.id_kp_ipsecEndSystem),
    IPSEC_TUNNEL(KeyPurposeId.id_kp_ipsecTunnel),
    IPSEC_USER(KeyPurposeId.id_kp_ipsecUser),
    TIME_STAMPING(KeyPurposeId.id_kp_timeStamping),
    OCSP_SIGNING(KeyPurposeId.id_kp_OCSPSigning),
    DVCS(KeyPurposeId.id_kp_dvcs),
    SBGP_CERT_AA_SERVER_AUTH(KeyPurposeId.id_kp_sbgpCertAAServerAuth),
    SCVP_RESPONDER(KeyPurposeId.id_kp_scvp_responder),
    EAP_OVER_PPP(KeyPurposeId.id_kp_eapOverPPP),
    EAP_OVER_LAN(KeyPurposeId.id_kp_eapOverLAN),
    SCVP_SERVER(KeyPurposeId.id_kp_scvpServer),
    SCVP_CLIENT(KeyPurposeId.id_kp_scvpClient),
    IPSEC_IKE(KeyPurposeId.id_kp_ipsecIKE),
    CAPWAP_AC(KeyPurposeId.id_kp_capwapAC),
    CAPWAP_WTP(KeyPurposeId.id_kp_capwapWTP),
    SMART_CARD_LOGON(KeyPurposeId.id_kp_smartcardlogon),
    MAC_ADDRESS(KeyPurposeId.id_kp_macAddress),
    MS_SGC(KeyPurposeId.id_kp_msSGC),
    NS_SGC(KeyPurposeId.id_kp_nsSGC);

    private String oid;
    private KeyPurposeId purposeId;

    private ExtendedKeyUsage(KeyPurposeId purposeId) {
        this.oid = purposeId.getId();
        this.purposeId = purposeId;
    }

    public String getId() {
        return this.oid;
    }

    public KeyPurposeId getPurposeId() {
        if (this.purposeId != null) {
            return this.purposeId;
        }
        return KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(this.oid));
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean printOID) {
        if (printOID) {
            return this.name() + " (" + this.oid + ")";
        }
        return this.name();
    }

    public boolean hasKeyUsage(Certificate x509) throws CertificateParsingException {
        if (x509.getCertificate() != null) {
            return this.hasKeyUsage(x509.getCertificate());
        }
        return false;
    }

    public boolean hasKeyUsage(CertificateInfo x509) throws CertificateParsingException {
        return this.hasKeyUsage(x509.getCertificate());
    }

    public boolean hasKeyUsage(X509Certificate x509) throws CertificateParsingException {
        return ExtendedKeyUsage.existsKeyUsageByOID(x509, this.oid);
    }

    public static boolean existsKeyUsageByOID(X509Certificate x509, String oid) throws CertificateParsingException {
        if (x509.getExtendedKeyUsage() != null) {
            return x509.getExtendedKeyUsage().contains(oid);
        }
        return false;
    }

    public boolean hasKeyUsage(byte[] encoded) {
        return ExtendedKeyUsage.existsKeyUsageByBouncycastleKeyPurposeId(encoded, this.purposeId);
    }

    public static boolean existsKeyUsageByBouncycastleKeyPurposeId(byte[] encoded, String keyPurposeId) {
        return ExtendedKeyUsage.existsKeyUsageByBouncycastleKeyPurposeId(encoded, KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(keyPurposeId)));
    }

    public static boolean existsKeyUsageByBouncycastleKeyPurposeId(byte[] encoded, KeyPurposeId keyPurposeId) {
        org.bouncycastle.asn1.x509.ExtendedKeyUsage eKey;
        org.bouncycastle.asn1.x509.Certificate c = org.bouncycastle.asn1.x509.Certificate.getInstance((Object)encoded);
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (eKey = org.bouncycastle.asn1.x509.ExtendedKeyUsage.fromExtensions((Extensions)exts)) != null) {
            return eKey.hasKeyPurposeId(keyPurposeId);
        }
        return false;
    }

    public static ExtendedKeyUsage toExtendedKeyUsage(String id) {
        ExtendedKeyUsage[] v;
        for (ExtendedKeyUsage usage : v = ExtendedKeyUsage.values()) {
            if (!usage.oid.equals(id)) continue;
            return usage;
        }
        return null;
    }

    public static ExtendedKeyUsage toExtendedKeyUsage(KeyPurposeId purposeId) {
        ExtendedKeyUsage[] v;
        for (ExtendedKeyUsage usage : v = ExtendedKeyUsage.values()) {
            if (!usage.purposeId.equals((Object)purposeId)) continue;
            return usage;
        }
        return null;
    }

    public static List<ExtendedKeyUsage> getKeyUsage(Certificate x509) throws CertificateParsingException {
        if (x509.getCertificate() != null) {
            return ExtendedKeyUsage.getKeyUsage(x509.getCertificate());
        }
        return new ArrayList<ExtendedKeyUsage>();
    }

    public static List<ExtendedKeyUsage> getKeyUsage(CertificateInfo x509) throws CertificateParsingException {
        return ExtendedKeyUsage.getKeyUsage(x509.getCertificate());
    }

    public static List<ExtendedKeyUsage> getKeyUsage(X509Certificate x509) throws CertificateParsingException {
        ExtendedKeyUsage[] values;
        ArrayList<ExtendedKeyUsage> l = new ArrayList<ExtendedKeyUsage>();
        for (ExtendedKeyUsage keyUsage : values = ExtendedKeyUsage.values()) {
            if (!keyUsage.hasKeyUsage(x509)) continue;
            l.add(keyUsage);
        }
        return l;
    }

    public static List<ExtendedKeyUsage> getKeyUsage(byte[] encoded) {
        ExtendedKeyUsage[] values;
        ArrayList<ExtendedKeyUsage> l = new ArrayList<ExtendedKeyUsage>();
        for (ExtendedKeyUsage keyUsage : values = ExtendedKeyUsage.values()) {
            if (!keyUsage.hasKeyUsage(encoded)) continue;
            l.add(keyUsage);
        }
        return l;
    }
}

