/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extensions;

public class BasicConstraints {
    private boolean ca;
    private long pathLen;

    public long getPathLen() {
        return this.pathLen;
    }

    public boolean isCA() {
        return this.ca;
    }

    public static BasicConstraints getBasicConstraints(byte[] encoded) {
        org.bouncycastle.asn1.x509.BasicConstraints basicConstraints;
        Certificate c = Certificate.getInstance((Object)encoded);
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (basicConstraints = org.bouncycastle.asn1.x509.BasicConstraints.fromExtensions((Extensions)exts)) != null) {
            BasicConstraints bc = new BasicConstraints();
            bc.ca = basicConstraints.isCA();
            if (basicConstraints.getPathLenConstraint() != null) {
                bc.pathLen = basicConstraints.getPathLenConstraint().longValue();
            }
            return bc;
        }
        return null;
    }
}

