/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.text.WordUtils;
import org.openspcoop2.utils.CopyCharStream;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.CopyStreamMethod;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class Utilities {
    public static final int DIMENSIONE_BUFFER = 65536;
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    private static int counterFileNameWithCharNotPermitted = 0;
    private static boolean freeMemoryLog = false;
    private static Logger log;
    public static final Runtime s_runtime;
    public static final long INITIAL_SIZE;

    private Utilities() {
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException t) {
            Thread.currentThread().interrupt();
        }
    }

    public static Executor newSingleThreadExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    public static <T> T execute(int secondsTimeout, Callable<?> callable) throws TimeoutException, UtilsException {
        Executor ex = Utilities.newSingleThreadExecutor();
        T res = null;
        Throwable exc = null;
        if (ex instanceof ExecutorService) {
            ExecutorService executor = (ExecutorService)ex;
            try {
                Future<?> future = executor.submit(callable);
                res = (T)future.get(secondsTimeout, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UtilsException(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new UtilsException(e.getMessage(), e);
            }
            finally {
                executor.shutdownNow();
                try {
                    Method closeMethod = executor.getClass().getMethod("close", new Class[0]);
                    closeMethod.invoke((Object)executor, new Object[0]);
                }
                catch (NoSuchMethodException closeMethod) {
                }
                catch (Exception e) {
                    exc = e;
                }
            }
        }
        if (res != null) {
            return res;
        }
        if (exc != null) {
            throw new UtilsException(exc.getMessage(), exc);
        }
        throw new UtilsException("ExecutorService unab");
    }

    public static <T> T newInstance(String className) throws UtilsException {
        if (className != null && !StringUtils.isEmpty((CharSequence)className)) {
            try {
                return (T)Utilities.newInstance(Class.forName(className));
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return null;
    }

    public static <T> T newInstance(Class<T> classType) throws UtilsException {
        if (classType != null) {
            try {
                return classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return null;
    }

    public static <T> T newInstanceThrowInstantiationException(String className) throws InstantiationException {
        try {
            return Utilities.newInstance(className);
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    public static <T> T newInstanceThrowInstantiationException(Class<T> classType) throws InstantiationException {
        try {
            return Utilities.newInstance(classType);
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    public static boolean equalsClass(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.getClass().equals(o2.getClass());
    }

    public static String getAsString(URL url, String charsetName) throws UtilsException {
        return Utilities.getAsString(url, charsetName, true);
    }

    public static String getAsString(URL url, String charsetName, boolean throwExceptionInputStreamEmpty) throws UtilsException {
        try {
            String content = null;
            try (InputStream openStream = url.openStream();){
                content = Utilities.getAsString(openStream, charsetName, throwExceptionInputStreamEmpty);
            }
            return content;
        }
        catch (UtilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.getAsString error " + e.getMessage(), e);
        }
    }

    public static String getAsString(InputStream is, String charsetName) throws UtilsException {
        return Utilities.getAsString(is, charsetName, true);
    }

    public static String getAsString(InputStream is, String charsetName, boolean throwExceptionInputStreamEmpty) throws UtilsException {
        try {
            StringBuilder sb = Utilities.getAsInputStreamReader(is, charsetName, throwExceptionInputStreamEmpty);
            if (sb == null) {
                return null;
            }
            return sb.toString();
        }
        catch (UtilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.getAsString error " + e.getMessage(), e);
        }
    }

    public static StringBuilder getAsInputStreamReader(InputStream isParam, String charsetName) throws UtilsException {
        return Utilities.getAsInputStreamReader(isParam, charsetName, true);
    }

    public static StringBuilder getAsInputStreamReader(InputStream isParam, String charsetName, boolean throwExceptionInputStreamEmpty) throws UtilsException {
        StringBuilder stringBuilder;
        InputStream is = null;
        try {
            if (isParam == null) {
                if (throwExceptionInputStreamEmpty) {
                    throw new UtilsException("InputStream is null");
                }
                return null;
            }
            is = Utilities.normalizeStream(isParam, throwExceptionInputStreamEmpty);
            if (is == null) {
                return null;
            }
        }
        catch (Exception e) {
            throw Utilities.parseException(e, "getAsInputStreamReader");
        }
        InputStreamReader isr = new InputStreamReader(is, charsetName);
        try {
            StringWriter writer = new StringWriter();
            CopyCharStream.copy((Reader)isr, (Writer)writer);
            stringBuilder = new StringBuilder(writer.toString());
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw Utilities.parseException(e, "getAsInputStreamReader");
            }
        }
        isr.close();
        return stringBuilder;
    }

    private static UtilsException parseException(Exception e, String method) {
        Throwable tInternal;
        if (e instanceof IOException) {
            if (!Utilities.isEmpytMessageException(e)) {
                return new UtilsException(e.getMessage(), e);
            }
        } else if (Utilities.existsInnerException((Throwable)e, IOException.class) && !Utilities.isEmpytMessageException(tInternal = Utilities.getInnerException((Throwable)e, IOException.class))) {
            return new UtilsException(tInternal.getMessage(), e);
        }
        if ((tInternal = Utilities.getInnerNotEmptyMessageException(e)) != null) {
            return new UtilsException(tInternal.getMessage(), e);
        }
        return new UtilsException("Utilities." + method + " error", e);
    }

    public static byte[] getAsByteArray(URL url) throws UtilsException {
        return Utilities.getAsByteArray(url, true);
    }

    public static byte[] getAsByteArray(URL url, boolean throwExceptionInputStreamEmpty) throws UtilsException {
        try {
            byte[] content = null;
            try (InputStream openStream = url.openStream();){
                content = Utilities.getAsByteArray(openStream, throwExceptionInputStreamEmpty);
            }
            return content;
        }
        catch (UtilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readBytes error " + e.getMessage(), e);
        }
    }

    public static byte[] getAsByteArray(InputStream is) throws UtilsException {
        return Utilities.getAsByteArray(is, true);
    }

    public static byte[] getAsByteArray(InputStream is, boolean throwExceptionInputStreamEmpty) throws UtilsException {
        try {
            byte[] returnNull = null;
            ByteArrayOutputStream bout = Utilities.getAsByteArrayOuputStream(is, throwExceptionInputStreamEmpty);
            if (bout != null) {
                return bout.toByteArray();
            }
            return returnNull;
        }
        catch (UtilsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readBytes error " + e.getMessage(), e);
        }
    }

    public static ByteArrayOutputStream getAsByteArrayOuputStream(InputStream isParam) throws UtilsException {
        return Utilities.getAsByteArrayOuputStream(isParam, true);
    }

    public static void writeAsByteArrayOuputStream(ByteArrayOutputStream bout, InputStream isParam) throws UtilsException {
        Utilities.writeAsByteArrayOuputStream(bout, isParam, true);
    }

    public static ByteArrayOutputStream getAsByteArrayOuputStream(InputStream isParam, boolean throwExceptionInputStreamEmpty) throws UtilsException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Utilities.writeAsByteArrayOuputStream(bout, isParam, throwExceptionInputStreamEmpty);
        if (bout.size() > 0) {
            return bout;
        }
        return null;
    }

    public static void writeAsByteArrayOuputStream(OutputStream bout, InputStream isParam, boolean throwExceptionInputStreamEmpty) throws UtilsException {
        try {
            if (isParam == null) {
                if (throwExceptionInputStreamEmpty) {
                    throw new UtilsException("InputStream is null");
                }
                return;
            }
            InputStream is = Utilities.normalizeStream(isParam, throwExceptionInputStreamEmpty);
            if (is == null) {
                return;
            }
            CopyStream.copy(CopyStreamMethod.AUTO, is, bout);
        }
        catch (Exception e) {
            throw Utilities.parseException(e, "writeAsByteArrayOuputStream");
        }
    }

    public static InputStream normalizeStream(InputStream is, boolean throwExceptionInputStreamEmpty) throws UtilsException {
        try {
            if (is != null) {
                byte[] buffer = new byte[2];
                int letti = is.read(buffer);
                if (letti <= 0) {
                    if (throwExceptionInputStreamEmpty) {
                        throw new UtilsException("InputStream is empty (class:" + is.getClass().getName() + ")");
                    }
                    return null;
                }
                byte[] b = null;
                b = letti == 2 ? buffer : new byte[]{buffer[0]};
                return new SequenceInputStream(new ByteArrayInputStream(b), is);
            }
            return is;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copy(InputStream is, OutputStream os) throws UtilsException {
        try {
            CopyStream.copy(CopyStreamMethod.AUTO, is, os);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void copyServerSentEvents(InputStream is, OutputStream os) throws UtilsException {
        try {
            CopyStream.copy(CopyStreamMethod.SERVER_SENT_EVENTS, is, os);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static Properties getAsProperties(InputStream is) throws UtilsException {
        try {
            if (is == null) {
                throw new UtilsException("Utilities.getAsProperties error: InputStream is null");
            }
            Properties p = new Properties();
            p.load(is);
            return p;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static Properties getAsProperties(byte[] content) throws UtilsException {
        Properties properties;
        if (content == null) {
            throw new UtilsException("Utilities.getAsProperties error: Content is null");
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(content);
        try {
            properties = Utilities.getAsProperties(bin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        bin.close();
        return properties;
    }

    public static Properties getAsProperties(URL url) throws UtilsException {
        InputStream is = null;
        try {
            if (url == null) {
                throw new UtilsException("Utilities.getAsProperties error: URL is null");
            }
            is = url.openStream();
            Properties properties = Utilities.getAsProperties(is);
            return properties;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static Properties readProperties(String prefix, Properties sorgente) throws UtilsException {
        Properties prop = new Properties();
        try {
            Enumeration<?> en = sorgente.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(prefix)) continue;
                String key = property.substring(prefix.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = sorgente.getProperty(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readProperties Riscontrato errore durante la lettura delle proprieta' con prefisso [" + prefix + "]: " + e.getMessage(), e);
        }
    }

    public static Properties readProperties(String prefix, String[] key, String[] name) throws UtilsException {
        Properties sorgente = new Properties();
        if (key != null && name != null && key.length == name.length) {
            for (int i = 0; i < key.length; ++i) {
                sorgente.put(key[i], name[i]);
            }
        }
        return Utilities.readProperties(prefix, sorgente);
    }

    public static String convertSystemTimeIntoStringMillisecondi(long time, boolean millisecondiCheck) {
        return Utilities.convertSystemTimeIntoStringMillisecondi(time, millisecondiCheck, true, ":", ".", "");
    }

    public static String convertSystemTimeIntoStringMillisecondi(long time, boolean millisecondiCheck, boolean printZeroValues, String separatorUnit, String separatorMs, String separatorValue) {
        long millisecondi = time % 1000L;
        long diff = time / 1000L;
        long ore = diff / 3600L;
        long minuti = diff % 3600L / 60L;
        long secondi = diff % 3600L % 60L;
        StringBuilder bf = new StringBuilder();
        long giorni = ore / 24L;
        long oreRimaste = ore % 24L;
        if (giorni > 0L) {
            bf.append(giorni);
            bf.append(separatorValue);
            bf.append("d");
        }
        if (giorni > 0L) {
            if (oreRimaste > 0L) {
                if (bf.length() > 0) {
                    bf.append(separatorUnit);
                }
                bf.append(oreRimaste);
                bf.append(separatorValue);
                bf.append("h");
            } else if (printZeroValues && bf.length() > 0) {
                bf.append(separatorUnit);
                bf.append("0");
                bf.append(separatorValue);
                bf.append("h");
            }
        } else if (ore > 0L) {
            if (bf.length() > 0) {
                bf.append(separatorUnit);
            }
            bf.append(ore);
            bf.append(separatorValue);
            bf.append("h");
        } else if (printZeroValues && bf.length() > 0) {
            bf.append(separatorUnit);
            bf.append("0");
            bf.append(separatorValue);
            bf.append("h");
        }
        if (minuti > 0L) {
            if (bf.length() > 0) {
                bf.append(separatorUnit);
            }
            bf.append(minuti);
            bf.append(separatorValue);
            bf.append("m");
        } else if (printZeroValues && bf.length() > 0) {
            bf.append(separatorUnit);
            bf.append("0");
            bf.append(separatorValue);
            bf.append("m");
        }
        if (secondi > 0L) {
            if (bf.length() > 0) {
                bf.append(separatorUnit);
            }
            bf.append(secondi);
            bf.append(separatorValue);
            bf.append("s");
        } else if (printZeroValues && bf.length() > 0) {
            bf.append(separatorUnit);
            bf.append("0");
            bf.append(separatorValue);
            bf.append("s");
        }
        if (millisecondiCheck) {
            if (millisecondi > 0L || millisecondi == 0L && printZeroValues) {
                if (bf.length() > 0) {
                    bf.append(separatorMs);
                }
                bf.append(millisecondi);
                bf.append(separatorValue);
                bf.append("ms");
            } else if (printZeroValues && bf.length() > 0) {
                bf.append(separatorMs);
                bf.append("0");
                bf.append(separatorValue);
                bf.append("ms");
            }
        }
        if (bf.length() == 0) {
            bf.append("conversione non riuscita");
        }
        return bf.toString();
    }

    public static long convertSystemTimeInNumeroOre(long time) {
        if (time < 0L) {
            time = 0L;
        }
        long diff = time / 1000L;
        long ore = diff / 3600L;
        if (diff % 3600L != 0L) {
            ++ore;
        }
        return ore;
    }

    public static long convertSystemTimeInNumeroGiorni(long time) {
        if (time < 0L) {
            time = 0L;
        }
        long diff = time / 1000L;
        long ore = diff / 3600L;
        if (diff % 3600L != 0L) {
            ++ore;
        }
        long giorni = ore / 24L;
        long oreRimaste = ore % 24L;
        if (oreRimaste != 0L) {
            ++giorni;
        }
        return giorni;
    }

    public static String convertBytesToFormatString(long value) {
        return Utilities.convertBytesToFormatString(value, false, "");
    }

    public static String convertBytesToFormatString(long value, boolean upperCase, String separator) {
        MessageFormat mf = new MessageFormat("{0,number,#.##}");
        Double len = null;
        Object res = "";
        len = Long.valueOf("" + value).doubleValue();
        long d = Math.round(len / 1024.0);
        if (d <= 1L) {
            Object[] objs = new Object[]{len};
            res = mf.format(objs);
            res = (String)res + separator;
            res = (String)res + "b";
        } else if (d > 1L && d < 1000L) {
            Object[] objs = new Object[]{len / 1024.0};
            res = mf.format(objs);
            res = (String)res + separator;
            res = (String)res + "kb";
        } else if (d >= 1000L && d < 1000000L) {
            Object[] objs = new Object[]{len / 1048576.0};
            res = mf.format(objs);
            res = (String)res + separator;
            res = (String)res + "mb";
        } else {
            Object[] objs = new Object[]{len / 1.073741824E9};
            res = mf.format(objs);
            res = (String)res + separator;
            res = (String)res + "gb";
        }
        if (upperCase) {
            res = ((String)res).toUpperCase();
        }
        return res;
    }

    public static String convertNameToSistemaOperativoCompatible(String nome, boolean convertCharNotPermitted, Character charJollyCharNotPermitted, List<Character> permit, boolean addUniqueSuffixIfFoundCharNotPermitted) {
        StringBuilder bf = new StringBuilder();
        boolean charNotPermittedFound = false;
        for (int i = 0; i < nome.length(); ++i) {
            if (Character.isLetterOrDigit(nome.charAt(i))) {
                bf.append(nome.charAt(i));
                continue;
            }
            if (permit != null) {
                boolean found = false;
                for (char charPermit : permit) {
                    if (charPermit != nome.charAt(i)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    bf.append(nome.charAt(i));
                    continue;
                }
            }
            if (convertCharNotPermitted) {
                bf.append(charJollyCharNotPermitted);
            }
            charNotPermittedFound = true;
        }
        if (charNotPermittedFound && addUniqueSuffixIfFoundCharNotPermitted) {
            bf.append("_");
            bf.append(Utilities.getNextCounterFile());
        }
        return bf.toString();
    }

    private static synchronized int getNextCounterFile() {
        if (counterFileNameWithCharNotPermitted == Integer.MAX_VALUE) {
            counterFileNameWithCharNotPermitted = 0;
        }
        return ++counterFileNameWithCharNotPermitted;
    }

    public static String camelCase(String value) {
        char[] delimiters = new char[]{'.', '_', '-', ':', ';', ',', ' '};
        return Utilities.camelCase(delimiters, value);
    }

    public static String camelCase(char[] delimiters, String value) {
        String s = WordUtils.capitalizeFully((String)value, (char[])delimiters);
        for (int i = 0; i < delimiters.length; ++i) {
            String c = "" + delimiters[i];
            while (s.contains(c)) {
                s = s.replace(c, "");
            }
        }
        return s;
    }

    public static String[] split(String value, char separator) throws UtilsException {
        StringBuilder bf = new StringBuilder();
        ArrayList<String> splitResults = new ArrayList<String>();
        if (value == null || value.length() <= 0) {
            throw new UtilsException("Valore non fornito");
        }
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == separator) {
                if (i > 0 && value.charAt(i - 1) != '\\' || i == 0) {
                    splitResults.add(bf.toString());
                    bf.delete(0, bf.length());
                    continue;
                }
                bf.append(value.charAt(i));
                continue;
            }
            bf.append(value.charAt(i));
        }
        splitResults.add(bf.toString());
        return splitResults.toArray(new String[1]);
    }

    public static boolean isFreeMemoryLog() {
        return freeMemoryLog;
    }

    public static void setFreeMemoryLog(boolean freeMemoryLog) {
        Utilities.freeMemoryLog = freeMemoryLog;
    }

    public static void setLog(Logger log) {
        Utilities.log = log;
    }

    public static void printFreeMemory(String descr) {
        if (freeMemoryLog) {
            long currentSize = s_runtime.freeMemory();
            String msg = "[Free Memory Space][CURRENT: " + Utilities.convertBytesToFormatString(currentSize) + "] [DIFF: " + Utilities.convertBytesToFormatString(INITIAL_SIZE - s_runtime.freeMemory()) + "] " + descr;
            log.debug(msg);
        }
    }

    public static String readFirstErrorValidMessageFromException(Throwable e) {
        if (e instanceof NullPointerException) {
            return "NullPointerException";
        }
        Throwable inner = Utilities.getInnerNotEmptyMessageException(e);
        if (inner != null) {
            return inner.getMessage();
        }
        if (Utilities.isEmpytMessageException(e)) {
            return e.toString();
        }
        return e.getMessage();
    }

    public static boolean isEmpytMessageException(Throwable e) {
        return e == null || e.getMessage() == null || "".equals(e.getMessage()) || "null".equalsIgnoreCase(e.getMessage());
    }

    public static boolean existsInnerInstanceException(Throwable e, Class<?> found) {
        if (found.isInstance(e)) {
            return true;
        }
        if (e.getCause() != null) {
            return Utilities.existsInnerInstanceException(e.getCause(), found);
        }
        return false;
    }

    public static boolean existsInnerInstanceException(Throwable e, String found) throws ClassNotFoundException {
        return Utilities.existsInnerInstanceException(e, Class.forName(found));
    }

    public static Throwable getInnerInstanceException(Throwable e, Class<?> found, boolean last) {
        if (found.isInstance(e)) {
            if (last) {
                if (e.getCause() != null && Utilities.existsInnerInstanceException(e.getCause(), found)) {
                    return Utilities.getInnerInstanceException(e.getCause(), found, last);
                }
                return e;
            }
            return e;
        }
        if (e.getCause() != null) {
            return Utilities.getInnerInstanceException(e.getCause(), found, last);
        }
        return null;
    }

    public static Throwable getInnerInstanceException(Throwable e, String found, boolean last) throws ClassNotFoundException {
        return Utilities.getInnerInstanceException(e, Class.forName(found), last);
    }

    public static boolean existsInnerException(Throwable e, Class<?> found) {
        return Utilities.existsInnerException(e, found.getName());
    }

    public static boolean existsInnerException(Throwable e, String found) {
        if (e.getClass().getName().equals(found)) {
            return true;
        }
        if (e.getCause() != null) {
            return Utilities.existsInnerException(e.getCause(), found);
        }
        return false;
    }

    public static Throwable getInnerException(Throwable e, Class<?> found) {
        return Utilities.getInnerException(e, found.getName());
    }

    public static Throwable getInnerException(Throwable e, String found) {
        if (e.getClass().getName().equals(found)) {
            return e;
        }
        if (e.getCause() != null) {
            return Utilities.getInnerException(e.getCause(), found);
        }
        return null;
    }

    public static Throwable getLastInnerException(Throwable e) {
        if (e.getCause() == null) {
            return e;
        }
        return Utilities.getLastInnerException(e.getCause());
    }

    public static boolean existsInnerMessageException(Throwable e, String msg, boolean contains) {
        boolean search = false;
        if (contains) {
            search = e.getMessage() != null && e.getMessage().contains(msg);
        } else {
            boolean bl = search = e.getMessage() != null && e.getMessage().equals(msg);
        }
        if (search) {
            return true;
        }
        if (e.getCause() != null) {
            return Utilities.existsInnerMessageException(e.getCause(), msg, contains);
        }
        return false;
    }

    public static Throwable getInnerMessageException(Throwable e, String msg, boolean contains) {
        boolean search = false;
        if (contains) {
            search = e.getMessage() != null && e.getMessage().contains(msg);
        } else {
            boolean bl = search = e.getMessage() != null && e.getMessage().equals(msg);
        }
        if (search) {
            return e;
        }
        if (e.getCause() != null) {
            return Utilities.getInnerMessageException(e.getCause(), msg, contains);
        }
        return null;
    }

    public static Throwable getInnerNotEmptyMessageException(Throwable e) {
        if (e.getMessage() != null && !"".equals(e.getMessage()) && !"null".equalsIgnoreCase(e.getMessage())) {
            return e;
        }
        if (e.getCause() != null) {
            return Utilities.getInnerNotEmptyMessageException(e.getCause());
        }
        return e;
    }

    public static boolean isExceptionInstanceOf(Class<?> c, Throwable t) {
        return Utilities.isExceptionInstanceOf(c.getName(), t);
    }

    public static boolean isExceptionInstanceOf(String className, Throwable t) {
        if (t.getClass().getName().equals(className)) {
            return true;
        }
        try {
            Class<?> c = Class.forName(className);
            return c.isInstance(t);
        }
        catch (Exception tException) {
            return false;
        }
    }

    public static String eraserXmlAttribute(String tmp, String keyword) {
        int indexOfValueWrong = tmp.indexOf(keyword);
        while (indexOfValueWrong > 0) {
            StringBuilder bf = new StringBuilder();
            int index = indexOfValueWrong - 1;
            while (tmp.charAt(index) != ' ') {
                bf.append(tmp.charAt(index));
                --index;
            }
            StringBuilder replaceString = new StringBuilder();
            for (int i = bf.toString().length() - 1; i >= 0; --i) {
                replaceString.append(bf.toString().charAt(i));
            }
            replaceString.append(keyword);
            index = indexOfValueWrong + keyword.length();
            while (tmp.charAt(index) != ' ' && tmp.charAt(index) != '>') {
                replaceString.append(tmp.charAt(index));
                ++index;
            }
            tmp = Strings.CS.replace(tmp, replaceString.toString(), "");
            indexOfValueWrong = tmp.indexOf(keyword);
        }
        return tmp;
    }

    public static String getErrorMessagePrintableTextMaxLength(int length, int maxLength) {
        return "Visualizzazione non riuscita: la dimensione del pacchetto fornito (" + Utilities.convertBytesToFormatString(length) + ") supera il limite consentito (" + Utilities.convertBytesToFormatString(maxLength) + ")";
    }

    public static String convertToPrintableText(byte[] b, int maxBytes) throws UtilsException {
        String string;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            if (b.length > maxBytes) {
                throw new UtilsException(Utilities.getErrorMessagePrintableTextMaxLength(b.length, maxBytes));
            }
            for (int i = 0; i < b.length; ++i) {
                if (Utilities.isPrintableChar((char)b[i])) continue;
                throw new UtilsException("Visualizzazione non riuscita: il documento contiene caratteri non visualizzabili");
            }
            bout.write(b);
            bout.flush();
            string = bout.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UtilsException e) {
                throw e;
            }
            catch (Exception e) {
                throw new UtilsException("Visualizzazione non riuscita: Documento binario?", e);
            }
        }
        bout.close();
        return string;
    }

    public static boolean isPrintableChar(char c) {
        return Character.isDefined(c);
    }

    public static String toString(Locale locale) {
        return Utilities.toString(locale, "\n");
    }

    public static String toString(Locale locale, String separator) {
        StringBuilder bf = new StringBuilder();
        Utilities.toString(locale, bf, separator);
        return bf.toString();
    }

    public static void toString(Locale locale, StringBuilder bf, String separator) {
        bf.append(locale.getDisplayName());
        bf.append(separator);
        Utilities.addLanguage(locale, bf, separator);
        Utilities.addCountry(locale, bf, separator);
        bf.append("Script: ");
        if (locale.getScript() != null && !"".equals(locale.getScript().trim())) {
            bf.append(locale.getScript());
            bf.append(" (");
            bf.append(locale.getDisplayScript());
            bf.append(")");
        } else {
            bf.append("-");
        }
        bf.append(separator);
        bf.append("Variant: ");
        if (locale.getVariant() != null && !"".equals(locale.getVariant().trim())) {
            bf.append(locale.getVariant());
            bf.append(" (");
            bf.append(locale.getDisplayVariant());
            bf.append(")");
        } else {
            bf.append("-");
        }
        bf.append(separator);
    }

    private static void addLanguage(Locale locale, StringBuilder bf, String separator) {
        bf.append("Language: ");
        if (locale.getLanguage() != null && !"".equals(locale.getLanguage().trim())) {
            bf.append(locale.getLanguage());
            bf.append(" (");
            bf.append(locale.getDisplayLanguage());
            bf.append(") [ISO3:");
            try {
                if (locale.getISO3Language() != null) {
                    bf.append(locale.getISO3Language());
                } else {
                    bf.append("-");
                }
            }
            catch (Exception e) {
                bf.append(e.getMessage());
            }
            bf.append("]");
        } else {
            bf.append("-");
        }
        bf.append(separator);
    }

    private static void addCountry(Locale locale, StringBuilder bf, String separator) {
        bf.append("Country: ");
        if (locale.getCountry() != null && !"".equals(locale.getCountry().trim())) {
            bf.append(locale.getCountry());
            bf.append(" (");
            bf.append(locale.getDisplayCountry());
            bf.append(") [ISO3:");
            try {
                if (locale.getISO3Language() != null) {
                    bf.append(locale.getISO3Country());
                } else {
                    bf.append("-");
                }
            }
            catch (Exception e) {
                bf.append(e.getMessage());
            }
            bf.append("]");
        } else {
            bf.append("-");
        }
        bf.append(separator);
    }

    public static String toString(TimeZone timeZone) {
        return Utilities.toString(timeZone, false);
    }

    public static String toString(TimeZone timeZone, boolean allInfo) {
        StringBuilder bf = new StringBuilder();
        Utilities.toString(timeZone, bf, allInfo);
        return bf.toString();
    }

    public static void toString(TimeZone timeZone, StringBuilder bf, boolean allInfo) {
        bf.append(timeZone.getID());
        bf.append(" (");
        bf.append(timeZone.getDisplayName());
        bf.append(")");
        if (allInfo) {
            bf.append(" DSTSaving:");
            bf.append(timeZone.getDSTSavings());
            bf.append(" RawOffset:");
            bf.append(timeZone.getRawOffset());
        }
    }

    public static String buildUrl(String prefix, String contesto) {
        Object url = prefix;
        if (contesto != null && !"".equals(contesto)) {
            if (!((String)url).endsWith("/")) {
                if (!contesto.startsWith("/")) {
                    url = (String)url + "/";
                }
            } else if (contesto.startsWith("/") && contesto.length() > 1) {
                contesto = contesto.substring(1);
            }
            url = (String)url + contesto;
        }
        return url;
    }

    public static ConcurrentMap<String, String> convertToConcurrentHashMap(Properties map) {
        ConcurrentMap<String, String> mapReturnNull = null;
        if (map == null || map.isEmpty()) {
            return mapReturnNull;
        }
        ConcurrentHashMap<String, String> newMap = new ConcurrentHashMap<String, String>();
        for (Object k : map.keySet()) {
            if (!(k instanceof String)) continue;
            String key = (String)k;
            newMap.put(key, map.getProperty(key));
        }
        return newMap;
    }

    public static <K, V> ConcurrentMap<K, V> convertToConcurrentHashMap(Map<K, V> map) {
        ConcurrentMap<K, V> mapReturnNull = null;
        if (map == null || map.isEmpty()) {
            return mapReturnNull;
        }
        ConcurrentHashMap<K, V> newMap = new ConcurrentHashMap<K, V>();
        for (K k : map.keySet()) {
            newMap.put(k, map.get(k));
        }
        return newMap;
    }

    public static Map<String, String> convertToHashMap(Properties map) {
        Map<String, String> mapReturnNull = null;
        if (map == null || map.isEmpty()) {
            return mapReturnNull;
        }
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Object k : map.keySet()) {
            if (!(k instanceof String)) continue;
            String key = (String)k;
            newMap.put(key, map.getProperty(key));
        }
        return newMap;
    }

    public static boolean isOSUnix() {
        return SystemUtils.IS_OS_UNIX;
    }

    public static boolean isOSWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static boolean isOSMac() {
        return SystemUtils.IS_OS_MAC;
    }

    public static Path createTempPath(String prefix, String suffix) throws IOException {
        return Utilities.createTempPath(null, prefix, suffix);
    }

    public static Path createTempPath(Path dir, String prefix, String suffix) throws IOException {
        File f;
        if (SystemUtils.IS_OS_UNIX) {
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
            return dir != null ? Files.createTempFile(dir, prefix, suffix, attr) : Files.createTempFile(prefix, suffix, attr);
        }
        File file = f = dir != null ? Files.createTempFile(dir, prefix, suffix, new FileAttribute[0]).toFile() : Files.createTempFile(FileUtils.getTempDirectory().toPath(), prefix, suffix, new FileAttribute[0]).toFile();
        if (!f.setReadable(true, true)) {
            // empty if block
        }
        if (!f.setWritable(true, true)) {
            // empty if block
        }
        if (!f.setExecutable(true, true)) {
            // empty if block
        }
        return f.toPath();
    }

    public static void setEnvProperty(String key, String value) throws UtilsException {
        try {
            Map<String, String> env = System.getenv();
            Class<?> c = env.getClass();
            Field field = c.getDeclaredField("m");
            field.setAccessible(true);
            Map wEnv = (Map)field.get(env);
            wEnv.put(key, value);
        }
        catch (Exception e) {
            throw new UtilsException("setEnvProperty '" + key + "' failed: " + e.getMessage(), e);
        }
    }

    static {
        s_runtime = Runtime.getRuntime();
        INITIAL_SIZE = s_runtime.freeMemory();
    }
}

