/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.utils.MapKey;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.UtilsRuntimeException;

public class Map<T>
extends HashMap<MapKey<String>, T>
implements Serializable {
    private static final long serialVersionUID = -2577197242840238762L;
    private static int uniqueIndex = 0;
    private static HashMap<String, MapKey<String>> internalMap = new HashMap();
    private static Semaphore semaphoreNewMapKey = new Semaphore("Map");

    private static int getUniqueIndex() {
        if (uniqueIndex + 1 > Integer.MAX_VALUE) {
            throw new UtilsRuntimeException("Max id reached");
        }
        return ++uniqueIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MapKey<String> internalNewMapKey(String key) {
        SemaphoreLock lock = semaphoreNewMapKey.acquireThrowRuntime("newMapKey");
        try {
            if (!internalMap.containsKey(key)) {
                int uniqueIndex = Map.getUniqueIndex();
                MapKey<String> mapKey = new MapKey<String>(key, uniqueIndex);
                internalMap.put(key, mapKey);
                MapKey<String> mapKey2 = mapKey;
                return mapKey2;
            }
            MapKey<String> mapKey = internalMap.get(key);
            return mapKey;
        }
        finally {
            semaphoreNewMapKey.release(lock, "newMapKey");
        }
    }

    public static MapKey<String> newMapKey(String key) {
        if (!internalMap.containsKey(key)) {
            return Map.internalNewMapKey(key);
        }
        return internalMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    public T addObject(MapKey<String> key, T value) {
        if (key != null && value != null) {
            if (value instanceof MapKey) {
                throw new UtilsRuntimeException("Add object of type 'MapKey<>' in the map not allowed");
            }
            return super.put(key, value);
        }
        return null;
    }

    @Deprecated
    public T addObject(String key, T value) {
        if (key == null) {
            return null;
        }
        return this.addObject(Map.newMapKey(key), value);
    }

    @Override
    public T put(MapKey<String> key, T value) {
        return this.addObject(key, value);
    }

    @Override
    @Deprecated
    public T put(String key, T value) {
        return this.addObject(key, value);
    }

    @Override
    public void putAll(java.util.Map<? extends MapKey<String>, ? extends T> m) {
        if (m != null && !m.isEmpty()) {
            for (MapKey<String> mapKey : m.keySet()) {
                this.addObject(mapKey, m.get(mapKey));
            }
        }
    }

    @Deprecated
    public void putAllObjects(java.util.Map<String, ? extends T> m) {
        if (m != null && !m.isEmpty()) {
            for (String key : m.keySet()) {
                this.addObject(Map.newMapKey(key), m.get(key));
            }
        }
    }

    public void addAll(Map<T> map, boolean overwriteIfExists) {
        List<MapKey<String>> keys = map.keys();
        if (keys != null) {
            for (MapKey<String> key : keys) {
                if (this.containsKey(key)) {
                    if (!overwriteIfExists) continue;
                    this.removeObject(key);
                    this.addObject(key, map.getObject(key));
                    continue;
                }
                this.addObject(key, map.getObject(key));
            }
        }
    }

    public T getObject(MapKey<String> key) {
        if (key != null) {
            return (T)super.get(key);
        }
        return null;
    }

    public T get(MapKey<String> key) {
        return this.getObject(key);
    }

    @Override
    @Deprecated
    public T get(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof MapKey) {
            return this.getObject((MapKey)key);
        }
        if (key instanceof String) {
            return this.getObject(Map.newMapKey((String)key));
        }
        throw new UtilsRuntimeException("Object key '" + key.getClass().getName() + "' unsopported");
    }

    @Override
    @Deprecated
    public T getOrDefault(Object key, T defaultValue) {
        T o = this.get(key);
        if (o != null) {
            return o;
        }
        return defaultValue;
    }

    public T removeObject(MapKey<String> key) {
        if (key != null) {
            return (T)super.remove(key);
        }
        return null;
    }

    public T remove(MapKey<String> key) {
        return this.removeObject(key);
    }

    @Override
    @Deprecated
    public T remove(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof MapKey) {
            return this.removeObject((MapKey)key);
        }
        if (key instanceof String) {
            return this.removeObject(Map.newMapKey((String)key));
        }
        throw new UtilsRuntimeException("Object key '" + key.getClass().getName() + "' unsopported");
    }

    @Override
    @Deprecated
    public boolean remove(Object key, Object value) {
        T o = this.remove(key);
        return value.equals(o);
    }

    public List<MapKey<String>> keys() {
        ArrayList<MapKey> keys = null;
        if (!this.isEmpty()) {
            keys = new ArrayList<MapKey>();
            for (MapKey key : super.keySet()) {
                keys.add(key);
            }
        }
        return keys;
    }

    @Deprecated
    public List<String> keysAsString() {
        ArrayList<String> keys = null;
        if (!this.isEmpty()) {
            keys = new ArrayList<String>();
            for (MapKey key : super.keySet()) {
                keys.add((String)key.getValue());
            }
        }
        return keys;
    }

    public boolean containsKey(MapKey<String> key) {
        return super.containsKey(key);
    }

    @Override
    @Deprecated
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        if (key instanceof MapKey) {
            return this.containsKey((MapKey)key);
        }
        if (key instanceof String) {
            return this.containsKey(Map.newMapKey((String)key));
        }
        throw new UtilsRuntimeException("Object key '" + key.getClass().getName() + "' unsopported");
    }
}

