/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.batch;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.properties.PropertiesReader;

public class GeneratorProperties {
    private static GeneratorProperties staticInstance = null;
    private static final String PROPERTIES_FILE = "/batch-runtime-repository.properties";
    private String protocolloDefault;
    private int refreshConnessione;
    private int scadenzaMessaggiMinuti;
    private boolean messaggiLogQuery;
    private int messaggiFinestraSecondi;
    private String repositoryBuste;
    private boolean useDataRegistrazione;
    private PropertiesReader props;

    private static synchronized void init() throws UtilsException {
        if (staticInstance == null) {
            staticInstance = new GeneratorProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GeneratorProperties getInstance() throws UtilsException {
        if (staticInstance != null) return staticInstance;
        Class<GeneratorProperties> clazz = GeneratorProperties.class;
        synchronized (GeneratorProperties.class) {
            GeneratorProperties.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return staticInstance;
        }
    }

    private GeneratorProperties() throws UtilsException {
        Properties p = new Properties();
        try {
            InputStream is = GeneratorProperties.class.getResourceAsStream(PROPERTIES_FILE);
            p.load(is);
        }
        catch (Exception e) {
            throw new UtilsException("Errore durante l'init delle properties", (Throwable)e);
        }
        this.props = new PropertiesReader(p, true);
    }

    public void initProperties() throws UtilsException {
        this.protocolloDefault = this.getProperty("protocolloDefault", true);
        this.refreshConnessione = this.getIntProperty("connectionRefresh.secondi", true);
        this.scadenzaMessaggiMinuti = this.getIntProperty("repository.scadenzaMessaggio.minuti", false);
        this.messaggiLogQuery = this.getBooleanProperty("repository.logQuery", true);
        this.messaggiFinestraSecondi = this.getIntProperty("repository.finestra.secondi", true);
        this.repositoryBuste = this.getProperty("repository.gestoreBuste", true);
        this.useDataRegistrazione = this.getBooleanProperty("repository.gestoreBuste.dataRegistrazione", true);
    }

    private String getPropertyPrefix(String name) {
        return "Property '" + name + "' ";
    }

    private String getProperty(String name, boolean required) throws UtilsException {
        String tmp = this.props.getValue_convertEnvProperties(name);
        if (tmp == null) {
            if (required) {
                throw new UtilsException(this.getPropertyPrefix(name) + "not found");
            }
            return null;
        }
        return tmp.trim();
    }

    public String readProperty(boolean required, String property) throws UtilsException {
        return this.getProperty(property, required);
    }

    private boolean getBooleanProperty(String name, boolean required) throws UtilsException {
        String tmp = this.getProperty(name, required);
        if (tmp != null) {
            try {
                return Boolean.parseBoolean(tmp);
            }
            catch (Exception e) {
                throw new UtilsException(this.getPropertyPrefix(name) + "wrong int format: " + e.getMessage());
            }
        }
        return false;
    }

    private BooleanNullable readBooleanProperty(boolean required, String property) throws UtilsException {
        String tmp = this.getProperty(property, required);
        if (tmp == null && !required) {
            return BooleanNullable.NULL();
        }
        if (!"true".equalsIgnoreCase(tmp) && !"false".equalsIgnoreCase(tmp)) {
            throw new UtilsException("Property [" + property + "] with uncorrect value [" + tmp + "] (true/value expected)");
        }
        return Boolean.parseBoolean(tmp) ? BooleanNullable.TRUE() : BooleanNullable.FALSE();
    }

    private boolean parse(BooleanNullable b, boolean defaultValue) {
        return b != null && b.getValue() != null ? b.getValue() : defaultValue;
    }

    private int getIntProperty(String name, boolean required) throws UtilsException {
        String tmp = this.getProperty(name, required);
        if (tmp != null) {
            try {
                return Integer.valueOf(tmp);
            }
            catch (Exception e) {
                throw new UtilsException(this.getPropertyPrefix(name) + "wrong int format: " + e.getMessage());
            }
        }
        return -1;
    }

    public String getProtocolloDefault() {
        return this.protocolloDefault;
    }

    public int getRefreshConnessione() {
        return this.refreshConnessione;
    }

    public int getScadenzaMessaggiMinuti() {
        return this.scadenzaMessaggiMinuti;
    }

    public boolean isMessaggiDebug() throws UtilsException {
        return this.getBooleanProperty("repository.debug", true);
    }

    public boolean isMessaggiLogQuery() {
        return this.messaggiLogQuery;
    }

    public int getMessaggiFinestraSecondi() {
        return this.messaggiFinestraSecondi;
    }

    public String getRepositoryBuste() {
        return this.repositoryBuste;
    }

    public boolean isUseDataRegistrazione() {
        return this.useDataRegistrazione;
    }

    public boolean isSecurityLoadBouncyCastleProvider() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "security.addBouncyCastleProvider");
        return this.parse(b, false);
    }

    public String getEnvMapConfig() throws UtilsException {
        return this.readProperty(false, "env.map.config");
    }

    public boolean isEnvMapConfigRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "env.map.required");
        return this.parse(b, false);
    }

    public String getHSMConfigurazione() throws UtilsException {
        return this.readProperty(false, "hsm.config");
    }

    public boolean isHSMRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "hsm.required");
        return this.parse(b, false);
    }

    public boolean isHSMKeyPasswordConfigurable() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "hsm.keyPassword");
        return this.parse(b, false);
    }

    public String getBYOKConfigurazione() throws UtilsException {
        return this.readProperty(false, "byok.config");
    }

    public boolean isBYOKRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "byok.required");
        return this.parse(b, false);
    }

    public String getBYOKEnvSecretsConfig() throws UtilsException {
        return this.readProperty(false, "byok.env.secrets.config");
    }

    public boolean isBYOKEnvSecretsConfigRequired() throws UtilsException {
        BooleanNullable b = this.readBooleanProperty(false, "byok.env.secrets.required");
        return this.parse(b, false);
    }

    public String getConfigurazioneNodiRuntime() throws UtilsException {
        return this.readProperty(false, "configurazioni.configurazioneNodiRun");
    }
}

