/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.set;

import org.redisson.RedissonSetCache;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.operation.set.SetOperation;

public class RemoveCacheOperation
extends SetOperation {
    private Object value;

    public RemoveCacheOperation(RObject set, Object value, String transactionId, long threadId) {
        this(set.getName(), set.getCodec(), value, transactionId, threadId);
    }

    public RemoveCacheOperation(String name, Codec codec, Object value, String transactionId, long threadId) {
        super(name, codec, transactionId, threadId);
        this.value = value;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonSetCache set = new RedissonSetCache(this.codec, null, commandExecutor, this.name, null);
        set.removeAsync(this.value);
        this.getLock(set, commandExecutor, this.value).unlockAsync(this.threadId);
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RedissonSetCache set = new RedissonSetCache(this.codec, null, commandExecutor, this.name, null);
        this.getLock(set, commandExecutor, this.value).unlockAsync(this.threadId);
    }

    public Object getValue() {
        return this.value;
    }
}

