/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.cache;

import java.util.Map;
import org.redisson.MapCacheNativeWrapper;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RMapCacheNative;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.CacheManager;
import org.springframework.context.ResourceLoaderAware;

public class RedissonSpringCacheNativeManager
extends RedissonSpringCacheManager
implements CacheManager,
ResourceLoaderAware,
InitializingBean {
    public RedissonSpringCacheNativeManager(RedissonClient redisson) {
        this(redisson, (String)null, null);
    }

    public RedissonSpringCacheNativeManager(RedissonClient redisson, Map<String, ? extends CacheConfig> config) {
        this(redisson, config, null);
        this.validateProps();
    }

    public RedissonSpringCacheNativeManager(RedissonClient redisson, Map<String, ? extends CacheConfig> config, Codec codec) {
        super(redisson, config, codec);
        this.validateProps();
    }

    public RedissonSpringCacheNativeManager(RedissonClient redisson, String configLocation) {
        this(redisson, configLocation, null);
    }

    public RedissonSpringCacheNativeManager(RedissonClient redisson, String configLocation, Codec codec) {
        super(redisson, configLocation, codec);
    }

    private void validateProps() {
        for (CacheConfig value : this.configMap.values()) {
            if (value.getMaxIdleTime() > 0L) {
                throw new UnsupportedOperationException("maxIdleTime isn't supported");
            }
            if (value.getMaxSize() <= 0) continue;
            throw new UnsupportedOperationException("maxSize isn't supported");
        }
    }

    @Override
    public void setConfig(Map<String, ? extends CacheConfig> config) {
        super.setConfig(config);
        this.validateProps();
    }

    @Override
    protected RMap<Object, Object> getMap(String name, CacheConfig config) {
        if (this.codec != null) {
            return this.redisson.getMapCacheNative(name, this.codec);
        }
        return this.redisson.getMapCacheNative(name);
    }

    @Override
    protected RMapCache<Object, Object> getMapCache(String name, CacheConfig config) {
        RMapCacheNative map = (RMapCacheNative)this.getMap(name, config);
        return new MapCacheNativeWrapper<Object, Object>(map);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.configLocation != null) {
            this.validateProps();
        }
    }
}

