/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.cache;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import org.redisson.api.map.event.MapEntryListener;
import org.redisson.spring.cache.CacheConfig;

public class CacheConfigSupport {
    ObjectMapper jsonMapper = this.createMapper(null);
    ObjectMapper yamlMapper = this.createMapper((JsonFactory)new YAMLFactory());

    private ObjectMapper createMapper(JsonFactory mapping) {
        ObjectMapper mapper = new ObjectMapper(mapping);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.addMixIn(MapEntryListener.class, ClassMixIn.class);
        return mapper;
    }

    public Map<String, CacheConfig> fromJSON(String content) throws IOException {
        return (Map)this.jsonMapper.readValue(content, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public Map<String, CacheConfig> fromJSON(File file) throws IOException {
        return (Map)this.jsonMapper.readValue(file, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public Map<String, CacheConfig> fromJSON(URL url) throws IOException {
        return (Map)this.jsonMapper.readValue(url, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public Map<String, CacheConfig> fromJSON(Reader reader) throws IOException {
        return (Map)this.jsonMapper.readValue(reader, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public Map<String, CacheConfig> fromJSON(InputStream inputStream) throws IOException {
        return (Map)this.jsonMapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public String toJSON(Map<String, ? extends CacheConfig> configs) throws IOException {
        return this.jsonMapper.writeValueAsString(configs);
    }

    public Map<String, CacheConfig> fromYAML(String content) throws IOException {
        return (Map)this.yamlMapper.readValue(content, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public Map<String, CacheConfig> fromYAML(File file) throws IOException {
        return (Map)this.yamlMapper.readValue(file, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public Map<String, CacheConfig> fromYAML(URL url) throws IOException {
        return (Map)this.yamlMapper.readValue(url, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public Map<String, CacheConfig> fromYAML(Reader reader) throws IOException {
        return (Map)this.yamlMapper.readValue(reader, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public Map<String, CacheConfig> fromYAML(InputStream inputStream) throws IOException {
        return (Map)this.yamlMapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, CacheConfig>>(){});
    }

    public String toYAML(Map<String, ? extends CacheConfig> configs) throws IOException {
        return this.yamlMapper.writeValueAsString(configs);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="class")
    public static class ClassMixIn {
    }
}

