/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class SpinLock {
    private final AtomicReference<Thread> acquired = new AtomicReference();
    private final int spinLimit = 7000;
    private int nestedLevel;
    private final boolean reentrant;

    public SpinLock() {
        this(true);
    }

    public SpinLock(boolean reentrant) {
        this.reentrant = reentrant;
    }

    private void lockInterruptibly() throws InterruptedException {
        int spins = 0;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.reentrant && this.acquired.get() == Thread.currentThread()) {
                ++this.nestedLevel;
                return;
            }
            if (this.acquired.get() == null && this.acquired.compareAndSet(null, Thread.currentThread())) {
                this.nestedLevel = 1;
                return;
            }
            if (spins >= 7000) {
                Thread.yield();
                continue;
            }
            ++spins;
        }
    }

    private void unlock() {
        if (this.acquired.get() == Thread.currentThread()) {
            --this.nestedLevel;
            if (this.nestedLevel == 0) {
                this.acquired.set(null);
            }
        }
    }

    public void execute(Runnable r) {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            r.run();
        }
        finally {
            this.unlock();
        }
    }

    public <T> T execute(Supplier<T> r) {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            T t = r.get();
            return t;
        }
        finally {
            this.unlock();
        }
    }

    public void executeInterruptibly(Runnable r) throws InterruptedException {
        this.lockInterruptibly();
        try {
            r.run();
        }
        finally {
            this.unlock();
        }
    }
}

