/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.balancer.LoadBalancer;

public abstract class BaseLoadBalancer
implements LoadBalancer {
    private Pattern pattern;

    public void setRegex(String value) {
        this.pattern = Pattern.compile(value);
    }

    protected List<ClientConnectionsEntry> filter(List<ClientConnectionsEntry> entries) {
        return this.filter(entries, this.pattern);
    }

    protected final List<ClientConnectionsEntry> filter(List<ClientConnectionsEntry> entries, Pattern pattern) {
        if (pattern == null) {
            return entries;
        }
        return entries.stream().filter((? super T e) -> pattern.matcher(e.getClient().getAddr().getHostName() + ":" + e.getClient().getAddr().getPort()).matches()).collect(Collectors.toList());
    }
}

