/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cluster;

import java.util.Objects;

public class ClusterSlotRange {
    private final int startSlot;
    private final int endSlot;

    public ClusterSlotRange(int startSlot, int endSlot) {
        this.startSlot = startSlot;
        this.endSlot = endSlot;
    }

    public int getStartSlot() {
        return this.startSlot;
    }

    public int getEndSlot() {
        return this.endSlot;
    }

    public boolean hasSlot(int slot) {
        return slot >= this.startSlot && slot <= this.endSlot;
    }

    public int size() {
        return this.endSlot - this.startSlot + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterSlotRange that = (ClusterSlotRange)o;
        return this.startSlot == that.startSlot && this.endSlot == that.endSlot;
    }

    public int hashCode() {
        return Objects.hash(this.startSlot, this.endSlot);
    }

    public String toString() {
        return "[" + this.startSlot + "-" + this.endSlot + "]";
    }
}

