/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.misc.LogHelper;

public class CommandData<T, R>
implements QueueCommand {
    final CompletableFuture<R> promise;
    RedisCommand<T> command;
    final Object[] params;
    final Codec codec;
    final MultiDecoder<Object> messageDecoder;

    public CommandData(CompletableFuture<R> promise, Codec codec, RedisCommand<T> command, Object[] params) {
        this(promise, null, codec, command, params);
    }

    public CommandData(CompletableFuture<R> promise, MultiDecoder<Object> messageDecoder, Codec codec, RedisCommand<T> command, Object[] params) {
        this.promise = promise;
        this.command = command;
        this.params = params;
        this.codec = codec;
        this.messageDecoder = messageDecoder;
    }

    public RedisCommand<T> getCommand() {
        return this.command;
    }

    public Object[] getParams() {
        return this.params;
    }

    public MultiDecoder<Object> getMessageDecoder() {
        return this.messageDecoder;
    }

    public CompletableFuture<R> getPromise() {
        return this.promise;
    }

    public Throwable cause() {
        try {
            this.promise.getNow(null);
            return null;
        }
        catch (CompletionException e) {
            return e.getCause();
        }
        catch (CancellationException e) {
            return e;
        }
    }

    public boolean isSuccess() {
        return this.promise.isDone() && !this.promise.isCompletedExceptionally();
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        return this.promise.completeExceptionally(cause);
    }

    public Codec getCodec() {
        return this.codec;
    }

    public String toString() {
        return "CommandData [command=" + LogHelper.toString(this) + ", codec=" + this.codec + "]";
    }

    @Override
    public List<CommandData<Object, Object>> getPubSubOperations() {
        if (RedisCommands.PUBSUB_COMMANDS.contains(this.getCommand().getName())) {
            return Collections.singletonList(this);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isBlockingCommand() {
        return this.command.isBlockingCommand();
    }

    @Override
    public boolean isExecuted() {
        return this.promise.isDone();
    }
}

