/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.richfaces.model.AbstractTreeDataModel;
import org.richfaces.model.ConvertableKeyModel;
import org.richfaces.model.LastElementAware;
import org.richfaces.model.ListRowKey;
import org.richfaces.model.MapDataModel;
import org.richfaces.model.SequenceDataModel;
import org.richfaces.model.StackingTreeModelDataProvider;
import org.richfaces.model.StackingTreeModelKey;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeRange;
import org.w3c.dom.NamedNodeMap;

public class StackingTreeModel
extends AbstractTreeDataModel {
    private String id;
    private String var;
    private StackingTreeModelDataProvider dataProvider;
    private StackingTreeModel parent;
    private Map<String, StackingTreeModel> models = new LinkedHashMap<String, StackingTreeModel>();
    private Object rowKey;
    private LinkedList<StackEntry> stackEntries = new LinkedList();
    private static final Predicate ACTIVE_MODEL_PREDICATE = new Predicate(){

        public boolean evaluate(Object object) {
            StackingTreeModel model = (StackingTreeModel)((Object)object);
            if (model == null) {
                return false;
            }
            return model.isActive();
        }
    };

    public ExtendedDataModel getDataModel() {
        Object data = this.dataProvider.getData();
        ExtendedDataModel dataModel = data instanceof Map || data instanceof NamedNodeMap ? new MapDataModel() : new SequenceDataModel();
        dataModel.setWrappedData(data);
        return dataModel;
    }

    protected StackingTreeModel getCurrentModel() {
        if (this.rowKey == null) {
            return this;
        }
        if (this.isRowAvailable()) {
            return this.stackEntries.getLast().model;
        }
        throw new IllegalStateException("No tree element available or row key not set!");
    }

    public boolean isEmpty() {
        return this.getDataModel().getRowCount() == 0;
    }

    private void leaveModel(Iterator<StackEntry> iterator, StackEntry currentEntry, FacesContext context) {
        if (iterator == null) {
            return;
        }
        LinkedList<StackEntry> stack = new LinkedList<StackEntry>();
        StackingTreeModel lastModel = null;
        if (currentEntry != null) {
            iterator.remove();
            stack.addFirst(currentEntry);
            lastModel = currentEntry.model;
        }
        while (iterator.hasNext()) {
            StackEntry entry = iterator.next();
            if (entry.model != lastModel) {
                lastModel = entry.model;
                stack.addFirst(entry);
            }
            iterator.remove();
        }
        for (StackEntry stackEntry : stack) {
            stackEntry.model.setupVariable(stackEntry.varObject, context);
        }
    }

    protected StackingTreeModel doSetupKey(Iterator<StackingTreeModelKey> keyIterator, Iterator<StackEntry> entriesIterator, FacesContext context, Object modelKey) {
        if (modelKey != null && !this.setupModel(modelKey, context)) {
            this.leaveModel(this.getRoot().stackEntries.iterator(), null, context);
            return null;
        }
        if (keyIterator != null && keyIterator.hasNext()) {
            StackingTreeModelKey key = keyIterator.next();
            StackingTreeModel stackingTreeModel = this.getInternalModelById(key.modelId);
            Iterator<StackEntry> nextEntriesIterator = null;
            Object nextModelKey = key.modelKey;
            if (entriesIterator != null && entriesIterator.hasNext()) {
                StackEntry entry = entriesIterator.next();
                if (!((Object)((Object)entry.model)).equals((Object)stackingTreeModel) || !entry.modelKey.equals(nextModelKey)) {
                    this.leaveModel(entriesIterator, entry, context);
                } else {
                    nextEntriesIterator = entriesIterator;
                    nextModelKey = null;
                }
            }
            return stackingTreeModel.doSetupKey(keyIterator, nextEntriesIterator, context, nextModelKey);
        }
        this.leaveModel(entriesIterator, null, context);
        return this;
    }

    protected StackingTreeModel setupKey(Object key, FacesContext context) {
        if (key == this.rowKey) {
            if (this.stackEntries.isEmpty()) {
                return this;
            }
            return this.stackEntries.getLast().model;
        }
        Iterator<StackingTreeModelKey> keyIterator = null;
        if (key != null) {
            keyIterator = ((ListRowKey)key).iterator();
        }
        StackingTreeModel model = this.doSetupKey(keyIterator, this.stackEntries.iterator(), context, null);
        this.rowKey = key;
        return model;
    }

    public StackingTreeModel(String id, String var, StackingTreeModelDataProvider dataProvider) {
        this.id = id;
        this.var = var;
        this.dataProvider = dataProvider;
    }

    public StackingTreeModel() {
        this(null, null, null);
    }

    private Object setupVariable(Object variable, FacesContext context) {
        if (this.var != null) {
            Map map = context.getExternalContext().getRequestMap();
            return map.put(this.var, variable);
        }
        return null;
    }

    public boolean setupModel(Object key, FacesContext facesContext) {
        ExtendedDataModel dataModel = this.getDataModel();
        dataModel.setRowKey(key);
        if (dataModel.isRowAvailable()) {
            Object rowData = dataModel.getRowData();
            Object varObject = this.setupVariable(rowData, facesContext);
            this.getRoot().stackEntries.add(new StackEntry(varObject, key, rowData, this));
            return true;
        }
        return false;
    }

    public void setParent(StackingTreeModel parent) {
        this.parent = parent;
    }

    @Override
    public TreeNode getTreeNode() {
        if (this.isRowAvailable()) {
            return null;
        }
        throw new IllegalStateException("No tree element available or row key not set!");
    }

    @Override
    public boolean isLeaf() {
        if (this.isRowAvailable()) {
            StackEntry lastEntry = this.stackEntries.getLast();
            Iterator<StackingTreeModel> iterator = lastEntry.model.getInternalModelsIterator();
            while (iterator.hasNext()) {
                StackingTreeModel stackingTreeModel = iterator.next();
                if (stackingTreeModel.isEmpty()) continue;
                return false;
            }
            return true;
        }
        throw new IllegalStateException("No tree element available or row key not set!");
    }

    protected StackingTreeModel getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    protected void doWalk(FacesContext context, DataVisitor dataVisitor, Range range, ListRowKey argumentKey, Object argument, boolean last) throws IOException {
        TreeRange treeRange = (TreeRange)range;
        if (treeRange == null || treeRange.processNode(argumentKey)) {
            StackingTreeModel rootModel = this.getRoot();
            if (argumentKey != null) {
                this.processElement(context, dataVisitor, argument, argumentKey, last);
            }
            final ShiftingDataVisitor shiftingDataVisitor = new ShiftingDataVisitor(new Visitor1(dataVisitor));
            if (treeRange == null || treeRange.processChildren(argumentKey)) {
                Object savedRowKey = rootModel.getRowKey();
                rootModel.setRowKey(context, argumentKey);
                Iterator<StackingTreeModel> iterator = this.getInternalModelsIterator();
                rootModel.setRowKey(context, savedRowKey);
                while (iterator.hasNext()) {
                    final StackingTreeModel model = iterator.next();
                    savedRowKey = rootModel.getRowKey();
                    rootModel.setRowKey(context, argumentKey);
                    final ExtendedDataModel scalarModel = model.getDataModel();
                    rootModel.setRowKey(context, savedRowKey);
                    Argument argument2 = new Argument();
                    argument2.listRowKey = argumentKey;
                    argument2.argument = argument;
                    argument2.model = model;
                    argument2.range = range;
                    scalarModel.walk(context, new DataVisitor(){

                        @Override
                        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
                            Object key = scalarModel.getRowKey();
                            scalarModel.setRowKey(rowKey);
                            Object data = scalarModel.getRowData();
                            Object variable = model.setupVariable(data, context);
                            boolean activeData = model.isActiveData();
                            model.setupVariable(variable, context);
                            scalarModel.setRowKey(key);
                            if (activeData) {
                                shiftingDataVisitor.process(context, rowKey, argument);
                            }
                        }
                    }, null, argument2);
                }
            }
            shiftingDataVisitor.end(context);
        }
    }

    private StackingTreeModel getInternalModelById(String id) {
        StackingTreeModel model = this.getModelById(id);
        if (model.isActive()) {
            return model;
        }
        throw new IllegalStateException();
    }

    public StackingTreeModel getModelById(String id) {
        return this.models.get(id);
    }

    private Iterator<StackingTreeModel> getInternalModelsIterator() {
        return new FilterIterator(this.getModelsIterator(), ACTIVE_MODEL_PREDICATE);
    }

    public Iterator<StackingTreeModel> getModelsIterator() {
        return this.models.values().iterator();
    }

    @Override
    public void walk(FacesContext context, DataVisitor dataVisitor, Range range, Object rowKey, Object argument, boolean last) throws IOException {
        StackingTreeModel rootModel = this.getRoot();
        if (rowKey != null) {
            ListRowKey listRowKey = (ListRowKey)rowKey;
            StackingTreeModel treeModel = rootModel.setupKey(listRowKey, context);
            treeModel.doWalk(context, dataVisitor, range, listRowKey, argument, last);
        } else {
            this.doWalk(context, dataVisitor, range, (ListRowKey)rowKey, argument, last);
        }
    }

    @Override
    public void walkModel(FacesContext facesContext, DataVisitor visitor, Range range, Object key, Object argument, boolean last) throws IOException {
        this.walk(facesContext, visitor, range, key, argument, last);
    }

    @Override
    public Object getRowKey() {
        return this.rowKey;
    }

    @Override
    public void setRowKey(Object key) {
        this.setRowKey(FacesContext.getCurrentInstance(), key);
    }

    public void setRowKey(FacesContext context, Object key) {
        this.setupKey(key, context);
    }

    public void addStackingModel(StackingTreeModel model) {
        this.models.put(model.id, model);
        model.setParent(this);
    }

    public void removeStackingModel(StackingTreeModel model) {
        this.models.remove(model.id);
        model.setParent(null);
    }

    public Object getRowData() {
        if (this.isRowAvailable()) {
            StackEntry lastEntry = this.stackEntries.getLast();
            return lastEntry.rowData;
        }
        throw new IllegalStateException("No tree element available or row key not set!");
    }

    public boolean isRowAvailable() {
        return !this.stackEntries.isEmpty();
    }

    public StackingTreeModel getParent() {
        return this.parent;
    }

    protected boolean isActiveData() {
        return true;
    }

    protected boolean isActive() {
        return true;
    }

    public Object getWrappedData() {
        throw new UnsupportedOperationException();
    }

    public void setWrappedData(Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object convertToKey(FacesContext context, String keyString, UIComponent component, Converter converter) {
        this.setRowKey(context, null);
        String[] strings = ListRowKey.fromString(keyString);
        int l = strings.length / 2;
        ArrayList<StackingTreeModelKey<Object>> list = new ArrayList<StackingTreeModelKey<Object>>(l);
        StackingTreeModel model = this.getRoot();
        for (int i = 0; i < l; ++i) {
            int idx = i * 2;
            String modelId = strings[idx];
            if ((model = model.getModelById(modelId)).isActive()) {
                Object key = model.convert(context, strings[idx + 1], component, converter);
                if (key == null) {
                    return null;
                }
                list.add(new StackingTreeModelKey<Object>(modelId, key));
                if (model.setupModel(key, context) && model.isActiveData()) continue;
                return null;
            }
            return null;
        }
        return new ListRowKey(list);
    }

    protected Object convert(FacesContext context, String string, UIComponent component, Converter converter) {
        ConvertableKeyModel convertable = (ConvertableKeyModel)((Object)this.getDataModel());
        return convertable.getKeyAsObject(context, string, component, converter);
    }

    public String getId() {
        return this.id;
    }

    private class StackEntry {
        private Object modelKey;
        private Object varObject;
        private StackingTreeModel model;
        private Object rowData;

        public StackEntry(Object varObject, Object modelKey, Object rowData, StackingTreeModel model) {
            this.varObject = varObject;
            this.modelKey = modelKey;
            this.rowData = rowData;
            this.model = model;
        }
    }

    private static class ShiftingDataVisitor
    implements DataVisitor {
        private DataVisitor dataVisitor;
        private Object rowKey;
        private Object argument;
        private boolean shifted = false;

        public ShiftingDataVisitor(DataVisitor dataVisitor) {
            this.dataVisitor = dataVisitor;
        }

        @Override
        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            if (!this.shifted) {
                this.rowKey = rowKey;
                this.argument = argument;
                this.shifted = true;
            } else {
                this.dataVisitor.process(context, this.rowKey, this.argument);
                this.rowKey = rowKey;
                this.argument = argument;
            }
        }

        public void end(FacesContext context) throws IOException {
            if (this.shifted) {
                try {
                    ((LastElementAware)((Object)this.dataVisitor)).setLastElement();
                    this.dataVisitor.process(context, this.rowKey, this.argument);
                }
                finally {
                    ((LastElementAware)((Object)this.dataVisitor)).resetLastElement();
                }
            }
        }
    }

    private class Visitor1
    implements DataVisitor,
    LastElementAware {
        private DataVisitor dataVisitor;
        private boolean theLast;

        public Visitor1(DataVisitor dataVisitor) {
            this.dataVisitor = dataVisitor;
        }

        @Override
        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            Argument a = (Argument)argument;
            ListRowKey<StackingTreeModelKey<Object>> listRowKey = new ListRowKey<StackingTreeModelKey<Object>>(a.listRowKey, new StackingTreeModelKey<Object>(a.model.id, rowKey));
            a.model.doWalk(context, this.dataVisitor, a.range, listRowKey, a.argument, this.theLast);
        }

        @Override
        public void resetLastElement() {
            this.theLast = false;
        }

        @Override
        public void setLastElement() {
            this.theLast = true;
        }
    }

    private class Argument {
        private ListRowKey listRowKey;
        private StackingTreeModel model;
        private Range range;
        private Object argument;

        private Argument() {
        }
    }
}

