/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.richfaces.model.ListRowKey;
import org.richfaces.model.TreeDataModel;
import org.richfaces.model.TreeDataModelNodeAdaptor;
import org.richfaces.model.TreeNode;
import org.richfaces.model.TreeRowKey;

public class ClassicTreeDataModel
extends TreeDataModel<TreeNode> {
    public ClassicTreeDataModel() {
        super(TreeNode.class, TreeDataModelNodeAdaptor.classicTreeNodeAdaptor, null);
    }

    @Override
    public TreeNode getTreeNode() {
        if (this.isRowAvailable()) {
            return (TreeNode)this.locateTreeNode((TreeRowKey)this.getRowKey());
        }
        throw new IllegalStateException("No tree element available or row key not set!");
    }

    @Override
    public Object convertToKey(FacesContext context, String keyString, UIComponent component, Converter converter) {
        String[] strings = ListRowKey.fromString(keyString);
        ArrayList<Object> list = new ArrayList<Object>(strings.length);
        TreeNode node = (TreeNode)this.getWrappedData();
        for (int i = 0; i < strings.length; ++i) {
            String key = strings[i];
            TreeNode child = node.getChild(key);
            if (child != null) {
                node = child;
                list.add(key);
                continue;
            }
            boolean found = false;
            Iterator children = node.getChildren();
            while (children.hasNext() && !found) {
                Map.Entry entry = children.next();
                Object keyObject = entry.getKey();
                if (!key.equals(keyObject.toString())) continue;
                node = entry.getValue();
                list.add(keyObject);
                found = true;
            }
            if (found) continue;
            return null;
        }
        return new ListRowKey(list);
    }
}

