/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.event;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import org.richfaces.event.AttributeHolder;

public abstract class AttributedEvent
extends FacesEvent
implements AttributeHolder {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public AttributedEvent(UIComponent component) {
        super(component);
    }

    public AttributedEvent(UIComponent component, Map<String, Object> attributes) {
        super(component);
        this.attributes.putAll(attributes);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void applyAttributes(UIComponent component) {
        Map attrs = component.getAttributes();
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                attrs.remove(key);
                continue;
            }
            attrs.put(key, value);
        }
    }

    public void applyAttributes() {
        this.applyAttributes(this.getComponent());
    }
}

