/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import jakarta.servlet.ServletContext;
import java.io.Serializable;
import java.util.Properties;
import javax.faces.FacesException;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheConfigurationLoader;
import org.ajax4jsf.cache.CacheException;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.CacheLoader;
import org.ajax4jsf.cache.CacheManager;
import org.ajax4jsf.cache.ServletContextInitMap;
import org.ajax4jsf.webapp.PushEventsCounter;

public class PollEventsManager
implements Serializable,
CacheLoader,
CacheConfigurationLoader {
    private static final long serialVersionUID = -6257285396790747665L;
    public static final String EVENTS_MANAGER_KEY = PollEventsManager.class.getName();
    private Cache cache;

    public void init(ServletContext servletContext) {
        try {
            CacheManager cacheManager = CacheManager.getInstance();
            ServletContextInitMap env = new ServletContextInitMap(servletContext);
            CacheFactory cacheFactory = cacheManager.getCacheFactory(env);
            this.cache = cacheFactory.createCache(env, this, this);
            servletContext.setAttribute(EVENTS_MANAGER_KEY, (Object)this);
        }
        catch (CacheException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public PushEventsCounter getListener(String key) {
        if (null == this.cache) {
            throw new FacesException("Poll events manager not initialized");
        }
        try {
            return (PushEventsCounter)this.cache.get(key, null);
        }
        catch (CacheException e) {
            throw new FacesException("error get push events listener for key " + key, (Throwable)e);
        }
    }

    @Override
    public Object load(Object key, Object context) throws CacheException {
        return new PushEventsCounter();
    }

    @Override
    public Properties loadProperties(String name) {
        return new Properties();
    }
}

