/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.OutputStream;
import org.ajax4jsf.Messages;

public class GifEncoder {
    private boolean interlace = false;
    private int width;
    private int height;
    private byte[] pixels;
    private byte[] r;
    private byte[] g;
    private byte[] b;
    private int pixelIndex;
    private int numPixels;
    private int transparentPixel = -1;
    int Width;
    int Height;
    boolean Interlace;
    static final int EOF = -1;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    public GifEncoder(int width, int height, byte[] pixels, byte[] r, byte[] g, byte[] b) {
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.r = r;
        this.g = g;
        this.b = b;
        this.interlace = false;
        this.pixelIndex = 0;
        this.numPixels = width * height;
    }

    public GifEncoder(Image img) {
        this.width = img.getWidth(null);
        this.height = img.getHeight(null);
        this.pixels = new byte[this.width * this.height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, this.width, this.height, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println(e);
        }
        ColorModel cm = pg.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            throw new IllegalArgumentException(Messages.getMessage("IMAGE_ERROR"));
        }
        this.pixels = (byte[])pg.getPixels();
        IndexColorModel icm = (IndexColorModel)cm;
        this.setTransparentPixel(icm.getTransparentPixel());
        IndexColorModel m = (IndexColorModel)cm;
        int mapSize = m.getMapSize();
        this.r = new byte[mapSize];
        this.g = new byte[mapSize];
        this.b = new byte[mapSize];
        m.getReds(this.r);
        m.getGreens(this.g);
        m.getBlues(this.b);
        this.interlace = false;
        this.pixelIndex = 0;
        this.numPixels = this.width * this.height;
    }

    public void write(OutputStream out) throws IOException {
        int numColors = this.r.length;
        int BitsPerPixel = numColors <= 2 ? 1 : (numColors <= 4 ? 2 : (numColors <= 16 ? 4 : 8));
        int ColorMapSize = 1 << BitsPerPixel;
        byte[] reds = new byte[ColorMapSize];
        byte[] grns = new byte[ColorMapSize];
        byte[] blus = new byte[ColorMapSize];
        for (int i = 0; i < numColors; ++i) {
            reds[i] = this.r[i];
            grns[i] = this.g[i];
            blus[i] = this.b[i];
        }
        this.GIFEncode(out, this.width, this.height, this.interlace, (byte)0, this.getTransparentPixel(), BitsPerPixel, reds, grns, blus);
    }

    public void setTransparentPixel(int pixel) {
        this.transparentPixel = pixel;
    }

    public int getTransparentPixel() {
        return this.transparentPixel;
    }

    static void writeString(OutputStream out, String str) throws IOException {
        byte[] buf = str.getBytes();
        out.write(buf);
    }

    void GIFEncode(OutputStream outs, int Width, int Height, boolean Interlace, byte Background, int Transparent, int BitsPerPixel, byte[] Red, byte[] Green, byte[] Blue) throws IOException {
        this.Width = Width;
        this.Height = Height;
        this.Interlace = Interlace;
        int ColorMapSize = 1 << BitsPerPixel;
        int TopOfs = 0;
        int LeftOfs = 0;
        int InitCodeSize = BitsPerPixel <= 1 ? 2 : BitsPerPixel;
        GifEncoder.writeString(outs, "GIF89a");
        this.Putword(Width, outs);
        this.Putword(Height, outs);
        byte B = -128;
        B = (byte)(B | 0x70);
        B = (byte)(B | (byte)(BitsPerPixel - 1));
        this.Putbyte(B, outs);
        this.Putbyte(Background, outs);
        this.Putbyte((byte)0, outs);
        for (int i = 0; i < ColorMapSize; ++i) {
            this.Putbyte(Red[i], outs);
            this.Putbyte(Green[i], outs);
            this.Putbyte(Blue[i], outs);
        }
        if (Transparent != -1) {
            this.Putbyte((byte)33, outs);
            this.Putbyte((byte)-7, outs);
            this.Putbyte((byte)4, outs);
            this.Putbyte((byte)1, outs);
            this.Putbyte((byte)0, outs);
            this.Putbyte((byte)0, outs);
            this.Putbyte((byte)Transparent, outs);
            this.Putbyte((byte)0, outs);
        }
        this.Putbyte((byte)44, outs);
        this.Putword(LeftOfs, outs);
        this.Putword(TopOfs, outs);
        this.Putword(Width, outs);
        this.Putword(Height, outs);
        if (Interlace) {
            this.Putbyte((byte)64, outs);
        } else {
            this.Putbyte((byte)0, outs);
        }
        this.Putbyte((byte)InitCodeSize, outs);
        this.compress(InitCodeSize + 1, outs);
        this.Putbyte((byte)0, outs);
        this.Putbyte((byte)59, outs);
    }

    int GIFNextPixel() throws IOException {
        if (this.pixelIndex == this.numPixels) {
            return -1;
        }
        return this.pixels[this.pixelIndex++] & 0xFF;
    }

    void Putword(int w, OutputStream outs) throws IOException {
        this.Putbyte((byte)(w & 0xFF), outs);
        this.Putbyte((byte)(w >> 8 & 0xFF), outs);
    }

    void Putbyte(byte b, OutputStream outs) throws IOException {
        outs.write(b);
    }

    final int MAXCODE(int n_bits) {
        return (1 << n_bits) - 1;
    }

    void compress(int init_bits, OutputStream outs) throws IOException {
        int c;
        int fcode;
        this.g_init_bits = init_bits;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << init_bits - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.char_init();
        int ent = this.GIFNextPixel();
        int hshift = 0;
        for (fcode = this.hsize; fcode < 65536; fcode *= 2) {
            ++hshift;
        }
        hshift = 8 - hshift;
        int hsize_reg = this.hsize;
        this.cl_hash(hsize_reg);
        this.output(this.ClearCode, outs);
        block1: while ((c = this.GIFNextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsize_reg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsize_reg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent, outs);
            ent = c;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[i] = fcode;
                continue;
            }
            this.cl_block(outs);
        }
        this.output(ent, outs);
        this.output(this.EOFCode, outs);
    }

    void output(int code, OutputStream outs) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= code << this.cur_bits) : code;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outs);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (code == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outs);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outs);
        }
    }

    void cl_block(OutputStream outs) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outs);
    }

    void cl_hash(int hsize) {
        for (int i = 0; i < hsize; ++i) {
            this.htab[i] = -1;
        }
    }

    void char_init() {
        this.a_count = 0;
    }

    void char_out(byte c, OutputStream outs) throws IOException {
        this.accum[this.a_count++] = c;
        if (this.a_count >= 254) {
            this.flush_char(outs);
        }
    }

    void flush_char(OutputStream outs) throws IOException {
        if (this.a_count > 0) {
            outs.write(this.a_count);
            outs.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }
}

