/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource.cached;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.ResourceBuilderImpl;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.cached.DualLRUMap;
import org.ajax4jsf.resource.cached.ResourceBean;
import org.ajax4jsf.resource.cached.ResourceBytesDataBean;
import org.ajax4jsf.resource.cached.ResourceDataBean;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachedResourceBuilder
extends ResourceBuilderImpl {
    private static final Log log = LogFactory.getLog(CachedResourceBuilder.class);
    protected static final int DEFAULT_CAPACITY = 10000;
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private DualLRUMap cache;

    @Override
    protected byte[] decrypt(byte[] data) {
        return data;
    }

    @Override
    protected byte[] encrypt(byte[] data) {
        return data;
    }

    @Override
    public Object getResourceDataForKey(String key) {
        ResourceBean bean = null;
        try {
            this.readWriteLock.readLock().lock();
            bean = (ResourceBean)this.cache.get(key);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        if (null == bean) {
            throw new ResourceNotFoundException("Resource for key " + key + "not present in cache");
        }
        return bean.getData();
    }

    @Override
    public InternetResource getResourceForKey(String key) throws ResourceNotFoundException {
        ResourceBean bean = null;
        try {
            this.readWriteLock.readLock().lock();
            bean = (ResourceBean)this.cache.get(key);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        if (null == bean) {
            throw new ResourceNotFoundException("Resource for key " + key + "not present in cache");
        }
        return super.getResourceForKey(bean.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUri(InternetResource resource, FacesContext facesContext, Object data) {
        ResourceBean bean = null == data ? new ResourceBean(resource.getKey()) : (data instanceof byte[] ? new ResourceBytesDataBean(resource.getKey(), (byte[])data) : new ResourceDataBean(resource.getKey(), data));
        String key = null;
        try {
            this.readWriteLock.readLock().lock();
            key = (String)this.cache.getKey(bean);
            if (key != null) {
                this.cache.get(key);
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        if (key == null) {
            try {
                this.readWriteLock.writeLock().lock();
                key = (String)this.cache.getKey(bean);
                if (null == key) {
                    key = this.createNextKey();
                    while (this.cache.containsKey(key)) {
                        key = this.createNextKey();
                    }
                    this.cache.put(key, bean);
                } else {
                    this.cache.get(key);
                }
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        boolean isGlobal = !resource.isSessionAware();
        String resourceURL = this.getFacesResourceURL(facesContext, key, isGlobal);
        if (!isGlobal) {
            resourceURL = facesContext.getExternalContext().encodeResourceURL(resourceURL);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("BUILD_RESOURCE_URI_INFO", resource.getKey(), resourceURL));
        }
        return resourceURL;
    }

    @Override
    public void init() throws FacesException {
        super.init();
        Properties properties = this.getProperties("cache.properties");
        int capacity = this.getCapacity(properties);
        if (capacity <= 0) {
            capacity = 10000;
            log.info((Object)"Using default capacity: 10000");
        }
        this.cache = new DualLRUMap(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(String name) {
        Properties properties = new Properties();
        InputStream props = URLToStreamHelper.urlToStreamSafe(CachedResourceBuilder.class.getResource(name));
        if (null != props) {
            try {
                properties.load(props);
            }
            catch (IOException e) {
                log.warn((Object)Messages.getMessage("READING_PROPERTIES_ERROR", name), (Throwable)e);
            }
            finally {
                try {
                    props.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    protected String createNextKey() {
        return UUID.randomUUID().toString();
    }

    protected int getCapacity(Properties properties) {
        int capacity = 0;
        String capacityString = properties.getProperty("cache.capacity");
        if (null != capacityString) {
            try {
                capacity = Integer.parseInt(capacityString);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"Error parsing value of parameters cache capacity", (Throwable)e);
            }
        }
        return capacity;
    }
}

