/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.io.IOException;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.compiler.ElementBase;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.xml.sax.Attributes;

public class PlainElement
extends ElementBase {
    private String namespace = "";
    private String tag = null;
    private String[][] attrs = null;
    private boolean encodeStart = true;
    private boolean encodeEnd = true;

    public PlainElement(String namespace, String tag, Attributes attrs) {
        this.attrs = new String[attrs.getLength()][2];
        this.namespace = namespace;
        this.tag = tag;
        int currentAttribute = 0;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qName = attrs.getQName(i);
            String value = attrs.getValue(i);
            if (qName.equals("f:start")) {
                this.encodeStart = "true".equals(value);
                continue;
            }
            if (qName.equals("f:end")) {
                this.encodeEnd = "true".equals(value);
                continue;
            }
            this.attrs[currentAttribute][0] = qName;
            this.attrs[currentAttribute++][1] = value;
        }
        if (currentAttribute < attrs.getLength()) {
            String[][] newattrs = new String[currentAttribute][2];
            System.arraycopy(this.attrs, 0, newattrs, 0, currentAttribute);
            this.attrs = newattrs;
        }
    }

    @Override
    public void encodeBegin(TemplateContext context) throws IOException {
        ResponseWriter writer = context.getWriter();
        if (this.encodeStart) {
            writer.startElement(this.getTag(), context.getComponent());
            for (int i = 0; i < this.attrs.length; ++i) {
                writer.writeAttribute(this.attrs[i][0], (Object)this.attrs[i][1], null);
            }
        }
    }

    @Override
    public void encodeEnd(TemplateContext context) throws IOException {
        ResponseWriter writer = context.getWriter();
        if (this.encodeEnd) {
            writer.endElement(this.getTag());
        }
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String[][] getAttrs() {
        return this.attrs;
    }

    public boolean isEncodeEnd() {
        return this.encodeEnd;
    }

    public void setEncodeEnd(boolean encodeEnd) {
        this.encodeEnd = encodeEnd;
    }

    public boolean isEncodeStart() {
        return this.encodeStart;
    }

    public void setEncodeStart(boolean encodeStart) {
        this.encodeStart = encodeStart;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

