/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.mbean;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiPdnd;
import org.openspcoop2.core.statistiche.constants.PossibiliStatiRichieste;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.bean.SelectItem;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.DynamicPdDBean;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.statistiche.bean.GruppoRicercaStatistichePdnd;
import org.openspcoop2.web.monitor.statistiche.bean.RicercaStatistichePdnd;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingSearchForm;
import org.openspcoop2.web.monitor.statistiche.constants.ModalitaRicercaStatistichePdnd;
import org.openspcoop2.web.monitor.statistiche.dao.StatistichePdndTracingService;
import org.openspcoop2.web.monitor.statistiche.servlet.StatistichePdndTracingExporter;
import org.slf4j.Logger;

public class StatistichePdndTracingBean
extends DynamicPdDBean<org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean, Long, IService<org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean, Long>> {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private List<javax.faces.model.SelectItem> stati = null;
    private List<javax.faces.model.SelectItem> statiPdnd = null;
    private Integer minTentativiPubblicazione = 0;
    private org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean statisticaPdndTracing;
    private String selectedTab = null;
    private List<GruppoRicercaStatistichePdnd> tipiRicerca;
    private String tipoRicerca;
    private boolean updateTipoRicerca = false;

    public boolean isShowFiltroSoggetti() {
        return this.search.isShowFiltroSoggettoLocale();
    }

    public List<javax.faces.model.SelectItem> getSoggetti() throws Exception {
        if (this.search == null) {
            return new ArrayList<javax.faces.model.SelectItem>();
        }
        return this._getSoggetti(true, false, null);
    }

    public List<SelectItem> soggettiErogatoreAutoComplete(Object val) throws Exception {
        ArrayList<SelectItem> listaSoggetti = new ArrayList<SelectItem>();
        List<Object> listaSoggettiTmp = new ArrayList<javax.faces.model.SelectItem>();
        if (val != null && !StringUtils.isEmpty((CharSequence)((String)val)) && this.search != null) {
            listaSoggettiTmp = this._getSoggetti(true, false, (String)val);
        }
        listaSoggettiTmp.add(0, new javax.faces.model.SelectItem((Object)"--", "--"));
        for (javax.faces.model.SelectItem selectItem : listaSoggettiTmp) {
            String label = selectItem.getLabel();
            String value = (String)selectItem.getValue();
            SelectItem newItem = new SelectItem(value, label);
            listaSoggetti.add(newItem);
        }
        return listaSoggetti;
    }

    public List<javax.faces.model.SelectItem> getTipiNomiSoggettiAssociati() throws Exception {
        return this._getTipiNomiSoggettiAssociati(true);
    }

    private List<String> getIdSelected() {
        ArrayList<String> idReport = new ArrayList<String>();
        if (!this.isSelectedAll()) {
            Iterator it = this.selectedIds.keySet().iterator();
            while (it.hasNext()) {
                org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean bean = (org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean)((Object)it.next());
                if (!((Boolean)this.selectedIds.get((Object)bean)).booleanValue()) continue;
                idReport.add(bean.getId().toString());
                it.remove();
            }
        }
        return idReport;
    }

    public String exportSelected() {
        try {
            List<String> idReport = this.getIdSelected();
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            HttpSession sessione = (HttpSession)context.getExternalContext().getSession(false);
            sessione.setAttribute("idsOriginali", (Object)StringUtils.join(idReport, (String)","));
            sessione.setAttribute("isAllOriginale", (Object)this.isSelectedAll());
            response.sendRedirect(context.getExternalContext().getRequestContextPath() + "/tracingpdndexporter?isAll=" + this.isSelectedAll() + "&ids=" + StringUtils.join(idReport, (String)","));
            context.responseComplete();
        }
        catch (Exception e) {
            FacesContext.getCurrentInstance().responseComplete();
            log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'esportazione dei Tracing PDND selezionati.");
        }
        return null;
    }

    public String downloadCsv() {
        log.debug("downloading csv: {}", (Object)this.statisticaPdndTracing.getId());
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        String contentType = "text/csv";
        response.setContentType(contentType);
        String fileName = StatistichePdndTracingExporter.getCsvFileName(this.statisticaPdndTracing);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.statisticaPdndTracing.getCsv());){
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName, (String)contentType);
            ServletOutputStream os = null;
            os = response.getOutputStream();
            CopyStream.copy((InputStream)bais, (OutputStream)os);
            os.flush();
            os.close();
            FacesContext.getCurrentInstance().responseComplete();
        }
        catch (IOException | UtilsException e) {
            log.error(e.getMessage(), e);
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il download del csv.");
        }
        return null;
    }

    public List<javax.faces.model.SelectItem> getStati() {
        if (this.stati != null) {
            return this.stati;
        }
        this.stati = new ArrayList<javax.faces.model.SelectItem>();
        this.stati.add(new javax.faces.model.SelectItem((Object)"--"));
        this.stati.add(new javax.faces.model.SelectItem((Object)PossibiliStatiRichieste.PUBLISHED.getValue(), MessageManager.getInstance().getMessage("statistichePdndTracing.stato.PUBLISHED.label")));
        this.stati.add(new javax.faces.model.SelectItem((Object)PossibiliStatiRichieste.FAILED.getValue(), MessageManager.getInstance().getMessage("statistichePdndTracing.stato.FAILED.label")));
        this.stati.add(new javax.faces.model.SelectItem((Object)"IN_ATTESA", MessageManager.getInstance().getMessage("statistichePdndTracing.stato.IN_ATTESA.label")));
        return this.stati;
    }

    public List<javax.faces.model.SelectItem> getStatiPdnd() {
        if (this.statiPdnd != null) {
            return this.statiPdnd;
        }
        this.statiPdnd = new ArrayList<javax.faces.model.SelectItem>();
        this.statiPdnd.add(new javax.faces.model.SelectItem((Object)"--"));
        this.statiPdnd.add(new javax.faces.model.SelectItem((Object)PossibiliStatiPdnd.OK.getValue(), MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.OK.label")));
        this.statiPdnd.add(new javax.faces.model.SelectItem((Object)PossibiliStatiPdnd.PENDING.getValue(), MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.PENDING.label")));
        this.statiPdnd.add(new javax.faces.model.SelectItem((Object)PossibiliStatiPdnd.ERROR.getValue(), MessageManager.getInstance().getMessage("statistichePdndTracing.statoPdnd.ERROR.label")));
        return this.statiPdnd;
    }

    public Integer getMinTentativiPubblicazione() {
        return this.minTentativiPubblicazione;
    }

    public void setMinTentativiPubblicazione(Integer minTentativiPubblicazione) {
        this.minTentativiPubblicazione = minTentativiPubblicazione;
    }

    public org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean getStatisticaPdndTracing() {
        return this.statisticaPdndTracing;
    }

    public void setStatisticaPdndTracing(org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean statisticaPdndTracing) {
        this.statisticaPdndTracing = statisticaPdndTracing;
    }

    public String getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(String selectedTab) {
        this.selectedTab = selectedTab;
    }

    public List<GruppoRicercaStatistichePdnd> getTipiRicerca() {
        if (this.tipiRicerca != null) {
            return this.tipiRicerca;
        }
        this.tipiRicerca = new ArrayList<GruppoRicercaStatistichePdnd>();
        GruppoRicercaStatistichePdnd gruppoRicerca = new GruppoRicercaStatistichePdnd();
        gruppoRicerca.setLabel(MessageManager.getInstance().getMessage("statistichePdndTracing.search.tipoRicerca.temporale.label"));
        ArrayList<RicercaStatistichePdnd> listaGruppoTemporale = new ArrayList<RicercaStatistichePdnd>();
        listaGruppoTemporale.add(new RicercaStatistichePdnd(ModalitaRicercaStatistichePdnd.ANDAMENTO_TEMPORALE.getValue(), MessageManager.getInstance().getMessage("statistichePdndTracing.search.tipoRicerca.temporale.ricercaTemporale.label"), ModalitaRicercaStatistichePdnd.ANDAMENTO_TEMPORALE, MessageManager.getInstance().getMessage("statistichePdndTracing.search.tipoRicerca.temporale.ricercaTemporale.icona")));
        listaGruppoTemporale.add(new RicercaStatistichePdnd(ModalitaRicercaStatistichePdnd.TRACING_ID.getValue(), MessageManager.getInstance().getMessage("statistichePdndTracing.search.tipoRicerca.id.tracingId.label"), ModalitaRicercaStatistichePdnd.TRACING_ID, MessageManager.getInstance().getMessage("statistichePdndTracing.search.tipoRicerca.id.tracingId.icona")));
        gruppoRicerca.setListaRicerche(listaGruppoTemporale);
        this.tipiRicerca.add(gruppoRicerca);
        return this.tipiRicerca;
    }

    public String getTipoRicerca() {
        return this.tipoRicerca;
    }

    public void setTipoRicerca(String tipoRicerca) {
        this.tipoRicerca = tipoRicerca;
        if (this.updateTipoRicerca) {
            this.search.initSearchListener(null);
            ((StatistichePdndTracingSearchForm)this.search).setModalitaRicerca(this.tipoRicerca);
            this.updateTipoRicerca = false;
        }
    }

    public boolean isUpdateTipoRicerca() {
        return this.updateTipoRicerca;
    }

    public void setUpdateTipoRicerca(boolean updateTipoRicerca) {
        this.updateTipoRicerca = updateTipoRicerca;
    }

    public boolean isMaxAttemptReached() {
        return false;
    }

    public String forcePublishSelected() {
        List<Long> idReport = this.getIdSelected().stream().map(Long::valueOf).collect(Collectors.toList());
        StatistichePdndTracingService pdndService = (StatistichePdndTracingService)this.service;
        try {
            if (!this.isSelectedAll()) {
                pdndService.forcePublish(idReport);
            } else {
                pdndService.forcePublish();
            }
        }
        catch (Exception e) {
            log.error("errore nell'azzeramento dei tentativi di pubblicazione, ids: {}", idReport, (Object)e);
        }
        return null;
    }

    public boolean getForcePublishSelectedEnabled() {
        return ((StatistichePdndTracingSearchForm)this.search).getStato().equals(PossibiliStatiRichieste.FAILED.toString());
    }

    public String resetAttempts() {
        String soggettoReadable = this.statisticaPdndTracing.getSoggettoReadable();
        StatistichePdndTracingService pdndService = (StatistichePdndTracingService)this.service;
        try {
            pdndService.forcePublish(this.getStatisticaPdndTracing());
            this.statisticaPdndTracing = new org.openspcoop2.web.monitor.statistiche.bean.StatistichePdndTracingBean(pdndService.findById(this.statisticaPdndTracing.getId()));
        }
        catch (Exception e) {
            log.error("errore nell'azzeramento dei tentativi di pubblicazione, id: {}", (Object)this.statisticaPdndTracing.getId(), (Object)e);
        }
        this.statisticaPdndTracing.setSoggettoReadable(soggettoReadable);
        return null;
    }

    public boolean isForcePublishEnabled() {
        StatistichePdndTracingService pdndService = (StatistichePdndTracingService)this.service;
        return pdndService.isForcePublishEnabled(this.statisticaPdndTracing);
    }

    public StatistichePdndTracingBean() {
    }

    public StatistichePdndTracingBean(org.openspcoop2.core.commons.search.dao.IServiceManager serviceManager, IServiceManager pluginsServiceManager, DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB) {
        super(serviceManager, pluginsServiceManager, driverRegistroServiziDB, driverConfigurazioneDB);
    }
}

