/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.commons.search.AccordoServizioParteComune;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.Operation;
import org.openspcoop2.core.commons.search.PortType;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteComuneServiceSearch;
import org.openspcoop2.core.commons.search.dao.IAccordoServizioParteSpecificaServiceSearch;
import org.openspcoop2.core.commons.search.dao.IOperationServiceSearch;
import org.openspcoop2.core.commons.search.dao.IPortTypeServiceSearch;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.ConfigurazioneServizioAzione;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.PluginServizioAzioneCompatibilita;
import org.openspcoop2.core.plugins.PluginServizioCompatibilita;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioAzioneServiceSearch;
import org.openspcoop2.core.plugins.dao.IDBConfigurazioneServizioAzioneServiceSearch;
import org.openspcoop2.core.plugins.dao.IPluginServiceSearch;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.monitor.engine.config.BasicServiceLibrary;
import org.openspcoop2.monitor.engine.config.BasicServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.StatisticsServiceLibrary;
import org.openspcoop2.monitor.engine.config.StatisticsServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibrary;
import org.openspcoop2.monitor.engine.config.TransactionServiceLibraryReader;
import org.openspcoop2.monitor.engine.config.statistiche.ConfigurazioneStatistica;
import org.openspcoop2.monitor.engine.config.statistiche.IdConfigurazioneServizio;
import org.openspcoop2.monitor.engine.config.statistiche.IdConfigurazioneServizioAzione;
import org.openspcoop2.monitor.engine.config.statistiche.IdConfigurazioneStatistica;
import org.openspcoop2.monitor.engine.config.statistiche.dao.IConfigurazioneStatisticaService;
import org.openspcoop2.monitor.engine.config.statistiche.dao.IConfigurazioneStatisticaServiceSearch;
import org.openspcoop2.monitor.engine.config.statistiche.dao.IDBConfigurazioneStatisticaServiceSearch;
import org.openspcoop2.monitor.engine.config.statistiche.utils.ProjectInfo;
import org.openspcoop2.monitor.engine.dynamic.DynamicFactory;
import org.openspcoop2.monitor.engine.dynamic.IDynamicLoader;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.dynamic.DynamicComponentUtils;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.thread.ThreadExecutorManager;
import org.openspcoop2.web.monitor.statistiche.dao.IStatisticaPersonalizzataService;
import org.slf4j.Logger;

public class StatistichePersonalizzateService
implements IStatisticaPersonalizzataService {
    private static Logger log = LoggerManager.getPddMonitorSqlLogger();
    private boolean timeoutEvent = false;
    private Integer timeoutRicerche = null;
    private org.openspcoop2.core.commons.search.dao.IServiceManager utilsServiceManager;
    private org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager statistichePluginsServiceManager;
    private IServiceManager basePluginsServiceManager;
    private org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager transazioniPluginsServiceManager;
    private IConfigurazioneStatisticaService statisticaDAO;
    private IConfigurazioneStatisticaServiceSearch statisticaSearchDAO;
    private IConfigurazioneServizioAzioneServiceSearch confServAzSearchDAO;
    private IPluginServiceSearch pluginsServiceSearchDAO;
    private IAccordoServizioParteComuneServiceSearch accordoDAO;
    private IOperationServiceSearch operationDAO;
    private IPortTypeServiceSearch portTypeDAO;
    private IAccordoServizioParteSpecificaServiceSearch serviziDAO;
    private BasicServiceLibraryReader basicServiceLibraryReader = null;
    private TransactionServiceLibraryReader transactionServiceLibraryReader = null;
    private StatisticsServiceLibraryReader statisticsServiceLibraryReader = null;
    private ConfigurazioneServizioAzione configurazione;

    public StatistichePersonalizzateService() {
        try {
            this.utilsServiceManager = (org.openspcoop2.core.commons.search.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.commons.search.utils.ProjectInfo.getInstance(), log);
            this.portTypeDAO = this.utilsServiceManager.getPortTypeServiceSearch();
            this.accordoDAO = this.utilsServiceManager.getAccordoServizioParteComuneServiceSearch();
            this.operationDAO = this.utilsServiceManager.getOperationServiceSearch();
            this.serviziDAO = this.utilsServiceManager.getAccordoServizioParteSpecificaServiceSearch();
            this.basePluginsServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.core.plugins.utils.ProjectInfo.getInstance(), log);
            this.confServAzSearchDAO = this.basePluginsServiceManager.getConfigurazioneServizioAzioneServiceSearch();
            this.pluginsServiceSearchDAO = this.basePluginsServiceManager.getPluginServiceSearch();
            this.basicServiceLibraryReader = new BasicServiceLibraryReader(this.basePluginsServiceManager, this.utilsServiceManager, true);
            this.statistichePluginsServiceManager = (org.openspcoop2.monitor.engine.config.statistiche.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), log);
            this.statisticaDAO = this.statistichePluginsServiceManager.getConfigurazioneStatisticaService();
            this.statisticaSearchDAO = this.statistichePluginsServiceManager.getConfigurazioneStatisticaServiceSearch();
            this.statisticsServiceLibraryReader = new StatisticsServiceLibraryReader(this.statistichePluginsServiceManager, true);
            boolean attivoModuloTransazioniPersonalizzate = PddMonitorProperties.getInstance((Logger)log).isAttivoModuloTransazioniPersonalizzate();
            if (attivoModuloTransazioniPersonalizzate) {
                this.transazioniPluginsServiceManager = (org.openspcoop2.monitor.engine.config.transazioni.dao.IServiceManager)DAOFactory.getInstance((Logger)log).getServiceManager((IProjectInfo)org.openspcoop2.monitor.engine.config.transazioni.utils.ProjectInfo.getInstance(), log);
                this.transactionServiceLibraryReader = new TransactionServiceLibraryReader(this.transazioniPluginsServiceManager, true);
            }
            this.timeoutRicerche = PddMonitorProperties.getInstance((Logger)log).getIntervalloTimeoutRicercaStatistiche();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setConfigurazione(ConfigurazioneServizioAzione configurazione) {
        this.configurazione = configurazione;
    }

    public List<ConfigurazioneStatistica> findAll(int start, int limit) {
        block14: {
            try {
                IExpression expr = this.statisticaSearchDAO.newExpression();
                IDBConfigurazioneServizioAzioneServiceSearch dbConfSearch = (IDBConfigurazioneServizioAzioneServiceSearch)this.confServAzSearchDAO;
                ConfigurazioneServizioAzione conf = (ConfigurazioneServizioAzione)dbConfSearch.get(this.configurazione.getId().longValue());
                if (conf == null) break block14;
                HashMap<IField, Object> propertyNameValues = new HashMap<IField, Object>();
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, conf.getIdConfigurazioneServizio().getAccordo());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, conf.getIdConfigurazioneServizio().getNomeSoggettoReferente());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, conf.getIdConfigurazioneServizio().getServizio());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, conf.getIdConfigurazioneServizio().getTipoSoggettoReferente());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, conf.getIdConfigurazioneServizio().getVersione());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, this.configurazione.getAzione());
                expr.allEquals(propertyNameValues);
                expr.sortOrder(SortOrder.ASC).addOrder(ConfigurazioneStatistica.model().LABEL);
                IPaginatedExpression pagExpr = this.statisticaSearchDAO.toPaginatedExpression(expr);
                this.timeoutEvent = false;
                if (this.timeoutRicerche == null) {
                    return this.statisticaSearchDAO.findAll(pagExpr.offset(start).limit(limit));
                }
                try {
                    return ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.statisticaSearchDAO.findAll(pagExpr.offset(start).limit(limit))).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (ServiceException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionNotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (MultipleResultException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotFoundException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<ConfigurazioneStatistica>();
    }

    public int totalCount() {
        try {
            if (this.configurazione == null) {
                return 0;
            }
            IExpression expr = this.statisticaSearchDAO.newExpression();
            IDBConfigurazioneServizioAzioneServiceSearch dbConfSearch = (IDBConfigurazioneServizioAzioneServiceSearch)this.confServAzSearchDAO;
            ConfigurazioneServizioAzione conf = (ConfigurazioneServizioAzione)dbConfSearch.get(this.configurazione.getId().longValue());
            if (conf != null) {
                HashMap<IField, Object> propertyNameValues = new HashMap<IField, Object>();
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, conf.getIdConfigurazioneServizio().getAccordo());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, conf.getIdConfigurazioneServizio().getNomeSoggettoReferente());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, conf.getIdConfigurazioneServizio().getServizio());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, conf.getIdConfigurazioneServizio().getTipoSoggettoReferente());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, conf.getIdConfigurazioneServizio().getVersione());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, this.configurazione.getAzione());
                expr.allEquals(propertyNameValues);
                NonNegativeNumber nnn = this.statisticaSearchDAO.count(expr);
                return nnn != null ? (int)nnn.longValue() : 0;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public void store(ConfigurazioneStatistica obj) throws Exception {
        try {
            IdConfigurazioneStatistica idStat = new IdConfigurazioneStatistica();
            IdConfigurazioneServizioAzione idConf = new IdConfigurazioneServizioAzione();
            IdConfigurazioneServizio idServizio = new IdConfigurazioneServizio();
            idServizio.setAccordo(this.configurazione.getIdConfigurazioneServizio().getAccordo());
            idServizio.setTipoSoggettoReferente(this.configurazione.getIdConfigurazioneServizio().getTipoSoggettoReferente());
            idServizio.setNomeSoggettoReferente(this.configurazione.getIdConfigurazioneServizio().getNomeSoggettoReferente());
            idServizio.setVersione(this.configurazione.getIdConfigurazioneServizio().getVersione());
            idServizio.setServizio(this.configurazione.getIdConfigurazioneServizio().getServizio());
            idConf.setIdConfigurazioneServizio(idServizio);
            idConf.setAzione(this.configurazione.getAzione());
            if (obj.getId() != -1L) {
                idStat.setId(obj.getId());
                ConfigurazioneStatistica findById = this.findById(obj.getId());
                idStat.setIdConfigurazioneStatistica(findById.getIdConfigurazioneStatistica());
            } else {
                idStat.setIdConfigurazioneStatistica(obj.getIdConfigurazioneStatistica());
            }
            idStat.setIdConfigurazioneServizioAzione(idConf);
            if (this.statisticaDAO.exists((Object)idStat)) {
                this.statisticaDAO.update((Object)idStat, (Object)obj);
            } else {
                this.statisticaDAO.create((Object)obj);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void deleteById(Long key) {
        try {
            IdConfigurazioneStatistica id = new IdConfigurazioneStatistica();
            id.setId(key);
            this.statisticaDAO.deleteById((Object)id);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(ConfigurazioneStatistica obj) throws Exception {
        try {
            this.statisticaDAO.delete((Object)obj);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public ConfigurazioneStatistica findById(Long key) {
        try {
            return (ConfigurazioneStatistica)((IDBConfigurazioneStatisticaServiceSearch)this.statisticaSearchDAO).get(key.longValue());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<ConfigurazioneStatistica> findAll() {
        block15: {
            if (this.configurazione == null) {
                return new ArrayList<ConfigurazioneStatistica>();
            }
            try {
                IExpression expr = this.statisticaSearchDAO.newExpression();
                IDBConfigurazioneServizioAzioneServiceSearch dbConfSearch = (IDBConfigurazioneServizioAzioneServiceSearch)this.confServAzSearchDAO;
                ConfigurazioneServizioAzione conf = (ConfigurazioneServizioAzione)dbConfSearch.get(this.configurazione.getId().longValue());
                if (conf == null) break block15;
                HashMap<IField, Object> propertyNameValues = new HashMap<IField, Object>();
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, conf.getIdConfigurazioneServizio().getAccordo());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, conf.getIdConfigurazioneServizio().getNomeSoggettoReferente());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, conf.getIdConfigurazioneServizio().getServizio());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, conf.getIdConfigurazioneServizio().getTipoSoggettoReferente());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, conf.getIdConfigurazioneServizio().getVersione());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, this.configurazione.getAzione());
                expr.allEquals(propertyNameValues);
                expr.sortOrder(SortOrder.ASC).addOrder(ConfigurazioneStatistica.model().LABEL);
                IPaginatedExpression pagExpr = this.statisticaSearchDAO.toPaginatedExpression(expr);
                this.timeoutEvent = false;
                if (this.timeoutRicerche == null) {
                    return this.statisticaSearchDAO.findAll(pagExpr);
                }
                try {
                    return ThreadExecutorManager.getClientPoolExecutorRicerche().submit(() -> this.statisticaSearchDAO.findAll(pagExpr)).get(this.timeoutRicerche.longValue(), TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ServiceException) {
                        throw (ServiceException)e.getCause();
                    }
                    if (e.getCause() instanceof NotImplementedException) {
                        throw (NotImplementedException)e.getCause();
                    }
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.timeoutEvent = true;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (ServiceException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NotFoundException e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
            catch (MultipleResultException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionNotImplementedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ExpressionException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<ConfigurazioneStatistica>();
    }

    @Override
    public List<Parameter<?>> instanceParameters(ConfigurazioneStatistica configurazioneStatistica, Context context) {
        try {
            ArrayList<Parameter> res = null;
            IDynamicLoader bl = DynamicFactory.getInstance().newDynamicLoader(configurazioneStatistica.getPlugin().getTipoPlugin(), configurazioneStatistica.getPlugin().getTipo(), configurazioneStatistica.getPlugin().getClassName(), log);
            List sdkParameters = bl.getParameters(context);
            if (sdkParameters != null && sdkParameters.size() > 0) {
                res = new ArrayList<Parameter>();
                for (Parameter sdkParameter : sdkParameters) {
                    res.add(DynamicComponentUtils.createDynamicComponentParameter((Parameter)sdkParameter, (IDynamicLoader)bl));
                }
            }
            return res;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<ConfigurazioneStatistica> getStatisticheByValues(IDAccordo idAccordo, String nomeServizio, String nomeAzione) {
        try {
            if (idAccordo == null || nomeServizio == null) {
                log.error("Impossibile recuperare lista statistiche: idAccordo e/o nomeServizio non forniti.");
                return new ArrayList<ConfigurazioneStatistica>();
            }
            List lista = null;
            BasicServiceLibrary basicServiceLibrary = this.basicServiceLibraryReader.read(idAccordo, nomeServizio, nomeAzione, log);
            if (basicServiceLibrary != null) {
                StatisticsServiceLibrary statsServiceLibrary;
                TransactionServiceLibrary transactionServiceLibrary = null;
                if (this.transactionServiceLibraryReader != null) {
                    transactionServiceLibrary = this.transactionServiceLibraryReader.readConfigurazioneTransazione(basicServiceLibrary, log);
                }
                if ((statsServiceLibrary = this.statisticsServiceLibraryReader.readConfigurazioneStatistiche(basicServiceLibrary, transactionServiceLibrary, log)) != null) {
                    lista = statsServiceLibrary.mergeServiceActionSearchLibrary(true, true);
                }
            }
            return lista;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new ArrayList<ConfigurazioneStatistica>();
        }
    }

    public ConfigurazioneStatistica getStatisticaByValues(IDAccordo idAccordo, String nomeServizio, String nomeAzione, String nomeStatistica) {
        try {
            if (idAccordo == null || nomeServizio == null || nomeAzione == null || nomeStatistica == null) {
                log.error("Impossibile recuperare lista statistiche: idAccordo, nomeServizio, nomeAzione e/o nomeStatistica non forniti.");
                return null;
            }
            HashMap<IField, Object> params = new HashMap<IField, Object>();
            if (idAccordo.getSoggettoReferente() != null) {
                if (idAccordo.getSoggettoReferente().getTipo() != null) {
                    params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, idAccordo.getSoggettoReferente().getNome());
                }
                if (idAccordo.getSoggettoReferente().getNome() != null) {
                    params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, idAccordo.getSoggettoReferente().getTipo());
                }
            }
            if (idAccordo.getVersione() != null) {
                params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, idAccordo.getVersione());
            }
            params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, idAccordo.getNome());
            params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, nomeServizio);
            params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, nomeAzione);
            params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_STATISTICA, nomeStatistica);
            return (ConfigurazioneStatistica)this.statisticaSearchDAO.find(this.statisticaSearchDAO.newExpression().allEquals(params));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void deleteAll() throws Exception {
    }

    @Override
    public ConfigurazioneStatistica findByStatistica(ConfigurazioneStatistica statisticaToCheck) throws NotFoundException, ServiceException {
        try {
            IExpression expr = this.statisticaSearchDAO.newExpression();
            HashMap<IField, Object> params = new HashMap<IField, Object>();
            IdConfigurazioneServizioAzione idConfigurazioneServizioAzione = statisticaToCheck.getIdConfigurazioneServizioAzione();
            if (idConfigurazioneServizioAzione != null) {
                params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getAccordo());
                params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getNomeSoggettoReferente());
                params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getServizio());
                params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getTipoSoggettoReferente());
                params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getVersione());
            }
            expr.isNotNull(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE);
            params.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_STATISTICA, statisticaToCheck.getIdConfigurazioneStatistica());
            expr.allEquals(params);
            return (ConfigurazioneStatistica)this.statisticaSearchDAO.find(expr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public PortType getPortTypeFromAccordoServizio(String nomeAccordo, String nomeServizio) {
        try {
            IExpression expr = this.accordoDAO.newExpression();
            expr.equals(AccordoServizioParteComune.model().NOME, (Object)nomeAccordo);
            AccordoServizioParteComune accordo = (AccordoServizioParteComune)this.accordoDAO.find(expr);
            if (accordo == null) {
                return null;
            }
            expr = this.portTypeDAO.newExpression();
            expr.equals(PortType.model().NOME, (Object)nomeServizio);
            expr.and().equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)accordo.getNome());
            expr.and().equals(PortType.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)accordo.getVersione());
            return (PortType)this.portTypeDAO.find(expr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<Operation> getAzioniFromAccordoServizio(String nomeAccordo, String nomeServizio) {
        log.info("Get Lista Azioni from Accordo Servizio [Accordo: " + nomeAccordo + "], [nome Servizio: " + nomeServizio + "]");
        try {
            IExpression expr = this.accordoDAO.newExpression();
            expr.equals(AccordoServizioParteComune.model().NOME, (Object)nomeAccordo);
            AccordoServizioParteComune accordo = (AccordoServizioParteComune)this.accordoDAO.find(expr);
            if (accordo == null) {
                return new ArrayList<Operation>();
            }
            expr = this.operationDAO.newExpression();
            expr.equals(Operation.model().ID_PORT_TYPE.NOME, (Object)nomeServizio);
            expr.and().equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, (Object)accordo.getNome());
            expr.and().equals(Operation.model().ID_PORT_TYPE.ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, (Object)accordo.getVersione());
            expr.sortOrder(SortOrder.ASC).addOrder(Operation.model().NOME);
            IPaginatedExpression pagExpr = this.operationDAO.toPaginatedExpression(expr);
            return this.operationDAO.findAll(pagExpr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Operation>();
    }

    @Override
    public List<Map<String, Object>> findElencoServizi(Soggetto soggetto) {
        log.info("Get Lista Servizi [Soggetto: " + (soggetto != null ? soggetto.getNomeSoggetto() : "Null") + "]");
        try {
            IExpression expr = this.serviziDAO.newExpression();
            if (soggetto != null) {
                expr.equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.TIPO, (Object)soggetto.getTipoSoggetto());
                expr.and().equals(AccordoServizioParteSpecifica.model().ID_EROGATORE.NOME, (Object)soggetto.getNomeSoggetto());
            }
            expr.sortOrder(SortOrder.ASC).addOrder(AccordoServizioParteSpecifica.model().NOME);
            IPaginatedExpression pagExpr = this.serviziDAO.toPaginatedExpression(expr);
            return this.serviziDAO.select(pagExpr, true, new IField[]{AccordoServizioParteSpecifica.model().NOME, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.NOME, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.VERSIONE, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.TIPO, AccordoServizioParteSpecifica.model().ID_ACCORDO_SERVIZIO_PARTE_COMUNE.ID_SOGGETTO.NOME});
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return new ArrayList<Map<String, Object>>();
    }

    @Override
    public ConfigurazioneStatistica findByStatisticaPlugin(ConfigurazioneStatistica statisticaToCheck, boolean checkAllActions, boolean checkSpecificActions) throws NotFoundException, ServiceException {
        try {
            IExpression expr = this.statisticaSearchDAO.newExpression();
            expr.and();
            HashMap<IField, Object> propertyNameValues = new HashMap<IField, Object>();
            IdConfigurazioneServizioAzione idConfigurazioneServizioAzione = statisticaToCheck.getIdConfigurazioneServizioAzione();
            if (idConfigurazioneServizioAzione != null) {
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getAccordo());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getNomeSoggettoReferente());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getServizio());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getTipoSoggettoReferente());
                propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, idConfigurazioneServizioAzione.getIdConfigurazioneServizio().getVersione());
            }
            expr.isNotNull(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE);
            if (checkAllActions && checkSpecificActions) {
                throw new ServiceException("Invocazione metodo non permessa checkAllActions[" + checkAllActions + "] checkSpecificActions[" + checkSpecificActions + "]");
            }
            if (checkAllActions) {
                expr.equals(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, (Object)"*");
            }
            if (checkSpecificActions) {
                expr.notEquals(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, (Object)"*");
            }
            propertyNameValues.put(ConfigurazioneStatistica.model().PLUGIN.CLASS_NAME, statisticaToCheck.getPlugin().getClassName());
            propertyNameValues.put(ConfigurazioneStatistica.model().PLUGIN.TIPO, statisticaToCheck.getPlugin().getTipo());
            expr.allEquals(propertyNameValues);
            return (ConfigurazioneStatistica)this.statisticaSearchDAO.find(expr);
        }
        catch (ServiceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotFoundException e) {
            log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (MultipleResultException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public List<Plugin> compatiblePlugins(ConfigurazioneServizioAzione configurazione, Long idStatistica) {
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        try {
            org.openspcoop2.core.plugins.IdConfigurazioneServizio confServ = configurazione.getIdConfigurazioneServizio();
            String uriAccordo = IDAccordoFactory.getInstance().getUriFromValues(confServ.getAccordo(), new IDSoggetto(confServ.getTipoSoggettoReferente(), confServ.getNomeSoggettoReferente()), confServ.getVersione());
            String servizio = confServ.getServizio();
            String azione = configurazione.getAzione();
            IPaginatedExpression expr = this.statisticaSearchDAO.newPaginatedExpression();
            HashMap<IField, Object> propertyNameValues = new HashMap<IField, Object>();
            propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.ACCORDO, confServ.getAccordo());
            propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.NOME_SOGGETTO_REFERENTE, confServ.getNomeSoggettoReferente());
            propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.SERVIZIO, confServ.getServizio());
            propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.TIPO_SOGGETTO_REFERENTE, confServ.getTipoSoggettoReferente());
            propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.ID_CONFIGURAZIONE_SERVIZIO.VERSIONE, confServ.getVersione());
            propertyNameValues.put(ConfigurazioneStatistica.model().ID_CONFIGURAZIONE_SERVIZIO_AZIONE.AZIONE, azione);
            expr.allEquals(propertyNameValues);
            List listConfigStatistica = this.statisticaSearchDAO.findAll(expr);
            if (idStatistica != null && idStatistica > 0L) {
                for (int i = 0; i < listConfigStatistica.size(); ++i) {
                    if (!((ConfigurazioneStatistica)listConfigStatistica.get(i)).getId().equals(idStatistica)) continue;
                    listConfigStatistica.remove(i);
                    break;
                }
            }
            IPaginatedExpression pagExpr = this.pluginsServiceSearchDAO.newPaginatedExpression();
            pagExpr.limit(10000);
            pagExpr.and();
            pagExpr.equals(Plugin.model().TIPO, (Object)TipoPlugin.STATISTICA);
            List listSearch = this.pluginsServiceSearchDAO.findAll(pagExpr);
            for (Plugin pluginCheck : listSearch) {
                if (listConfigStatistica != null && listConfigStatistica.size() > 0) {
                    boolean found = false;
                    for (ConfigurazioneStatistica confStatistica : listConfigStatistica) {
                        if (!confStatistica.getPlugin().getClassName().equals(pluginCheck.getClassName())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                if (pluginCheck.sizePluginServizioCompatibilitaList() <= 0) {
                    list.add(pluginCheck);
                    continue;
                }
                boolean compatible = false;
                for (PluginServizioCompatibilita servizioCompatibilita : pluginCheck.getPluginServizioCompatibilitaList()) {
                    if (servizioCompatibilita.getUriAccordo() != null && !servizioCompatibilita.getUriAccordo().equals(uriAccordo) || servizioCompatibilita.getServizio() != null && !servizioCompatibilita.getServizio().equals(servizio)) continue;
                    if (azione == null || "*".equals(azione)) {
                        if (servizioCompatibilita.sizePluginServizioAzioneCompatibilitaList() > 0) {
                            continue;
                        }
                    } else if (servizioCompatibilita.sizePluginServizioAzioneCompatibilitaList() > 0) {
                        boolean foundAzione = false;
                        for (PluginServizioAzioneCompatibilita azioneCompatibilita : servizioCompatibilita.getPluginServizioAzioneCompatibilitaList()) {
                            if (!azioneCompatibilita.getAzione().equals(azione)) continue;
                            foundAzione = true;
                        }
                        if (!foundAzione) continue;
                    }
                    compatible = true;
                    break;
                }
                if (!compatible) continue;
                list.add(pluginCheck);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @Override
    public boolean isTimeoutEvent() {
        return this.timeoutEvent;
    }
}

