/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.mvc.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class SecurityProperties {
    private static final Map<String, Pattern> patternCache = new HashMap<String, Pattern>();
    private static Logger log;
    private static SecurityProperties instance;
    private Properties properties;

    public static synchronized void init(Properties p, Logger log) {
        if (SecurityProperties.log == null) {
            SecurityProperties.log = log;
        }
        if (instance == null) {
            instance = new SecurityProperties(p);
        }
    }

    public static synchronized SecurityProperties getInstance() {
        return instance;
    }

    private SecurityProperties(Properties p) {
        this.properties = p;
    }

    public Pattern getValidationPattern(String key) {
        String value = this.getProperty("patternValidazione." + key);
        if (value == null || value.equals("")) {
            return null;
        }
        Pattern p = patternCache.get(value);
        if (p != null) {
            return p;
        }
        try {
            Pattern q = Pattern.compile(value, 2);
            patternCache.put(value, q);
            return q;
        }
        catch (PatternSyntaxException e) {
            log.error("Pattern di validazione non valido per il tipo {}.", (Object)key);
            return null;
        }
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public Integer getIntProp(String property) throws UtilsException {
        String tmp = this.getProperty(property);
        try {
            return tmp != null ? Integer.valueOf(Integer.parseInt(tmp)) : null;
        }
        catch (NumberFormatException e) {
            throw new UtilsException("Property [" + property + "] with uncorrect value [" + tmp + "] (int value expected)");
        }
    }
}

