-- **** Regitro Plugins ****

CREATE SEQUENCE seq_registro_plugins AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) NO CYCLE;

CREATE TABLE registro_plugins
(
	nome VARCHAR(255) NOT NULL,
	posizione INT NOT NULL,
	stato VARCHAR(255),
	descrizione VARCHAR(255),
	data TIMESTAMP NOT NULL,
	compatibilita VARCHAR(65535),
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	-- unique constraints
	CONSTRAINT unique_registro_plugins_1 UNIQUE (nome),
	-- fk/pk keys constraints
	CONSTRAINT pk_registro_plugins PRIMARY KEY (id)
);

-- index
CREATE UNIQUE INDEX index_registro_plugins_1 ON registro_plugins (nome);

ALTER TABLE registro_plugins ALTER COLUMN data SET DEFAULT CURRENT_TIMESTAMP;

CREATE TABLE registro_plugins_init_seq (id BIGINT);
INSERT INTO registro_plugins_init_seq VALUES (NEXT VALUE FOR seq_registro_plugins);



CREATE SEQUENCE seq_registro_plug_jar AS BIGINT START WITH 1 INCREMENT BY 1 ; -- (Scommentare in hsql 2.x) NO CYCLE;

CREATE TABLE registro_plug_jar
(
	id_plugin BIGINT NOT NULL,
	nome VARCHAR(255) NOT NULL,
	sorgente VARCHAR(255) NOT NULL,
	-- In hsql 2.x usare il tipo BLOB al posto di VARBINARY
	contenuto VARBINARY(1073741823),
	url VARCHAR(4000),
	dir VARCHAR(4000),
	data TIMESTAMP NOT NULL,
	-- fk/pk columns
	id BIGINT GENERATED BY DEFAULT AS IDENTITY (START WITH 1),
	-- unique constraints
	CONSTRAINT unique_registro_plug_jar_1 UNIQUE (id_plugin,nome),
	-- fk/pk keys constraints
	CONSTRAINT fk_registro_plug_jar_1 FOREIGN KEY (id_plugin) REFERENCES registro_plugins(id),
	CONSTRAINT pk_registro_plug_jar PRIMARY KEY (id)
);

-- index
CREATE INDEX index_registro_plug_jar_1 ON registro_plug_jar (id_plugin);

ALTER TABLE registro_plug_jar ALTER COLUMN data SET DEFAULT CURRENT_TIMESTAMP;

CREATE TABLE registro_plug_jar_init_seq (id BIGINT);
INSERT INTO registro_plug_jar_init_seq VALUES (NEXT VALUE FOR seq_registro_plug_jar);

-- Aggiunto filtro per tag sul controllo del traffico
ALTER TABLE ct_active_policy ADD COLUMN filtro_tag VARCHAR(255);

-- Modificata dimensione colonna id_active_policy
ALTER TABLE ct_active_policy ALTER COLUMN active_policy_id VARCHAR(275);

