/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.users.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.openspcoop2.web.lib.users.dao.Stato;
import org.openspcoop2.web.lib.users.dao.UserPassword;

public class User
implements Serializable {
    private Long id;
    protected String login;
    protected String password;
    private Date lastUpdatePassword;
    private boolean checkLastUpdatePassword;
    private InterfaceType interfaceType;
    private boolean permitInterfaceComplete = false;
    private PermessiUtente permessi;
    private List<String> protocolliSupportati;
    private String protocolloSelezionatoPddConsole;
    private String protocolloSelezionatoPddMonitor;
    private String soggettoSelezionatoPddConsole;
    private String soggettoSelezionatoPddMonitor;
    private boolean permitAllSoggetti = false;
    private boolean permitAllServizi = false;
    private List<IDSoggetto> soggetti = new ArrayList<IDSoggetto>();
    private List<IDServizio> servizi = new ArrayList<IDServizio>();
    private List<Stato> stati = new ArrayList<Stato>();
    private List<UserPassword> precedentiPassword = new ArrayList<UserPassword>();
    private static final long serialVersionUID = 1L;

    public List<String> getProtocolliSupportati() {
        return this.protocolliSupportati;
    }

    public String getProtocolliSupportatiAsString() {
        if (this.protocolliSupportati == null || this.protocolliSupportati.size() <= 0) {
            return null;
        }
        StringBuilder bf = new StringBuilder();
        for (String p : this.protocolliSupportati) {
            if (bf.length() > 0) {
                bf.append(",");
            }
            bf.append(p);
        }
        return bf.toString();
    }

    public void setProtocolliSupportati(List<String> protocolliSupportati) {
        this.protocolliSupportati = protocolliSupportati;
    }

    public void addProtocolloSupportato(String protocolloSupportato) {
        protocolloSupportato = protocolloSupportato.trim();
        if (this.protocolliSupportati == null) {
            this.protocolliSupportati = new ArrayList<String>();
        }
        if (!this.protocolliSupportati.contains(protocolloSupportato)) {
            this.protocolliSupportati.add(protocolloSupportato);
        }
    }

    public void setProtocolliSupportatiFromString(String v) {
        if (v == null) {
            this.protocolliSupportati = null;
            return;
        }
        if (v.contains(",")) {
            String[] tmp = v.split(",");
            for (int i = 0; i < tmp.length; ++i) {
                String p = tmp[i].trim();
                this.addProtocolloSupportato(p);
            }
        } else {
            this.addProtocolloSupportato(v);
        }
    }

    public void clearProtocolliSupportati() {
        if (this.protocolliSupportati == null) {
            this.protocolliSupportati = new ArrayList<String>();
        } else {
            this.protocolliSupportati.clear();
        }
    }

    public String getProtocolloSelezionatoPddConsole() {
        return this.protocolloSelezionatoPddConsole;
    }

    public void setProtocolloSelezionatoPddConsole(String protocolloSelezionatoPddConsole) {
        this.protocolloSelezionatoPddConsole = protocolloSelezionatoPddConsole;
    }

    public String getProtocolloSelezionatoPddMonitor() {
        return this.protocolloSelezionatoPddMonitor;
    }

    public void setProtocolloSelezionatoPddMonitor(String protocolloSelezionatoPddMonitor) {
        this.protocolloSelezionatoPddMonitor = protocolloSelezionatoPddMonitor;
    }

    public boolean isPermitInterfaceComplete() {
        return this.permitInterfaceComplete;
    }

    public void setPermitInterfaceComplete(boolean permitInterfaceComplete) {
        this.permitInterfaceComplete = permitInterfaceComplete;
    }

    public InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(InterfaceType interfaceType) {
        this.interfaceType = interfaceType;
    }

    public PermessiUtente getPermessi() {
        return this.permessi;
    }

    public void setPermessi(PermessiUtente permessi) {
        this.permessi = permessi;
    }

    public Long getId() {
        if (this.id != null) {
            return this.id;
        }
        return -1L;
    }

    public void setId(Long id) {
        this.id = id != null ? id : Long.valueOf(-1L);
    }

    public String getLogin() {
        if (this.login != null && !"".equals(this.login)) {
            return this.login.trim();
        }
        return null;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        if (this.password != null && !"".equals(this.password)) {
            return this.password.trim();
        }
        return null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasOnlyPermessiUtenti() {
        if (this.permessi != null) {
            return this.permessi.isUtenti() && !this.permessi.isAccordiCooperazione() && !this.permessi.isAuditing() && !this.permessi.isCodeMessaggi() && !this.permessi.isDiagnostica() && !this.permessi.isServizi() && !this.permessi.isSistema();
        }
        return false;
    }

    public List<IDSoggetto> getSoggetti() {
        return this.soggetti;
    }

    public List<IDServizio> getServizi() {
        return this.servizi;
    }

    public List<Stato> getStati() {
        return this.stati;
    }

    public List<UserPassword> getPrecedentiPassword() {
        return this.precedentiPassword;
    }

    public String getSoggettoSelezionatoPddConsole() {
        return this.soggettoSelezionatoPddConsole;
    }

    public void setSoggettoSelezionatoPddConsole(String soggettoSelezionatoPddConsole) {
        this.soggettoSelezionatoPddConsole = soggettoSelezionatoPddConsole;
    }

    public String getSoggettoSelezionatoPddMonitor() {
        return this.soggettoSelezionatoPddMonitor;
    }

    public void setSoggettoSelezionatoPddMonitor(String soggettoSelezionatoPddMonitor) {
        this.soggettoSelezionatoPddMonitor = soggettoSelezionatoPddMonitor;
    }

    public boolean isPermitAllSoggetti() {
        return this.permitAllSoggetti;
    }

    public void setPermitAllSoggetti(boolean permitAllSoggetti) {
        this.permitAllSoggetti = permitAllSoggetti;
    }

    public boolean isPermitAllServizi() {
        return this.permitAllServizi;
    }

    public void setPermitAllServizi(boolean permitAllServizi) {
        this.permitAllServizi = permitAllServizi;
    }

    public boolean isConfigurazioneValidaAbilitazioni() {
        if (!this.isConfigurazioneValidaSoggettiAbilitati()) {
            return false;
        }
        return this.isConfigurazioneValidaServiziAbilitati();
    }

    public boolean isConfigurazioneValidaSoggettiAbilitati() {
        return !this.permessi.isDiagnostica() && !this.permessi.isReportistica() || this.permitAllSoggetti || this.soggetti != null && this.soggetti.size() > 0;
    }

    public boolean isConfigurazioneValidaServiziAbilitati() {
        return !this.permessi.isDiagnostica() && !this.permessi.isReportistica() || this.permitAllServizi || this.servizi != null && this.servizi.size() > 0;
    }

    public Date getLastUpdatePassword() {
        return this.lastUpdatePassword;
    }

    public void setLastUpdatePassword(Date lastUpdatePassword) {
        this.lastUpdatePassword = lastUpdatePassword;
    }

    public boolean isCheckLastUpdatePassword() {
        return this.checkLastUpdatePassword;
    }

    public void setCheckLastUpdatePassword(boolean checkLastUpdatePassword) {
        this.checkLastUpdatePassword = checkLastUpdatePassword;
    }

    public String getReasonInvalidConfiguration() {
        String msgErrore = "L'utente non possiede abilitazioni valide";
        if (!(this.permitAllSoggetti || this.soggetti != null && this.soggetti.size() > 0)) {
            return msgErrore;
        }
        if (!(!this.permessi.isDiagnostica() && !this.permessi.isReportistica() || this.permitAllServizi || this.servizi != null && this.servizi.size() > 0)) {
            return msgErrore;
        }
        return null;
    }
}

