/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.subscriber.DefaultQueryCacheRecordStore;
import com.hazelcast.map.impl.querycache.subscriber.EventPublisherHelper;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRecordStore;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.impl.querycache.subscriber.record.QueryCacheRecord;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexUtils;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.predicates.TruePredicate;
import com.hazelcast.spi.impl.UnmodifiableLazySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;

abstract class AbstractInternalQueryCache<K, V>
implements InternalQueryCache<K, V> {
    protected final boolean includeValue;
    protected final String mapName;
    protected final String cacheId;
    protected final String cacheName;
    protected final IMap delegate;
    protected final Indexes indexes;
    protected final QueryCacheContext context;
    protected final QueryCacheConfig queryCacheConfig;
    protected final QueryCacheRecordStore recordStore;
    protected final PartitioningStrategy partitioningStrategy;
    protected final InternalSerializationService ss;
    protected final Extractors extractors;
    protected volatile UUID publisherListenerId;

    AbstractInternalQueryCache(String cacheId, String cacheName, QueryCacheConfig queryCacheConfig, IMap delegate, QueryCacheContext context) {
        this.cacheId = cacheId;
        this.cacheName = cacheName;
        this.queryCacheConfig = queryCacheConfig;
        this.mapName = delegate.getName();
        this.delegate = delegate;
        this.context = context;
        this.ss = context.getSerializationService();
        this.indexes = Indexes.newBuilder(null, this.mapName, this.ss, IndexCopyBehavior.COPY_ON_READ, queryCacheConfig.getInMemoryFormat()).partitionCount(context.getPartitionCount()).build();
        this.includeValue = this.isIncludeValue();
        this.partitioningStrategy = this.getPartitioningStrategy();
        this.extractors = Extractors.newBuilder(this.ss).build();
        this.recordStore = new DefaultQueryCacheRecordStore(this.ss, this.indexes, queryCacheConfig, this.getEvictionListener(), this.extractors);
        assert (this.indexes.isGlobal());
        for (IndexConfig indexConfig : queryCacheConfig.getIndexConfigs()) {
            IndexConfig indexConfig0 = this.getNormalizedIndexConfig(indexConfig);
            this.indexes.addOrGetIndex(indexConfig0);
        }
    }

    public QueryCacheContext getContext() {
        return this.context;
    }

    @Override
    public UUID getPublisherListenerId() {
        return this.publisherListenerId;
    }

    @Override
    public void setPublisherListenerId(UUID publisherListenerId) {
        this.publisherListenerId = Objects.requireNonNull(publisherListenerId, "publisherListenerId cannot be null");
    }

    @Override
    public String getCacheId() {
        return this.cacheId;
    }

    protected Predicate getPredicate() {
        return this.queryCacheConfig.getPredicateConfig().getImplementation();
    }

    @Override
    public boolean reachedMaxCapacity() {
        EvictionConfig evictionConfig = this.queryCacheConfig.getEvictionConfig();
        MaxSizePolicy maximumSizePolicy = evictionConfig.getMaxSizePolicy();
        return maximumSizePolicy == MaxSizePolicy.ENTRY_COUNT && this.size() == evictionConfig.getSize();
    }

    private EvictionListener getEvictionListener() {
        return (queryCacheKey, record, wasExpired) -> EventPublisherHelper.publishEntryEvent(this.context, this.mapName, this.cacheId, queryCacheKey, null, record, EntryEventType.EVICTED, this.extractors);
    }

    PartitioningStrategy getPartitioningStrategy() {
        if (this.delegate instanceof MapProxyImpl) {
            return ((MapProxyImpl)this.delegate).getPartitionStrategy();
        }
        return null;
    }

    protected Set scanAndGetResult(Predicate predicate, ResultType resultType) {
        ResulCollector resulCollector = new ResulCollector(resultType);
        if (predicate == TruePredicate.INSTANCE) {
            this.doFullScan(predicate, resulCollector);
            return this.toImmutableLazySet(resulCollector.getResult());
        }
        if (this.tryQueryOverIndexes(predicate, resulCollector)) {
            return this.toImmutableLazySet(resulCollector.getResult());
        }
        this.doFullScan(predicate, resulCollector);
        return this.toImmutableLazySet(resulCollector.getResult());
    }

    private Set toImmutableLazySet(List resultSet) {
        return new UnmodifiableLazySet(resultSet, this.ss);
    }

    private boolean tryQueryOverIndexes(Predicate predicate, BiConsumer biConsumer) {
        Iterable<QueryableEntry> query = this.indexes.query(predicate, -1);
        if (query == null) {
            return false;
        }
        for (QueryableEntry entry : query) {
            biConsumer.accept(entry.getKeyData(), entry.getValueData());
        }
        return true;
    }

    private void doFullScan(Predicate predicate, BiConsumer biConsumer) {
        if (predicate == TruePredicate.INSTANCE) {
            this.dumpAll(biConsumer);
            return;
        }
        this.scanWithPredicate(predicate, biConsumer);
    }

    private void dumpAll(BiConsumer consumer) {
        Set<Map.Entry<Object, QueryCacheRecord>> entries = this.recordStore.entrySet();
        for (Map.Entry<Object, QueryCacheRecord> entry : entries) {
            consumer.accept(entry.getKey(), entry.getValue().getRawValue());
        }
    }

    private void scanWithPredicate(Predicate predicate, BiConsumer consumer) {
        boolean areKeyValueObjectType = !this.queryCacheConfig.isSerializeKeys() && InMemoryFormat.OBJECT == this.queryCacheConfig.getInMemoryFormat();
        CachedQueryEntry queryEntry = new CachedQueryEntry(this.ss, this.extractors);
        Set<Map.Entry<Object, QueryCacheRecord>> entries = this.recordStore.entrySet();
        for (Map.Entry<Object, QueryCacheRecord> entry : entries) {
            Object queryCacheKey = entry.getKey();
            Object rawValue = entry.getValue().getRawValue();
            if (areKeyValueObjectType) {
                queryEntry.initWithObjectKeyValue(queryCacheKey, rawValue);
            } else {
                queryEntry.init(queryCacheKey, rawValue);
            }
            if (!predicate.apply(queryEntry)) continue;
            consumer.accept(queryCacheKey, queryEntry.getByPrioritizingObjectValue());
        }
    }

    private boolean isIncludeValue() {
        return this.queryCacheConfig.isIncludeValue();
    }

    protected QueryCacheEventService getEventService() {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        return subscriberContext.getEventService();
    }

    protected <T> T toObject(Object valueInRecord) {
        return this.ss.toObject(valueInRecord);
    }

    protected Data toData(Object key) {
        return this.ss.toData(key, this.partitioningStrategy);
    }

    @Override
    public Extractors getExtractors() {
        return this.extractors;
    }

    @Override
    public void clear() {
        this.indexes.destroyIndexes();
        this.recordStore.clear();
    }

    protected IndexConfig getNormalizedIndexConfig(IndexConfig originalConfig) {
        String name = this.delegate.getName() + "_" + this.cacheName;
        return IndexUtils.validateAndNormalize(name, originalConfig);
    }

    private final class ResulCollector
    implements BiConsumer {
        private final ResultType resultType;
        private final List result = new ArrayList();

        private ResulCollector(ResultType resultType) {
            this.resultType = resultType;
        }

        public void accept(Object key, Object value) {
            switch (this.resultType) {
                case KEY: {
                    this.result.add(key);
                    break;
                }
                case VALUE: {
                    this.result.add(value);
                    break;
                }
                case ENTRY: {
                    this.result.add(new CachedQueryEntry(AbstractInternalQueryCache.this.ss, key, value, AbstractInternalQueryCache.this.extractors));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type: " + (Object)((Object)this.resultType));
                }
            }
        }

        public List getResult() {
            return this.result;
        }
    }

    static enum ResultType {
        KEY,
        VALUE,
        ENTRY;

    }
}

