/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.allarmi.mbean;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeFiltro;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.AllarmeParametro;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.constants.TipoPeriodo;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.commons.search.AccordoServizioParteComune;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.PortaApplicativa;
import org.openspcoop2.core.commons.search.PortaDelegata;
import org.openspcoop2.core.commons.search.Resource;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.monitor.engine.alarm.AlarmConfigProperties;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.AlarmImpl;
import org.openspcoop2.monitor.engine.alarm.AlarmManager;
import org.openspcoop2.monitor.engine.alarm.AlarmStatusWithAck;
import org.openspcoop2.monitor.engine.alarm.utils.AllarmiUtils;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.monitor.sdk.alarm.AlarmStatus;
import org.openspcoop2.monitor.sdk.alarm.IAlarm;
import org.openspcoop2.monitor.sdk.condition.Context;
import org.openspcoop2.monitor.sdk.constants.AlarmStateValues;
import org.openspcoop2.monitor.sdk.exceptions.AlarmException;
import org.openspcoop2.monitor.sdk.exceptions.AlarmNotifyException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.monitor.sdk.plugins.DialogInfo;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.allarmi.bean.AllarmiContext;
import org.openspcoop2.web.monitor.allarmi.dao.IAllarmiService;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsService;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.dao.MBeanUtilsService;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.mbean.DynamicPdDBean;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.slf4j.Logger;

public class AllarmiBean
extends DynamicPdDBean<ConfigurazioneAllarmeBean, Integer, IService<ConfigurazioneAllarmeBean, Long>> {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private transient List<Parameter<?>> parameters;
    private ConfigurazioneAllarmeBean allarme;
    private AllarmeHistory allarmeHistory;
    private String ack;
    private boolean modificatoInformazioniHistory = false;
    private boolean modificatoStato = false;
    private boolean modificatoAckwoldegment = false;
    private StatoAllarme modificatoInformazioniHistory_statoAllarme = null;
    private String modificatoInformazioniHistory_dettaglioAllarme = null;
    private Integer modificatoInformazioniHistory_ackwoldegmentAllarme = null;
    private StatoAllarme statoAllarmePrimaModifica = null;
    private AlarmEngineConfig alarmEngineConfig;
    private boolean showFilter = true;
    private boolean showGroupBy = true;
    private boolean controlloAllarmiFiltroApiSoggettoErogatore = false;
    private String selectedTab = null;
    private boolean editMode = false;
    private boolean ackMode = false;
    private org.openspcoop2.web.monitor.core.bean.DialogInfo criteriAckDialogInfo;

    public boolean isShowFilter() throws Exception {
        if (this.allarme == null || this.allarme.getPlugin() == null) {
            return false;
        }
        AllarmiContext context = new AllarmiContext(this);
        this.showFilter = ((IAllarmiService)this.service).isUsableFilter((Allarme)this.allarme, (Context)context);
        return this.showFilter;
    }

    public void setShowFilter(boolean showFilter) {
        this.showFilter = showFilter;
    }

    public boolean isShowGroupBy() throws Exception {
        if (this.allarme == null || this.allarme.getPlugin() == null) {
            return false;
        }
        AllarmiContext context = new AllarmiContext(this);
        this.showGroupBy = ((IAllarmiService)this.service).isUsableGroupBy((Allarme)this.allarme, (Context)context);
        return this.showGroupBy;
    }

    public void setShowGroupBy(boolean showGroupBy) {
        this.showGroupBy = showGroupBy;
    }

    public String getParameterSectionTitle() throws Exception {
        if (this.allarme == null || this.allarme.getPlugin() == null) {
            return "Parametri";
        }
        AllarmiContext context = new AllarmiContext(this);
        return ((IAllarmiService)this.service).getParameterSectionTitle((Allarme)this.allarme, (Context)context);
    }

    public boolean isShowParameters() throws Exception {
        if (this.allarme == null || this.allarme.getPlugin() == null) {
            return false;
        }
        AllarmiContext context = new AllarmiContext(this);
        return ((IAllarmiService)this.service).isShowParameters((Allarme)this.allarme, (Context)context);
    }

    public AllarmiBean() {
        try {
            PddMonitorProperties pddMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.alarmEngineConfig = AlarmConfigProperties.getAlarmConfiguration((Logger)log, (String)pddMonitorProperties.getAllarmiConfigurazione(), (String)pddMonitorProperties.getConfDirectory());
            if (AlarmManager.getAlarmEngineConfig() == null) {
                AlarmManager.setAlarmEngineConfig((AlarmEngineConfig)this.alarmEngineConfig);
            }
            this.controlloAllarmiFiltroApiSoggettoErogatore = this.alarmEngineConfig.isOptionsFilterApiOrganization();
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    public boolean isShowFiltroSoggetti() {
        return Utility.isMultitenantAbilitato();
    }

    public boolean isAbilitaGestioneGruppiInConfigurazione() {
        return true;
    }

    public String getDescrizione() {
        if (this.allarme.getPlugin() != null) {
            return this.allarme.getPlugin().getDescrizione();
        }
        return "-";
    }

    public Plugin getPlugin() {
        return this.allarme.getPlugin();
    }

    public void setPlugin(Plugin infoPlugin) {
        this.allarme.setPlugin(infoPlugin);
    }

    public boolean isAllarmiConsultazioneModificaStatoAbilitataAllarmeAttivo() {
        return this.alarmEngineConfig.isOptionsUpdateStateActiveAlarm();
    }

    public boolean isAllarmiConsultazioneModificaStatoAbilitataAllarmePassivo() {
        return this.alarmEngineConfig.isOptionsUpdateStatePassiveAlarm();
    }

    public boolean isAllarmiConsultazioneModificaAckCriteriaAllarmeAttivo() {
        return this.alarmEngineConfig.isOptionsUpdateAckCriteriaActiveAlarm();
    }

    public boolean isAllarmiConsultazioneModificaAckCriteriaAllarmePassivo() {
        return this.alarmEngineConfig.isOptionsUpdateAckCriteriaPassiveAlarm();
    }

    public boolean isAllarmiAssociazioneAcknowledgedStatoAllarme() {
        return this.alarmEngineConfig.isOptionsAcknowledgedStatusAssociation();
    }

    public boolean isAllarmiNotificaMailVisualizzazioneCompleta() {
        return this.alarmEngineConfig.isMailShowAllOptions();
    }

    public boolean isAllarmiMonitoraggioEsternoVisualizzazioneCompleta() {
        return this.alarmEngineConfig.isScriptShowAllOptions();
    }

    public String getLabelStato() {
        return AllarmiUtils.getLabelStato((StatoAllarme)AllarmiConverterUtils.toStatoAllarme((Integer)this.allarme.getStato()));
    }

    public String getLabelPrecedenteStato() {
        return AllarmiUtils.getLabelStato((StatoAllarme)AllarmiConverterUtils.toStatoAllarme((Integer)this.allarme.getStatoPrecedente()));
    }

    public ConfigurazioneAllarmeBean getAllarme() {
        return this.allarme;
    }

    public int getMailAckMode() {
        return this.alarmEngineConfig.isMailCheckAcknowledgedStatus() ? 1 : 0;
    }

    public int getScriptAckMode() {
        return this.alarmEngineConfig.isScriptCheckAcknowledgedStatus() ? 1 : 0;
    }

    public void setModificaStato(int value) {
        StatoAllarme nuovoStato = AllarmiConverterUtils.toStatoAllarme((Integer)value);
        if (this.modificatoInformazioniHistory_statoAllarme != null && !this.modificatoInformazioniHistory_statoAllarme.equals((Object)nuovoStato)) {
            this.modificatoInformazioniHistory = true;
            this.modificatoStato = true;
            this.setModificaAcknowledged(0);
        }
        this.modificatoInformazioniHistory_statoAllarme = nuovoStato;
        this.allarme.setStato(Integer.valueOf(value));
    }

    public int getModificaStato() {
        if (this.allarme.getStato() != null) {
            return this.allarme.getStato();
        }
        return -1;
    }

    public void setModificaDettaglioStato(String nuovoDettaglio) {
        if (this.modificatoInformazioniHistory_dettaglioAllarme != null && !this.modificatoInformazioniHistory_dettaglioAllarme.equals(nuovoDettaglio)) {
            this.modificatoInformazioniHistory = true;
        }
        this.modificatoInformazioniHistory_dettaglioAllarme = nuovoDettaglio;
        this.allarme.setDettaglioStato(nuovoDettaglio);
    }

    public String getModificaDettaglioStato() {
        if (this.allarme.getStato() != null) {
            return this.allarme.getDettaglioStato();
        }
        return null;
    }

    public void setModificaCriteriAck(String nuovoDettaglio) {
        this.allarme.setDettaglioAcknowledged(nuovoDettaglio);
    }

    public String getModificaCriteriAck() {
        return this.allarme.getDettaglioAcknowledged();
    }

    public void setModificaAcknowledged(int nuovoAck) {
        if (this.modificatoInformazioniHistory_ackwoldegmentAllarme != null && this.modificatoInformazioniHistory_ackwoldegmentAllarme != nuovoAck) {
            this.modificatoInformazioniHistory = true;
            this.modificatoAckwoldegment = true;
        }
        this.modificatoInformazioniHistory_ackwoldegmentAllarme = nuovoAck;
        this.allarme.setAcknowledged(Integer.valueOf(nuovoAck));
    }

    public int getModificaAcknowledged() {
        return this.allarme.getAcknowledged();
    }

    public void setAllarme(ConfigurazioneAllarmeBean allarme) {
        this.allarme = allarme;
        this.parameters = null;
        if (allarme.getId() != null && allarme.getId() > 0L) {
            this.modificatoInformazioniHistory = false;
            this.modificatoStato = false;
            this.modificatoAckwoldegment = false;
            this.modificatoInformazioniHistory_statoAllarme = AllarmiConverterUtils.toStatoAllarme((Integer)allarme.getStato());
            this.modificatoInformazioniHistory_dettaglioAllarme = allarme.getDettaglioStato();
            this.modificatoInformazioniHistory_ackwoldegmentAllarme = allarme.getAcknowledged();
            this.statoAllarmePrimaModifica = AllarmiConverterUtils.toStatoAllarme((Integer)allarme.getStato());
        }
    }

    public List<String> getStatusFilterValues() {
        ArrayList<String> f = null;
        if (f == null) {
            f = new ArrayList<String>();
            f.add("Qualsiasi");
            f.add("Non Disabilitato");
            f.add("Ok");
            f.add("Warn");
            f.add("Error");
            f.add("Disabilitato");
        }
        return f;
    }

    public List<String> getStatusFilterValuesWithAck() {
        ArrayList<String> f = null;
        if (f == null) {
            f = new ArrayList<String>();
            f.add("Qualsiasi");
            f.add("Non Disabilitato");
            f.add("Ok");
            f.add("Warn");
            f.add("Warn (Acknowledged)");
            f.add("Warn (Unacknowledged)");
            f.add("Error");
            f.add("Error (Acknowledged)");
            f.add("Error (Unacknowledged)");
            f.add("Disabilitato");
        }
        return f;
    }

    public List<String> getAcknowledgedFilterValues() {
        ArrayList<String> f = null;
        if (f == null) {
            f = new ArrayList<String>();
            f.add("All");
            f.add("Si");
            f.add("No");
        }
        return f;
    }

    public String getTotOk() {
        Long t = this.getTot("Ok", null);
        return t != null ? t.toString() : "0";
    }

    public String getTotWarn() {
        Long t = this.getTot("Warn", null);
        return t != null ? t.toString() : "0";
    }

    public String getTotWarnNoAck() {
        Long t = this.getTot("Warn", 0);
        return t != null ? t.toString() : "0";
    }

    public String getTotWarnAck() {
        Long t = this.getTot("Warn", 1);
        return t != null ? t.toString() : "0";
    }

    public String getTotError() {
        Long t = this.getTot("Error", null);
        return t != null ? t.toString() : "0";
    }

    public String getTotErrorNoAck() {
        Long t = this.getTot("Error", 0);
        return t != null ? t.toString() : "0";
    }

    public String getTotErrorAck() {
        Long t = this.getTot("Error", 1);
        return t != null ? t.toString() : "0";
    }

    public String getTotDisabilitati() {
        Long t = this.getTot("Disabilitato", null);
        return t != null ? t.toString() : "0";
    }

    private Long getTot(String stato, Integer acknowledged) {
        try {
            return ((IAllarmiService)this.service).getCountAllarmiByStato(stato, acknowledged);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public String getTipoPeriodo() {
        if (this.allarme.getTipoPeriodo() != null) {
            TipoPeriodo tp = AllarmiConverterUtils.toTipoPeriodo((String)this.allarme.getTipoPeriodo());
            switch (tp) {
                case M: {
                    return "Minuti";
                }
                case H: {
                    return "Ore";
                }
                case G: {
                    return "Giorni";
                }
            }
        }
        return "Ore";
    }

    public void setTipoPeriodo(String p) {
        if ("Minuti".equals(p)) {
            this.allarme.setTipoPeriodo(AllarmiConverterUtils.toValue((TipoPeriodo)TipoPeriodo.M));
        } else if ("Giorni".equals(p)) {
            this.allarme.setTipoPeriodo(AllarmiConverterUtils.toValue((TipoPeriodo)TipoPeriodo.G));
        } else {
            this.allarme.setTipoPeriodo(AllarmiConverterUtils.toValue((TipoPeriodo)TipoPeriodo.H));
        }
    }

    public List<Parameter<?>> getParameters() {
        if (this.parameters != null) {
            return this.parameters;
        }
        if (this.allarme == null || this.allarme.getTipo() == null) {
            return null;
        }
        try {
            AllarmiContext context = new AllarmiContext(this);
            this.parameters = ((IAllarmiService)this.service).instanceParameters((Allarme)this.allarme, (Context)context);
            block2: for (AllarmeParametro parDB : this.allarme.getAllarmeParametroList()) {
                for (Parameter<?> par : this.parameters) {
                    if (!parDB.getIdParametro().equals(par.getId())) continue;
                    par.setValueAsString(parDB.getValore());
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore. " + e.getMessage()));
        }
        return this.parameters;
    }

    public String filtra() {
        return this.search.filtra();
    }

    public String dettaglioAllarme() {
        return "allarme";
    }

    public String history() {
        this.search.filtra();
        return "visualizzaHistoryAllarme";
    }

    public String salva() {
        try {
            log.debug("Salvataggio Stato Allarme in corso...");
            ConfigurazioneAllarmeBean oldConfigurazioneAllarme = null;
            try {
                oldConfigurazioneAllarme = ((IAllarmiService)this.service).getAllarme(this.allarme.getNome());
            }
            catch (NotFoundException e) {
                log.debug("Allarme non presente");
            }
            catch (ServiceException e) {
                log.debug("Errore durante l'esecuzione del controllo di esistenza dell'allarme");
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore. Riprovare.");
                return null;
            }
            boolean historyCreatoTramiteNotificaCambioStato = false;
            boolean notifyOk = true;
            if (this.modificatoStato) {
                notifyOk = this.notifyChangeState();
                historyCreatoTramiteNotificaCambioStato = true;
            }
            if (!this.modificatoStato) {
                ((IAllarmiService)this.service).store(this.allarme);
            }
            if (this.modificatoInformazioniHistory && !historyCreatoTramiteNotificaCambioStato) {
                this.addHistory();
            }
            try {
                AllarmiUtils.notifyStateActiveThread((boolean)false, (boolean)this.modificatoStato, (boolean)this.modificatoAckwoldegment, (ConfigurazioneAllarmeBean)oldConfigurazioneAllarme, (ConfigurazioneAllarmeBean)this.allarme, (Logger)log, (AlarmEngineConfig)this.alarmEngineConfig);
                if (notifyOk) {
                    MessageUtils.addInfoMsg((String)"Allarme salvato con successo.");
                }
            }
            catch (Exception e) {
                MessageUtils.addErrorMsg((String)("Allarme salvato con successo, ma invio notifica terminato con errore: " + e.getMessage()));
            }
            if (this.ackMode) {
                this.search.ripulisci();
            }
        }
        catch (Exception e) {
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore. Riprovare.");
            log.error(e.getMessage(), (Throwable)e);
        }
        return "success";
    }

    private void addHistory() throws ServiceException, NotImplementedException {
        if (this.alarmEngineConfig.isHistoryEnabled()) {
            AllarmeHistory history = new AllarmeHistory();
            history.setEnabled(this.allarme.getEnabled());
            history.setAcknowledged(this.allarme.getAcknowledged());
            history.setDettaglioStato(this.allarme.getDettaglioStato());
            IdAllarme idConfigurazioneAllarme = new IdAllarme();
            idConfigurazioneAllarme.setNome(this.allarme.getNome());
            history.setIdAllarme(idConfigurazioneAllarme);
            history.setStato(this.allarme.getStato());
            history.setTimestampUpdate(new Date());
            history.setUtente(Utility.getLoggedUtente().getLogin());
            ((IAllarmiService)this.service).addHistory(history);
        }
    }

    public String delete() {
        return null;
    }

    private boolean notifyChangeState() throws AlarmException {
        boolean esito = true;
        try {
            IAlarm alarm = ((IAllarmiService)this.service).getAlarm(this.allarme.getNome());
            AlarmStatusWithAck alarmStatus = new AlarmStatusWithAck();
            StatoAllarme statoAllarme = AllarmiConverterUtils.toStatoAllarme((Integer)this.allarme.getStato());
            switch (statoAllarme) {
                case OK: {
                    alarmStatus.setStatus(AlarmStateValues.OK);
                    break;
                }
                case WARNING: {
                    alarmStatus.setStatus(AlarmStateValues.WARNING);
                    break;
                }
                case ERROR: {
                    alarmStatus.setStatus(AlarmStateValues.ERROR);
                }
            }
            alarmStatus.setDetail(this.allarme.getDettaglioStato());
            if (this.allarme.getAcknowledged() == 1) {
                alarmStatus.setAck(true);
            } else {
                alarmStatus.setAck(false);
            }
            if (alarm instanceof AlarmImpl) {
                ((AlarmImpl)alarm).setUsername(Utility.getLoggedUtente().getLogin());
            }
            alarm.changeStatus((AlarmStatus)alarmStatus);
            log.debug("Notificato cambio di stato all'allarme con nome [" + this.allarme.getNome() + "]");
        }
        catch (AlarmNotifyException notify) {
            esito = false;
            log.error(notify.getMessage(), (Throwable)notify);
            int failed = 0;
            StringBuilder sb = new StringBuilder();
            if (notify.getPluginInvocationError() != null) {
                ++failed;
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append("invocazione del metodo 'changeStatusNotify' ha ritornato l'errore '").append(notify.getPluginInvocationError()).append("'");
            }
            if (notify.getSendMailError() != null) {
                ++failed;
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append("spedizione mail non riuscita '").append(notify.getSendMailError()).append("'");
            }
            if (notify.getScriptInvocationError() != null) {
                ++failed;
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append("invocazione dello script di monitoraggio ha generato l'errore '").append(notify.getScriptInvocationError()).append("'");
            }
            String error = null;
            error = failed == 1 ? "Allarme salvato con successo, ma la seguente notifica di cambio stato \u00e8 fallita: " + sb.toString() : "Allarme salvato con successo, ma le seguenti notifiche di cambio stato sono fallite: " + sb.toString();
            MessageUtils.addErrorMsg((String)error);
        }
        return esito;
    }

    public void toggleAck(ActionEvent ae) {
        try {
            if (this.ack == null) {
                this.setModificaAcknowledged(0);
            } else {
                this.setModificaAcknowledged(Boolean.parseBoolean(this.ack) ? 1 : 0);
            }
            ((IAllarmiService)this.service).store(this.allarme);
            this.addHistory();
            AllarmiUtils.notifyStateActiveThread((boolean)false, (boolean)this.modificatoStato, (boolean)this.modificatoAckwoldegment, (ConfigurazioneAllarmeBean)this.allarme, (ConfigurazioneAllarmeBean)this.allarme, (Logger)log, (AlarmEngineConfig)this.alarmEngineConfig);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String toggleAbilitato() {
        try {
            int val = this.allarme.getEnabled();
            if (val == 0) {
                this.allarme.setEnabled(Integer.valueOf(1));
            } else {
                this.allarme.setEnabled(Integer.valueOf(0));
            }
            ((IAllarmiService)this.service).store(this.allarme);
            this.addHistory();
            AllarmiUtils.notifyStateActiveThread((boolean)false, (boolean)this.modificatoStato, (boolean)this.modificatoAckwoldegment, null, (ConfigurazioneAllarmeBean)this.allarme, (Logger)log, (AlarmEngineConfig)this.alarmEngineConfig);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String getAck() {
        return this.ack;
    }

    public void setAck(String ack) {
        this.ack = ack;
    }

    public void addNewListener(ActionEvent ae) {
        this.allarme = null;
    }

    public String getTipoNomeMittenteFiltro() {
        return AllarmiUtils.getTipoNomeMittente((AllarmeFiltro)this.allarme.getFiltro());
    }

    public String getTipoNomeDestinatarioFiltro() {
        return AllarmiUtils.getTipoNomeDestinatario((AllarmeFiltro)this.allarme.getFiltro());
    }

    public String getTipoNomeServizioFiltro() {
        return AllarmiUtils.getTipoNomeServizio((AllarmeFiltro)this.allarme.getFiltro(), (Logger)log, (boolean)this.controlloAllarmiFiltroApiSoggettoErogatore);
    }

    public String getProtocolloFiltro() {
        if (this.allarme.getFiltro() != null && this.allarme.getFiltro().getProtocollo() != null) {
            try {
                return NamingUtils.getLabelProtocollo((String)this.allarme.getFiltro().getProtocollo());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getNomePortaFiltro() throws Exception {
        if (this.allarme.getFiltro() != null && this.allarme.getFiltro().getNomePorta() != null && this.allarme.getFiltro().getProtocollo() != null) {
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(this.allarme.getFiltro().getProtocollo());
            PorteNamingUtils n = new PorteNamingUtils(protocolFactory);
            switch (this.allarme.getFiltro().getRuoloPorta()) {
                case APPLICATIVA: {
                    return n.normalizePA(this.allarme.getFiltro().getNomePorta());
                }
                case DELEGATA: {
                    return n.normalizePD(this.allarme.getFiltro().getNomePorta());
                }
            }
            return this.allarme.getFiltro().getNomePorta();
        }
        return null;
    }

    public String getRuoloPortaFiltro() {
        if (this.allarme.getFiltro() != null && this.allarme.getFiltro().getRuoloPorta() != null && this.allarme.getFiltro().getNomePorta() == null) {
            try {
                switch (this.allarme.getFiltro().getRuoloPorta()) {
                    case APPLICATIVA: {
                        return "Erogazione";
                    }
                    case DELEGATA: {
                        return "Fruizione";
                    }
                    case ENTRAMBI: {
                        return null;
                    }
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private boolean isAllarmeGlobale() {
        boolean isGlobale = this.allarme.getFiltro() == null || !this.allarme.getFiltro().isEnabled() || this.allarme.getFiltro().getNomePorta() == null;
        return isGlobale;
    }

    private boolean isGroupByEnabled() {
        return this.allarme.getGroupBy() != null && this.allarme.getGroupBy().isEnabled();
    }

    public boolean isVisualizzaRuoloPortaGroupBy() {
        if (this.allarme.isAllarmeConfigurazione()) {
            return this.isAllarmeGlobale() && this.isGroupByEnabled() && this.allarme.getGroupBy().isRuoloPorta();
        }
        return false;
    }

    public boolean isVisualizzaProtocolloGroupBy() throws Exception {
        if (this.allarme.isAllarmeConfigurazione()) {
            List protocolli = Utility.getProtocolli((User)Utility.getLoggedUtente());
            return this.isAllarmeGlobale() && protocolli.size() > 1 && this.isGroupByEnabled() && this.allarme.getGroupBy().isProtocollo();
        }
        return false;
    }

    public boolean isVisualizzaSoggettoErogatoreGroupBy() {
        if (this.allarme.isAllarmeConfigurazione()) {
            return this.isAllarmeGlobale() && this.isGroupByEnabled() && this.allarme.getGroupBy().isErogatore();
        }
        return false;
    }

    public boolean isVisualizzaServizioGroupBy() {
        if (this.allarme.isAllarmeConfigurazione()) {
            return this.isAllarmeGlobale() && this.isGroupByEnabled() && this.allarme.getGroupBy().isServizio();
        }
        return false;
    }

    public boolean isVisualizzaAzioneGroupBy() {
        return this.isGroupByEnabled() && this.allarme.getGroupBy().isAzione();
    }

    public String getLabelAzioneGroupBy() {
        if (this.allarme.getFiltro() != null) {
            boolean configurazione = this.allarme.isAllarmeConfigurazione();
            boolean definedApi = this.allarme.getFiltro().getTipoServizio() != null && this.allarme.getFiltro().getNomeServizio() != null && this.allarme.getFiltro().getVersioneServizio() != null;
            ServiceBinding serviceBinding = null;
            if (configurazione) {
                if (definedApi) {
                    IDSoggetto idSoggetto = new IDSoggetto(this.allarme.getFiltro().getTipoErogatore(), this.allarme.getFiltro().getNomeErogatore());
                    AccordoServizioParteComune accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, this.allarme.getFiltro().getTipoServizio(), this.allarme.getFiltro().getNomeServizio(), this.allarme.getFiltro().getVersioneServizio());
                    serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
                }
            } else if (this.allarme.isRuoloPortaDelegata()) {
                PortaDelegata portaDelegata = this.dynamicUtilsService.getPortaDelegata(this.allarme.getFiltro().getNomePorta());
                IDSoggetto idSoggetto = new IDSoggetto(portaDelegata.getTipoSoggettoErogatore(), portaDelegata.getNomeSoggettoErogatore());
                AccordoServizioParteComune accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, portaDelegata.getTipoServizio(), portaDelegata.getNomeServizio(), portaDelegata.getVersioneServizio());
                serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
            } else if (this.allarme.isRuoloPortaApplicativa()) {
                PortaApplicativa portaApplicativa = this.dynamicUtilsService.getPortaApplicativa(this.allarme.getFiltro().getNomePorta());
                IDSoggetto idSoggetto = new IDSoggetto(portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome());
                AccordoServizioParteComune accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), portaApplicativa.getVersioneServizio());
                serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
            }
            if (serviceBinding != null) {
                if (ServiceBinding.REST.equals(serviceBinding)) {
                    return "Risorsa";
                }
                return "Azione";
            }
        }
        return "Azione";
    }

    public boolean isVisualizzaSoggettoFruitoreGroupBy() {
        return this.isAllarmeGlobale() && this.isGroupByEnabled() && this.allarme.getGroupBy().isFruitore();
    }

    public boolean isVisualizzaServizioApplicativoFruitoreGroupBy() {
        return this.isAllarmeGlobale() && this.isGroupByEnabled() && this.allarme.getGroupBy().isServizioApplicativoFruitore();
    }

    public boolean isVisualizzaIdentificativoAutenticatoGroupBy() {
        return this.isAllarmeGlobale() && this.isGroupByEnabled() && this.allarme.getGroupBy().isIdentificativoAutenticato();
    }

    public boolean isVisualizzaRichiedenteGroupBy() {
        return !this.isAllarmeGlobale() && this.isGroupByEnabled() && (this.allarme.getGroupBy().isFruitore() || this.allarme.getGroupBy().isServizioApplicativoFruitore() || this.allarme.getGroupBy().isIdentificativoAutenticato());
    }

    public boolean isVisualizzaTokenGroupBy() {
        return this.isGroupByEnabled() && StringUtils.isNotEmpty((CharSequence)this.allarme.getGroupBy().getToken());
    }

    public boolean isVisualizzaProfiloFiltro() {
        if (this.allarme.getFiltro() != null && this.allarme.getFiltro().getProtocollo() != null) {
            boolean configurazione = this.allarme.isAllarmeConfigurazione();
            return configurazione && this.search.isShowListaProtocolli();
        }
        return false;
    }

    public boolean isVisualizzaRuoloErogatoreFiltro() {
        boolean configurazione = this.allarme.isAllarmeConfigurazione();
        return configurazione;
    }

    public boolean isVisualizzaSoggettoErogatoreFiltro() {
        boolean configurazione = this.allarme.isAllarmeConfigurazione();
        return configurazione;
    }

    public boolean isVisualizzaTagFiltro() {
        boolean configurazione = this.allarme.isAllarmeConfigurazione();
        return configurazione;
    }

    public boolean isVisualizzaServizioFiltro() {
        boolean configurazione = this.allarme.isAllarmeConfigurazione();
        return configurazione;
    }

    public boolean isVisualizzaAzioneFiltro() {
        boolean definedApi;
        boolean configurazione = this.allarme.isAllarmeConfigurazione();
        boolean showAzione = true;
        boolean bl = definedApi = this.allarme.getFiltro().getTipoServizio() != null && this.allarme.getFiltro().getNomeServizio() != null && this.allarme.getFiltro().getVersioneServizio() != null;
        if (configurazione && !definedApi) {
            showAzione = false;
        }
        return showAzione;
    }

    public boolean isVisualizzaRuoloFruitoreFiltro() {
        if (this.allarme.getFiltro() != null) {
            boolean showRuoloRichiedente = false;
            showRuoloRichiedente = true;
            return (this.allarme.getFiltro().getTipoFruitore() == null || this.allarme.getFiltro().getNomeFruitore() == null) && this.allarme.getFiltro().getServizioApplicativoFruitore() == null && showRuoloRichiedente;
        }
        return false;
    }

    public boolean isVisualizzaSoggettoFruitoreFiltro() {
        boolean configurazione = this.allarme.isAllarmeConfigurazione();
        boolean applicativa = this.allarme.isRuoloPortaApplicativa();
        return configurazione || applicativa;
    }

    public boolean isVisualizzaSaFruitoreFiltro() {
        boolean configurazione = this.allarme.isAllarmeConfigurazione();
        if (this.allarme.getFiltro() != null) {
            return !configurazione || this.allarme.getFiltro().getTipoFruitore() != null && this.allarme.getFiltro().getNomeFruitore() != null;
        }
        return false;
    }

    public String getSaFruitoreFiltro() {
        if (this.allarme.getFiltro() != null) {
            return this.allarme.getFiltro().getServizioApplicativoFruitore();
        }
        return null;
    }

    public String getLabelAzioneFiltro() {
        if (this.allarme.getFiltro() != null) {
            boolean configurazione = this.allarme.isAllarmeConfigurazione();
            boolean definedApi = this.allarme.getFiltro().getTipoServizio() != null && this.allarme.getFiltro().getNomeServizio() != null && this.allarme.getFiltro().getVersioneServizio() != null;
            ServiceBinding serviceBinding = null;
            if (configurazione) {
                if (definedApi) {
                    if (StringUtils.isNotEmpty((CharSequence)this.allarme.getFiltro().getTipoErogatore()) && StringUtils.isNotEmpty((CharSequence)this.allarme.getFiltro().getNomeErogatore())) {
                        IDSoggetto idSoggetto = new IDSoggetto(this.allarme.getFiltro().getTipoErogatore(), this.allarme.getFiltro().getNomeErogatore());
                        AccordoServizioParteComune accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, this.allarme.getFiltro().getTipoServizio(), this.allarme.getFiltro().getNomeServizio(), this.allarme.getFiltro().getVersioneServizio());
                        serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
                    } else {
                        List listServizi = this.dynamicUtilsService.getServizi(this.allarme.getFiltro().getProtocollo(), null, this.allarme.getFiltro().getTipoServizio(), this.allarme.getFiltro().getNomeServizio(), this.allarme.getFiltro().getVersioneServizio(), null);
                        ArrayList<String> uris = new ArrayList<String>();
                        AccordoServizioParteSpecifica aspsRiferimento = null;
                        if (listServizi != null && !listServizi.isEmpty()) {
                            for (IDServizio idS : listServizi) {
                                if (!uris.contains(idS.getUriAccordoServizioParteComune())) {
                                    uris.add(idS.getUriAccordoServizioParteComune());
                                    if (aspsRiferimento == null) {
                                        AccordoServizioParteSpecifica asps;
                                        aspsRiferimento = asps = this.dynamicUtilsService.getAspsFromValues(idS.getTipo(), idS.getNome(), idS.getSoggettoErogatore().getTipo(), idS.getSoggettoErogatore().getNome(), idS.getVersione());
                                    }
                                }
                                if (uris.size() <= 1) continue;
                                break;
                            }
                        }
                        if (uris.size() == 1 && aspsRiferimento != null) {
                            IDSoggetto idSoggetto = new IDSoggetto(aspsRiferimento.getIdErogatore().getTipo(), aspsRiferimento.getIdErogatore().getNome());
                            AccordoServizioParteComune accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, aspsRiferimento.getTipo(), aspsRiferimento.getNome(), aspsRiferimento.getVersione());
                            serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
                        }
                    }
                }
            } else if (this.allarme.isRuoloPortaDelegata()) {
                PortaDelegata portaDelegata = this.dynamicUtilsService.getPortaDelegata(this.allarme.getFiltro().getNomePorta());
                IDSoggetto idSoggetto = new IDSoggetto(portaDelegata.getTipoSoggettoErogatore(), portaDelegata.getNomeSoggettoErogatore());
                AccordoServizioParteComune accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, portaDelegata.getTipoServizio(), portaDelegata.getNomeServizio(), portaDelegata.getVersioneServizio());
                serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
            } else if (this.allarme.isRuoloPortaApplicativa()) {
                PortaApplicativa portaApplicativa = this.dynamicUtilsService.getPortaApplicativa(this.allarme.getFiltro().getNomePorta());
                IDSoggetto idSoggetto = new IDSoggetto(portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome());
                AccordoServizioParteComune accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), portaApplicativa.getVersioneServizio());
                serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
            }
            if (serviceBinding != null) {
                if (ServiceBinding.REST.equals(serviceBinding)) {
                    return "Risorse";
                }
                return "Azioni";
            }
        }
        return "Azioni";
    }

    public String getAzioneFiltro() {
        block23: {
            try {
                if (this.allarme.getFiltro() == null || this.allarme.getFiltro().getAzione() == null) break block23;
                boolean configurazione = this.allarme.isAllarmeConfigurazione();
                boolean definedApi = this.allarme.getFiltro().getTipoServizio() != null && this.allarme.getFiltro().getNomeServizio() != null && this.allarme.getFiltro().getVersioneServizio() != null;
                ServiceBinding serviceBinding = null;
                AccordoServizioParteComune accordoServizio = null;
                if (configurazione) {
                    if (definedApi) {
                        if (StringUtils.isNotEmpty((CharSequence)this.allarme.getFiltro().getTipoErogatore()) && StringUtils.isNotEmpty((CharSequence)this.allarme.getFiltro().getNomeErogatore())) {
                            IDSoggetto idSoggetto = new IDSoggetto(this.allarme.getFiltro().getTipoErogatore(), this.allarme.getFiltro().getNomeErogatore());
                            accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, this.allarme.getFiltro().getTipoServizio(), this.allarme.getFiltro().getNomeServizio(), this.allarme.getFiltro().getVersioneServizio());
                            serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
                        } else {
                            List listServizi = this.dynamicUtilsService.getServizi(this.allarme.getFiltro().getProtocollo(), null, this.allarme.getFiltro().getTipoServizio(), this.allarme.getFiltro().getNomeServizio(), this.allarme.getFiltro().getVersioneServizio(), null);
                            ArrayList<String> uris = new ArrayList<String>();
                            AccordoServizioParteSpecifica aspsRiferimento = null;
                            if (listServizi != null && !listServizi.isEmpty()) {
                                for (IDServizio idS : listServizi) {
                                    if (!uris.contains(idS.getUriAccordoServizioParteComune())) {
                                        uris.add(idS.getUriAccordoServizioParteComune());
                                        if (aspsRiferimento == null) {
                                            AccordoServizioParteSpecifica asps;
                                            aspsRiferimento = asps = this.dynamicUtilsService.getAspsFromValues(idS.getTipo(), idS.getNome(), idS.getSoggettoErogatore().getTipo(), idS.getSoggettoErogatore().getNome(), idS.getVersione());
                                        }
                                    }
                                    if (uris.size() <= 1) continue;
                                    break;
                                }
                            }
                            if (uris.size() == 1) {
                                IDSoggetto idSoggetto = new IDSoggetto(aspsRiferimento.getIdErogatore().getTipo(), aspsRiferimento.getIdErogatore().getNome());
                                accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, aspsRiferimento.getTipo(), aspsRiferimento.getNome(), aspsRiferimento.getVersione());
                                serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
                            }
                        }
                    }
                } else if (this.allarme.isRuoloPortaDelegata()) {
                    PortaDelegata portaDelegata = this.dynamicUtilsService.getPortaDelegata(this.allarme.getFiltro().getNomePorta());
                    idSoggetto = new IDSoggetto(portaDelegata.getTipoSoggettoErogatore(), portaDelegata.getNomeSoggettoErogatore());
                    accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, portaDelegata.getTipoServizio(), portaDelegata.getNomeServizio(), portaDelegata.getVersioneServizio());
                    serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
                } else if (this.allarme.isRuoloPortaApplicativa()) {
                    PortaApplicativa portaApplicativa = this.dynamicUtilsService.getPortaApplicativa(this.allarme.getFiltro().getNomePorta());
                    idSoggetto = new IDSoggetto(portaApplicativa.getIdSoggetto().getTipo(), portaApplicativa.getIdSoggetto().getNome());
                    accordoServizio = this.dynamicUtilsService.getAccordoServizio(this.allarme.getFiltro().getProtocollo(), idSoggetto, portaApplicativa.getTipoServizio(), portaApplicativa.getNomeServizio(), portaApplicativa.getVersioneServizio());
                    serviceBinding = ServiceBinding.valueOf((String)accordoServizio.getServiceBinding().toUpperCase());
                }
                if (serviceBinding == null) break block23;
                if (ServiceBinding.REST.equals(serviceBinding)) {
                    if (!"".equals(this.allarme.getFiltro().getAzione())) {
                        MBeanUtilsService mBeanUtilsService = new MBeanUtilsService(((DynamicUtilsService)this.dynamicUtilsService).getUtilsServiceManager(), log);
                        String[] azioniSelezionateDB = this.allarme.getFiltro().getAzione().split(",");
                        ArrayList<String> l = new ArrayList<String>();
                        if (azioniSelezionateDB != null && azioniSelezionateDB.length > 0) {
                            for (int i = 0; i < azioniSelezionateDB.length; ++i) {
                                String op = azioniSelezionateDB[i];
                                String operazioneLabel = null;
                                IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromValues(accordoServizio.getNome(), accordoServizio.getIdReferente().getTipo(), accordoServizio.getIdReferente().getNome(), accordoServizio.getVersione());
                                List listaInfoCache = mBeanUtilsService.getInfoOperazioneFromCache(op, idAccordo);
                                if (listaInfoCache != null && listaInfoCache.size() == 1) {
                                    Map map = (Map)listaInfoCache.get(0);
                                    String method = (String)map.get(Resource.model().HTTP_METHOD.getFieldName());
                                    String path = (String)map.get(Resource.model().PATH.getFieldName());
                                    StringBuilder bf = new StringBuilder();
                                    if (!"ALL".equals(method)) {
                                        bf.append(method);
                                        bf.append(" ");
                                    }
                                    if (!"*".equals(path)) {
                                        bf.append(path);
                                        operazioneLabel = bf.toString();
                                    }
                                }
                                if (operazioneLabel == null) continue;
                                l.add(operazioneLabel);
                            }
                            if (!l.isEmpty()) {
                                return StringUtils.join((Object[])l.toArray(new String[1]), (String)", ");
                            }
                        }
                    }
                    break block23;
                }
                return this.allarme.getFiltro().getAzione();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.allarme.getFiltro().getAzione();
    }

    public String getAzioneFiltroHTML() {
        String tmp = this.getAzioneFiltro();
        if (tmp != null) {
            if ((tmp = tmp.trim()).contains(",")) {
                String[] split = tmp.split(",");
                if (split != null && split.length > 0) {
                    StringBuilder bf = new StringBuilder();
                    for (int i = 0; i < split.length; ++i) {
                        if (bf.length() > 0) {
                            bf.append("<BR/>");
                        }
                        bf.append(split[i].trim());
                    }
                    return bf.toString();
                }
                return tmp;
            }
            return tmp;
        }
        return null;
    }

    public String getClaimsGroupBy() {
        if (this.allarme.getGroupBy() != null && this.allarme.getGroupBy().getToken() != null) {
            try {
                String[] tokenSelezionatiDB = null;
                if (this.allarme.getGroupBy().getToken() != null && !"".equals(this.allarme.getGroupBy().getToken())) {
                    tokenSelezionatiDB = this.allarme.getGroupBy().getToken().split(",");
                }
                if (tokenSelezionatiDB != null && tokenSelezionatiDB.length > 0) {
                    ArrayList<String> l = new ArrayList<String>();
                    block8: for (int i = 0; i < tokenSelezionatiDB.length; ++i) {
                        TipoCredenzialeMittente tipo = TipoCredenzialeMittente.toEnumConstant((String)tokenSelezionatiDB[i], (boolean)true);
                        switch (tipo) {
                            case TOKEN_SUBJECT: {
                                l.add("Subject");
                                continue block8;
                            }
                            case TOKEN_USERNAME: {
                                l.add("Username");
                                continue block8;
                            }
                            case TOKEN_CLIENT_ID: {
                                l.add("ClientId");
                                continue block8;
                            }
                            case TOKEN_EMAIL: {
                                l.add("eMail");
                                continue block8;
                            }
                        }
                    }
                    if (!l.isEmpty()) {
                        return StringUtils.join((Object[])l.toArray(new String[1]), (String)", ");
                    }
                }
                return this.allarme.getGroupBy().getToken();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String getClaimsGroupByHTML() {
        String tmp = this.getClaimsGroupBy();
        if (tmp != null) {
            if ((tmp = tmp.trim()).contains(",")) {
                String[] split = tmp.split(",");
                if (split != null && split.length > 0) {
                    StringBuilder bf = new StringBuilder();
                    for (int i = 0; i < split.length; ++i) {
                        if (bf.length() > 0) {
                            bf.append("<BR/>");
                        }
                        bf.append(split[i].trim());
                    }
                    return bf.toString();
                }
                return tmp;
            }
            return tmp;
        }
        return null;
    }

    public List<String> nomeAllarmeAutoComplete(Object val) {
        List<String> list = null;
        list = val == null || StringUtils.isEmpty((CharSequence)((String)val)) ? new ArrayList<String>() : ((IAllarmiService)this.service).nomeAllarmeAutoComplete((String)val);
        list.add(0, "--");
        return list;
    }

    public String getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(String selectedTab) {
        this.selectedTab = selectedTab;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public boolean isAckMode() {
        return this.ackMode;
    }

    public void setAckMode(boolean ackMode) {
        this.ackMode = ackMode;
    }

    public boolean isVisualizzaParametri() {
        return this.getParameters() != null && !this.getParameters().isEmpty();
    }

    public void setVisualizzaParametri(boolean visualizzaParametri) {
    }

    public boolean isVisualizzaAck() {
        return this.modificatoStato ? this.isAllarmiAssociazioneAcknowledgedStatoAllarme() || this.allarme.getMail().getInvia() == 1 && this.alarmEngineConfig.isMailCheckAcknowledgedStatus() || this.allarme.getScript().getInvoca() == 1 && this.alarmEngineConfig.isScriptCheckAcknowledgedStatus() : this.allarme.getEnabled() != 0 && this.allarme.getStato() != 0 && (this.isAllarmiAssociazioneAcknowledgedStatoAllarme() || this.allarme.getMail().getInvia() == 1 && this.alarmEngineConfig.isMailCheckAcknowledgedStatus() || this.allarme.getScript().getInvoca() == 1 && this.alarmEngineConfig.isScriptCheckAcknowledgedStatus());
    }

    public void setVisualizzaAck(boolean visualizzaAck) {
    }

    public String dettaglioStatoAllarme() {
        return "dettaglioStatoAllarme";
    }

    public AllarmeHistory getAllarmeHistory() {
        return this.allarmeHistory;
    }

    public void setAllarmeHistory(AllarmeHistory allarmeHistory) {
        this.allarmeHistory = allarmeHistory;
    }

    public Date getDataUltimaModificaStato() {
        if (this.allarme != null) {
            Date lastUpdate = this.allarme.getLasttimestampUpdate();
            try {
                Date d;
                List<AllarmeHistory> list = ((IAllarmiService)this.service).findAllHistory(this.allarme.getId(), 0, 1);
                if (list != null && !list.isEmpty() && (d = list.get(0).getTimestampUpdate()) != null) {
                    return d;
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return lastUpdate;
        }
        return null;
    }

    public org.openspcoop2.web.monitor.core.bean.DialogInfo getCriteriAckDialogInfo() {
        if (this.criteriAckDialogInfo == null) {
            if (this.allarme == null || this.allarme.getPlugin() == null) {
                return null;
            }
            AllarmiContext context = new AllarmiContext(this);
            DialogInfo info = null;
            try {
                info = ((IAllarmiService)this.service).getCriteriAckDialogInfo((Allarme)this.allarme, (Context)context);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (info != null) {
                this.criteriAckDialogInfo = new org.openspcoop2.web.monitor.core.bean.DialogInfo(MessageManager.getInstance().getMessage("allarmi.criteriAcknowledge.label"));
                if (info.getBody() != null && !"".equals(info.getBody())) {
                    this.criteriAckDialogInfo.setHeaderBody(info.getBody());
                } else {
                    this.criteriAckDialogInfo.setHeaderBody(info.getHeaderBody());
                    this.criteriAckDialogInfo.setListBody(info.getListBody());
                }
            }
        }
        return this.criteriAckDialogInfo;
    }

    public void setCriteriAckDialogInfo(org.openspcoop2.web.monitor.core.bean.DialogInfo criteriAckDialogInfo) {
        this.criteriAckDialogInfo = criteriAckDialogInfo;
    }
}

