/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.util.Locale;

public enum GradientAlignment {
    TOP{

        @Override
        public int getBottomRectangleHeight(int imageHeight, int gradientHeight) {
            return Math.max(imageHeight - gradientHeight, 0);
        }

        @Override
        public int getTopRectangleHeight(int imageHeight, int gradientHeight) {
            return 0;
        }
    }
    ,
    MIDDLE{

        @Override
        public int getBottomRectangleHeight(int imageHeight, int gradientHeight) {
            return Math.max((imageHeight - gradientHeight) / 2, 0);
        }

        @Override
        public int getTopRectangleHeight(int imageHeight, int gradientHeight) {
            return this.getBottomRectangleHeight(imageHeight, gradientHeight);
        }
    }
    ,
    BOTTOM{

        @Override
        public int getBottomRectangleHeight(int imageHeight, int gradientHeight) {
            return 0;
        }

        @Override
        public int getTopRectangleHeight(int imageHeight, int gradientHeight) {
            return Math.max(imageHeight - gradientHeight, 0);
        }
    };


    public static final GradientAlignment getByParameter(String string) {
        if (string == null || string.length() == 0) {
            return MIDDLE;
        }
        return GradientAlignment.valueOf(string.toUpperCase(Locale.US));
    }

    public abstract int getTopRectangleHeight(int var1, int var2);

    public abstract int getBottomRectangleHeight(int var1, int var2);
}

