/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.richfaces.model.TreeNode;

public class TreeNodeImpl<T>
implements TreeNode<T> {
    private static final long serialVersionUID = -5498990493803705085L;
    private T data;
    private TreeNode<T> parent;
    private Map<Object, TreeNode<T>> childrenMap = new LinkedHashMap<Object, TreeNode<T>>();

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public TreeNode<T> getChild(Object identifier) {
        return this.childrenMap.get(identifier);
    }

    @Override
    public void addChild(Object identifier, TreeNode<T> child) {
        child.setParent(this);
        this.childrenMap.put(identifier, child);
    }

    @Override
    public void removeChild(Object identifier) {
        TreeNode treeNode = this.childrenMap.remove(identifier);
        if (treeNode != null) {
            treeNode.setParent(null);
        }
    }

    @Override
    public void setData(T data) {
        this.data = data;
    }

    @Override
    public TreeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    @Override
    public Iterator<Map.Entry<Object, TreeNode<T>>> getChildren() {
        return this.childrenMap.entrySet().iterator();
    }

    @Override
    public boolean isLeaf() {
        return this.childrenMap.isEmpty();
    }
}

