/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import java.io.PrintWriter;

final class ServletStreamWriter
extends ServletOutputStream {
    private PrintWriter _writer;
    private byte[] buff = new byte[1024];
    private int point = 0;
    private String _charset;

    public ServletStreamWriter(PrintWriter writer, String charset) {
        this._writer = writer;
        this._charset = charset;
    }

    public ServletStreamWriter(PrintWriter writer) {
        this._writer = writer;
    }

    public void write(int b) throws IOException {
        this.buff[this.point++] = (byte)b;
        if (this.point == this.buff.length) {
            this.point = 0;
            String string = null == this._charset ? new String(this.buff) : new String(this.buff, this._charset);
            this._writer.write(string);
        }
    }

    public String getCharset() {
        return this._charset;
    }

    public void setCharset(String charset) {
        this._charset = charset;
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public void flush() throws IOException {
        if (this.point > 0) {
            String string = null == this._charset ? new String(this.buff, 0, this.point) : new String(this.buff, 0, this.point, this._charset);
            this._writer.write(string);
            this.point = 0;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.flush();
        String string = null == this._charset ? new String(b, off, len) : new String(b, off, len, this._charset);
        this._writer.write(string);
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
    }
}

