/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.ResourceContext;

public class FacesResourceContext
extends ResourceContext {
    FacesContext facesContext;
    ExternalContext externalContext;
    HttpServletResponse response;

    public FacesResourceContext(FacesContext facesContext) {
        this.facesContext = facesContext;
        this.externalContext = facesContext.getExternalContext();
        Object facesResponse = this.externalContext.getResponse();
        if (facesResponse instanceof HttpServletResponse) {
            this.response = (HttpServletResponse)facesResponse;
        }
    }

    @Override
    public void setHeader(String name, String value) {
        if (null != this.response) {
            this.response.setHeader(name, value);
        }
    }

    @Override
    public void setIntHeader(String name, int value) {
        if (null != this.response) {
            this.response.setIntHeader(name, value);
        }
    }

    @Override
    public void setDateHeader(String name, long value) {
        if (null != this.response) {
            this.response.setDateHeader(name, value);
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (null != this.response) {
            return this.response.getOutputStream();
        }
        OutputStream stream = null;
        Object response = this.externalContext.getResponse();
        try {
            Method gW = response.getClass().getMethod("getOutputStream", new Class[0]);
            stream = (OutputStream)gW.invoke(response, new Object[0]);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        return stream;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        if (null != this.response) {
            return this.response.getWriter();
        }
        PrintWriter writer = null;
        Object response = this.externalContext.getResponse();
        try {
            Method gW = response.getClass().getMethod("getWriter", new Class[0]);
            writer = (PrintWriter)gW.invoke(response, new Object[0]);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        return writer;
    }

    @Override
    public String getQueryString() {
        return ((HttpServletRequest)this.externalContext.getRequest()).getQueryString();
    }

    @Override
    public String getPathInfo() {
        return this.externalContext.getRequestPathInfo();
    }

    @Override
    public Object getSessionAttribute(String name) {
        return this.externalContext.getSessionMap().get(name);
    }

    @Override
    public Object getContextAttribute(String name) {
        return this.externalContext.getApplicationMap().get(name);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.externalContext.getResourceAsStream(path);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        return this.externalContext.getResource(path);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        return this.externalContext.getResourcePaths(path);
    }

    @Override
    public String getRequestParameter(String data_parameter) {
        return (String)this.externalContext.getRequestParameterMap().get(data_parameter);
    }

    @Override
    public void setContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    @Override
    public void setContentLength(int contentLength) {
        this.response.setContentLength(contentLength);
    }

    @Override
    public String getInitParameter(String name) {
        return this.externalContext.getInitParameter(name);
    }

    @Override
    public String getServletPath() {
        return this.externalContext.getRequestServletPath();
    }

    @Override
    public void release() {
        super.release();
        this.externalContext = null;
        this.response = null;
        this.facesContext.release();
    }

    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }
}

