/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.lang.reflect.InvocationTargetException;
import javax.faces.FacesException;
import javax.faces.el.MethodNotFoundException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.RendererBase;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.renderkit.compiler.MethodCallElement;
import org.ajax4jsf.renderkit.compiler.RendererInvoker;
import org.ajax4jsf.renderkit.compiler.TemplateContext;

class RendererUtilsInvoker
extends RendererInvoker {
    public RendererUtilsInvoker(String methodName) {
        super(methodName);
    }

    @Override
    public Class<? extends Object> getInvokedClass(TemplateContext context) {
        Object object = this.getInvokedObject(context);
        return object != null ? object.getClass() : RendererUtils.class;
    }

    @Override
    public Object getInvokedObject(TemplateContext context) {
        RendererBase renderer = context.getRenderer();
        return null != renderer ? renderer.getUtils() : null;
    }

    @Override
    void handleInvocationTargetException(TemplateContext context, InvocationTargetException e) {
        String logMessage = Messages.getMessage("METHOD_CALL_ERROR_1", this.methodName, context.getComponent().getId());
        String excMessage = Messages.getMessage("METHOD_CALL_ERROR_2", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()});
        MethodCallElement._log.error((Object)logMessage, (Throwable)e);
        throw new FacesException(excMessage, (Throwable)e);
    }

    @Override
    void handleIllegalAccessException(TemplateContext context, IllegalAccessException e) {
        String logMessage = Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_3", this.methodName, context.getComponent().getId()));
        String excMessage = Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_4", new Object[]{this.methodName, context.getComponent().getId(), e.getCause().getMessage()}));
        MethodCallElement._log.error((Object)logMessage, (Throwable)e);
        throw new FacesException(excMessage, (Throwable)e);
    }

    @Override
    void handleMethodNotFoundException(TemplateContext context) throws MethodNotFoundException {
        String logMessage = Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_5", this.methodName, context.getComponent().getId()));
        String excMessage = Messages.getMessage(Messages.getMessage("METHOD_CALL_ERROR_6", this.methodName));
        MethodCallElement._log.error((Object)logMessage);
        throw new FacesException(excMessage);
    }
}

