/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.org.w3c.tidy;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.ajax4jsf.org.w3c.tidy.Lexer;
import org.ajax4jsf.org.w3c.tidy.StreamIn;

public class StreamInJavaImpl
implements StreamIn {
    private static final int CHARBUF_SIZE = 10;
    private int[] charbuf = new int[10];
    private int bufpos;
    private Reader reader;
    private boolean endOfStream;
    private boolean pushed;
    private int curcol;
    private int lastcol;
    private int curline;
    private int tabsize;
    private int tabs;
    private char[] chars = new char[256];
    private int index = 0;
    private int length = 0;

    public StreamInJavaImpl(Reader in, int tabsize) {
        this.reader = in;
        this.pushed = false;
        this.tabsize = tabsize;
        this.curline = 1;
        this.curcol = 1;
        this.endOfStream = false;
    }

    public StreamInJavaImpl(String content, int tabsize) {
        this.reader = new StringReader(content);
        this.pushed = false;
        this.tabsize = tabsize;
        this.curline = 1;
        this.curcol = 1;
        this.endOfStream = false;
    }

    public StreamInJavaImpl(InputStream stream, String encoding, int tabsize) throws UnsupportedEncodingException {
        this.reader = new InputStreamReader(stream, encoding);
        this.pushed = false;
        this.tabsize = tabsize;
        this.curline = 1;
        this.curcol = 1;
        this.endOfStream = false;
    }

    @Override
    public int readCharFromStream() {
        int c;
        try {
            c = this.readCharFromStreamBuffer();
            if (c < 0) {
                this.endOfStream = true;
            }
        }
        catch (IOException e) {
            this.endOfStream = true;
            return -1;
        }
        return c;
    }

    @Override
    public int readChar() {
        if (this.pushed) {
            int c = this.charbuf[--this.bufpos];
            if (this.bufpos == 0) {
                this.pushed = false;
            }
            if (c == 10) {
                this.curcol = 1;
                ++this.curline;
                return c;
            }
            ++this.curcol;
            return c;
        }
        this.lastcol = this.curcol++;
        if (this.tabs > 0) {
            --this.tabs;
            return 32;
        }
        int c = this.readCharFromStream();
        if (c < 0) {
            this.endOfStream = true;
            return -1;
        }
        if (c == 10) {
            this.curcol = 1;
            ++this.curline;
            return c;
        }
        if (c == 13) {
            c = this.readCharFromStream();
            if (c != 10) {
                if (c != -1) {
                    this.ungetChar(c);
                }
                c = 10;
            }
            this.curcol = 1;
            ++this.curline;
            return c;
        }
        if (c == 9) {
            this.tabs = this.tabsize - (this.curcol - 1) % this.tabsize - 1;
            ++this.curcol;
            c = 32;
            return c;
        }
        ++this.curcol;
        return c;
    }

    @Override
    public void ungetChar(int c) {
        this.pushed = true;
        if (this.bufpos >= 10) {
            System.arraycopy(this.charbuf, 0, this.charbuf, 1, 9);
            --this.bufpos;
        }
        this.charbuf[this.bufpos++] = c;
        if (c == 10) {
            --this.curline;
        }
        this.curcol = this.lastcol;
    }

    @Override
    public boolean isEndOfStream() {
        return this.endOfStream;
    }

    @Override
    public int getCurcol() {
        return this.curcol;
    }

    @Override
    public int getCurline() {
        return this.curline;
    }

    @Override
    public void setLexer(Lexer lexer) {
    }

    private int readCharFromStreamBuffer() throws IOException {
        if (this.index >= this.length) {
            if (this.length < 0) {
                return -1;
            }
            this.length = this.reader.read(this.chars);
            this.index = 0;
        }
        if (this.index < this.length) {
            char c = this.chars[this.index];
            ++this.index;
            return c;
        }
        return -1;
    }
}

