/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.event;

import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.faces.event.FacesEvent;

public class EventsQueue
extends AbstractQueue<FacesEvent> {
    private QueueElement first;
    private QueueElement last;
    private int size = 0;

    @Override
    public FacesEvent poll() {
        FacesEvent element = null;
        if (!this.isEmpty()) {
            element = this.first.getElement();
            this.first = this.first.getPrevious();
            if (null == this.first) {
                this.last = null;
                this.size = 0;
            } else {
                --this.size;
            }
        }
        return element;
    }

    @Override
    public FacesEvent peek() {
        FacesEvent element = null;
        if (!this.isEmpty()) {
            element = this.first.getElement();
        }
        return element;
    }

    @Override
    public boolean offer(FacesEvent element) {
        QueueElement queueElement = new QueueElement(element);
        if (this.isEmpty()) {
            this.first = this.last = queueElement;
        } else {
            this.last.setPrevious(queueElement);
            this.last = queueElement;
        }
        ++this.size;
        return true;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.last = null;
        this.first = null;
    }

    @Override
    public boolean isEmpty() {
        return null == this.first;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<FacesEvent> iterator() {
        return new Iterator<FacesEvent>(){
            private QueueElement current;
            {
                this.current = EventsQueue.this.first;
            }

            @Override
            public boolean hasNext() {
                return null != this.current;
            }

            @Override
            public FacesEvent next() {
                if (null == this.current) {
                    throw new NoSuchElementException();
                }
                FacesEvent event = this.current.getElement();
                this.current = this.current.getPrevious();
                return event;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class QueueElement {
        private QueueElement previous;
        private FacesEvent element;

        public QueueElement(FacesEvent element) {
            this.element = element;
        }

        public void setPrevious(QueueElement previsious) {
            this.previous = previsious;
        }

        public QueueElement getPrevious() {
            return this.previous;
        }

        public FacesEvent getElement() {
            return this.element;
        }
    }
}

