/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.config;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.ajax4jsf.config.FilterBean;
import org.ajax4jsf.config.FilterMapping;
import org.ajax4jsf.config.ServletBean;
import org.ajax4jsf.config.ServletMapping;
import org.ajax4jsf.config.StateHandler;
import org.ajax4jsf.config.StringContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WebappHandler
extends DefaultHandler {
    static final String SERVLET_MAPPING_ELEMENT = "servlet-mapping";
    static final String SERVLET_ELEMENT = "servlet";
    static final String SERVLET_NAME_ELEMENT = "servlet-name";
    static final String SERVLET_CLASS_ELEMENT = "servlet-class";
    static final String FILTER_MAPPING_ELEMENT = "filter-mapping";
    static final String FILTER_ELEMENT = "filter";
    static final String FILTER_NAME_ELEMENT = "filter-name";
    static final String FILTER_CLASS_ELEMENT = "filter-class";
    private List<ServletBean> servlets = new ArrayList<ServletBean>();
    private List<FilterBean> filters = new ArrayList<FilterBean>();
    private List<ServletMapping> servletMappings = new ArrayList<ServletMapping>();
    private List<FilterMapping> filterMappings = new ArrayList<FilterMapping>();
    private ServletBean facesServlet;
    private XMLReader xmlReader;
    static final String URL_PATTERN_ELEMENT = "url-pattern";

    public WebappHandler(XMLReader reader) {
        this.xmlReader = reader;
    }

    public List<FilterBean> getFilters() {
        return this.filters;
    }

    public List<FilterMapping> getFilterMappings() {
        return this.filterMappings;
    }

    public List<ServletBean> getServlets() {
        return this.servlets;
    }

    public List<ServletMapping> getServletMappings() {
        return this.servletMappings;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (SERVLET_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new ServletHandler());
        } else if (SERVLET_MAPPING_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new ServletMappingHandler());
        } else if (FILTER_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new FilterHandler());
        } else if (FILTER_MAPPING_ELEMENT.equals(localName)) {
            this.xmlReader.setContentHandler(new FilterMappingHandler());
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    final class ServletHandler
    extends WebappElementHandler {
        private StringBuilder servletName;
        private StringBuilder servletClass;

        public ServletHandler() {
            super(WebappHandler.this);
            this.servletName = new StringBuilder();
            this.servletClass = new StringBuilder();
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler nextHandler = null;
            if (WebappHandler.SERVLET_NAME_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletName);
            } else if (WebappHandler.SERVLET_CLASS_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletClass);
            }
            return nextHandler;
        }

        @Override
        protected void endLastElement() {
            WebappHandler.this.servlets.add(new ServletBean(this.servletName.toString().trim(), this.servletClass.toString().trim()));
        }
    }

    final class ServletMappingHandler
    extends WebappElementHandler {
        private StringBuilder servletName;
        private StringBuilder urlPattern;

        public ServletMappingHandler() {
            super(WebappHandler.this);
            this.servletName = new StringBuilder();
            this.urlPattern = new StringBuilder();
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler nextHandler = null;
            if (WebappHandler.SERVLET_NAME_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletName);
            } else if (WebappHandler.URL_PATTERN_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.urlPattern);
            }
            return nextHandler;
        }

        @Override
        protected void endLastElement() {
            WebappHandler.this.servletMappings.add(new ServletMapping(this.servletName.toString().trim(), this.urlPattern.toString().trim()));
        }
    }

    public class FilterHandler
    extends WebappElementHandler {
        private StringBuilder filterName;
        private StringBuilder filterClass;

        public FilterHandler() {
            super(WebappHandler.this);
            this.filterName = new StringBuilder();
            this.filterClass = new StringBuilder();
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler handler = null;
            if (WebappHandler.FILTER_CLASS_ELEMENT.equals(localName)) {
                handler = new StringContentHandler(this.getReader(), this, this.filterClass);
            } else if (WebappHandler.FILTER_NAME_ELEMENT.equals(localName)) {
                handler = new StringContentHandler(this.getReader(), this, this.filterName);
            }
            return handler;
        }

        @Override
        protected void endLastElement() {
            WebappHandler.this.filters.add(new FilterBean(this.filterName.toString().trim(), this.filterClass.toString().trim()));
        }
    }

    public class FilterMappingHandler
    extends WebappElementHandler {
        private StringBuilder servletName;
        private StringBuilder urlPattern;
        private StringBuilder filterName;

        public FilterMappingHandler() {
            super(WebappHandler.this);
            this.servletName = new StringBuilder();
            this.urlPattern = new StringBuilder();
            this.filterName = new StringBuilder();
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            StringContentHandler nextHandler = null;
            if (WebappHandler.SERVLET_NAME_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.servletName);
            } else if (WebappHandler.URL_PATTERN_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.urlPattern);
            } else if (WebappHandler.FILTER_NAME_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.filterName);
            }
            return nextHandler;
        }

        @Override
        protected void endLastElement() {
            WebappHandler.this.filterMappings.add(new FilterMapping(this.filterName.toString().trim(), this.servletName.toString().trim(), this.urlPattern.toString().trim()));
        }
    }

    private abstract class WebappElementHandler
    extends StateHandler {
        public WebappElementHandler(ContentHandler parentHandler) {
            super(parentHandler);
        }

        @Override
        protected XMLReader getReader() {
            return WebappHandler.this.xmlReader;
        }
    }
}

